/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.special;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.loops.IterableLoopFactory;
import builderb0y.scripting.bytecode.loops.IteratorLoopFactory;
import builderb0y.scripting.bytecode.loops.LoopFactory;
import builderb0y.scripting.bytecode.loops.MapLoopFactory;
import builderb0y.scripting.bytecode.loops.RandomAccessListLoopFactory;
import builderb0y.scripting.bytecode.loops.RangeLoopFactory;
import builderb0y.scripting.bytecode.loops.SequentialListLoopFactory;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclarationInsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ExpressionReader;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.MultiParameterSyntax;
import builderb0y.scripting.util.TypeInfos;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.jetbrains.annotations.Nullable;

public class ForLoopSyntax {
    public static InsnTree parse(ExpressionParser parser) throws ScriptParsingException {
        ScopeContext.LoopName loopName = ScopeContext.LoopName.of(parser.input.readIdentifierOrNullAfterWhitespace());
        parser.input.expectAfterWhitespace('(');
        parser.environment.user().push();
        ExpressionReader.CursorPos afterOpen = parser.input.getCursor();
        InsnTree result = ForLoopSyntax.tryParseEnhanced(parser, loopName);
        if (result != null) {
            parser.input.expectAfterWhitespace(')');
            parser.environment.user().pop();
            return result;
        }
        parser.environment.user().pop();
        parser.environment.user().push();
        parser.input.setCursor(afterOpen);
        InsnTree initializer = parser.nextScript();
        parser.input.expectOperatorAfterWhitespace(",");
        ConditionTree condition = InsnTrees.condition(parser, parser.nextScript());
        parser.input.expectOperatorAfterWhitespace(",");
        InsnTree incrementer = parser.nextScript();
        parser.input.expectOperatorAfterWhitespace(":");
        InsnTree body = parser.nextScript();
        parser.input.expectAfterWhitespace(')');
        parser.environment.user().pop();
        return InsnTrees.for_(loopName, initializer, condition, incrementer, body.asStatement());
    }

    @Nullable
    public static InsnTree tryParseEnhanced(ExpressionParser parser, ScopeContext.LoopName loopName) throws ScriptParsingException {
        ArrayList<LazyVarInfo> variables = new ArrayList<LazyVarInfo>(4);
        do {
            String typeName;
            if ((typeName = parser.input.readIdentifierOrNullAfterWhitespace()) == null) {
                return null;
            }
            TypeInfo type = parser.environment.getType(parser, typeName);
            if (type == null) {
                return null;
            }
            if (parser.input.hasOperatorAfterWhitespace("*")) {
                for (String varName : MultiParameterSyntax.parse(parser).names()) {
                    parser.environment.user().reserveVariable(varName, type);
                    variables.add(new LazyVarInfo(varName, type));
                }
            } else {
                String varName = parser.input.readIdentifierOrNullAfterWhitespace();
                if (varName == null) {
                    return null;
                }
                parser.environment.user().reserveVariable(varName, type);
                variables.add(new LazyVarInfo(varName, type));
            }
            if (!parser.input.hasIdentifierAfterWhitespace("in")) continue;
            LoopFactory loopFactory = ForLoopSyntax.tryParseRange(parser);
            if (loopFactory == null) {
                InsnTree iterable = parser.nextScript();
                if (iterable.getTypeInfo().extendsOrImplements(InsnTrees.type(Iterable.class))) {
                    loopFactory = iterable.getTypeInfo().extendsOrImplements(InsnTrees.type(List.class)) ? (iterable.getTypeInfo().extendsOrImplements(InsnTrees.type(RandomAccess.class)) ? new RandomAccessListLoopFactory(iterable) : new SequentialListLoopFactory(iterable)) : new IterableLoopFactory(iterable);
                } else if (iterable.getTypeInfo().extendsOrImplements(InsnTrees.type(Map.class))) {
                    loopFactory = new MapLoopFactory(iterable);
                } else if (iterable.getTypeInfo().extendsOrImplements(InsnTrees.type(Iterator.class))) {
                    loopFactory = new IteratorLoopFactory(iterable);
                } else {
                    throw new ScriptParsingException("in clause must be of type Iterable, Iterator, Map, or range", parser.input);
                }
            }
            List<VariableDeclarationInsnTree> declarations = variables.stream().peek(variable -> parser.environment.user().assignVariable(variable.name)).map(VariableDeclarationInsnTree::new).toList();
            return switch (parser.input.readOperatorAfterWhitespace()) {
                case ":" -> loopFactory.createLoop(parser, loopName, declarations, parser.nextScript().asStatement());
                case "," -> {
                    InsnTree body = ForLoopSyntax.tryParseEnhanced(parser, loopName);
                    if (body == null) {
                        throw new ScriptParsingException("Expected next variable declaration", parser.input);
                    }
                    yield loopFactory.createLoop(parser, loopName, declarations, body);
                }
                default -> throw new ScriptParsingException("Expected ':' or ','", parser.input);
            };
        } while (parser.input.hasOperatorAfterWhitespace(","));
        return null;
    }

    @Nullable
    public static RangeLoopFactory tryParseRange(ExpressionParser parser) throws ScriptParsingException {
        ExpressionReader.CursorPos afterIn = parser.input.getCursor();
        boolean hasMinus = parser.input.hasOperatorAfterWhitespace("-");
        if (parser.input.hasIdentifierAfterWhitespace("range")) {
            InsnTree step;
            boolean lowerBoundInclusive = switch (parser.input.readAfterWhitespace()) {
                case '[' -> true;
                case '(' -> false;
                default -> throw new ScriptParsingException("Expected '[' or '('", parser.input);
            };
            parser.environment.user().push();
            InsnTree lowerBound = parser.nextScript();
            lowerBound = lowerBound.cast(parser, TypeInfos.widenToInt(lowerBound.getTypeInfo()), InsnTree.CastMode.IMPLICIT_THROW, false);
            parser.input.expectOperatorAfterWhitespace(",");
            InsnTree upperBound = parser.nextScript();
            upperBound = upperBound.cast(parser, TypeInfos.widenToInt(upperBound.getTypeInfo()), InsnTree.CastMode.IMPLICIT_THROW, false);
            if (upperBound.getTypeInfo().getSort() != lowerBound.getTypeInfo().getSort()) {
                throw new ScriptParsingException("Range bounds must have the same type", parser.input);
            }
            boolean upperBoundInclusive = switch (parser.input.readAfterWhitespace()) {
                case ']' -> true;
                case ')' -> false;
                default -> throw new ScriptParsingException("Expected ']' or ')'", parser.input);
            };
            parser.environment.user().pop();
            if (parser.input.hasOperatorAfterWhitespace("%")) {
                step = parser.nextExponent();
                if ((step = step.cast(parser, TypeInfos.widenToInt(step.getTypeInfo()), InsnTree.CastMode.IMPLICIT_THROW, false)).getTypeInfo().getSort() != lowerBound.getTypeInfo().getSort()) {
                    throw new ScriptParsingException("Step type must match bound types", parser.input);
                }
            } else {
                step = InsnTrees.ldc(1, lowerBound.getTypeInfo());
            }
            return new RangeLoopFactory(!hasMinus, lowerBound, lowerBoundInclusive, upperBound, upperBoundInclusive, step);
        }
        parser.input.setCursor(afterIn);
        return null;
    }
}

