/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.special;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.CodeBlock;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public record NamedValues(NamedValue[] values, boolean hasNewVariables) implements CodeBlock
{
    public static NamedValues parse(ExpressionParser parser, @Nullable TypeInfo valueType, @Nullable NameChecker nameChecker) throws ScriptParsingException {
        parser.beginCodeBlock();
        ArrayList<NamedValue> namedValues = new ArrayList<NamedValue>(8);
        if (parser.input.peekAfterWhitespace() != ')') {
            do {
                String name = parser.input.expectIdentifierAfterWhitespace();
                if (nameChecker != null) {
                    nameChecker.checkName(parser, name);
                }
                parser.input.expectOperatorAfterWhitespace(":");
                InsnTree value = parser.nextScript();
                if (valueType != null) {
                    value = value.cast(parser, valueType, InsnTree.CastMode.IMPLICIT_THROW, false);
                }
                namedValues.add(new NamedValue(name, value));
            } while (parser.input.hasOperatorAfterWhitespace(","));
            if (parser.input.peekAfterWhitespace() != ')') {
                throw new ScriptParsingException("Expected ',' or ')'", parser.input);
            }
        }
        boolean hasNewVariables = parser.endCodeBlock();
        return new NamedValues(namedValues.toArray(new NamedValue[namedValues.size()]), hasNewVariables);
    }

    public record NamedValue(String name, InsnTree value) {
        public static final NamedValue[] EMPTY_ARRAY = new NamedValue[0];
    }

    @FunctionalInterface
    public static interface NameChecker {
        public void checkName(ExpressionParser var1, String var2) throws ScriptParsingException;
    }
}

