/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.util;

import org.jetbrains.annotations.NotNull;

public record StringSimilarity(double value) implements Comparable<StringSimilarity>
{
    public static final StringSimilarity NO_MATCH = new StringSimilarity(0.0);

    public static StringSimilarity compare(String query, String base) {
        int queryLength = query.length();
        int baseLength = base.length();
        double similarity = 0.0;
        int offset = -queryLength;
        while (++offset < baseLength) {
            int minQuery = Math.max(0, -offset);
            int maxQuery = Math.min(queryLength, baseLength - offset);
            int run = 0;
            for (int queryIndex = minQuery; queryIndex < maxQuery; ++queryIndex) {
                if (Character.toLowerCase(query.charAt(queryIndex)) == Character.toLowerCase(base.charAt(queryIndex + offset))) {
                    ++run;
                    continue;
                }
                similarity += (double)(run * run);
                run = 0;
            }
            similarity += (double)(run * run);
        }
        return similarity == 0.0 ? NO_MATCH : new StringSimilarity(similarity / (double)(queryLength * baseLength));
    }

    @Override
    public int compareTo(@NotNull StringSimilarity that) {
        return Double.compare(this.value, that.value);
    }
}

