/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.util;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class TypeInfos {
    @NotNull
    public static final TypeInfo OBJECT = TypeInfo.of(Object.class);
    @NotNull
    public static final TypeInfo ENUM = TypeInfo.of(Enum.class);
    @NotNull
    public static final TypeInfo RECORD = TypeInfo.of(Record.class);
    @NotNull
    public static final TypeInfo STRING = TypeInfo.of(String.class);
    @NotNull
    public static final TypeInfo THROWABLE = TypeInfo.of(Throwable.class);
    @NotNull
    public static final TypeInfo NUMBER = TypeInfo.of(Number.class);
    @NotNull
    public static final TypeInfo COMPARABLE = TypeInfo.of(Comparable.class);
    @NotNull
    public static final TypeInfo CLASS = TypeInfo.of(Class.class);
    @NotNull
    public static final TypeInfo ITERABLE = TypeInfo.of(Iterable.class);
    @NotNull
    public static final TypeInfo ITERATOR = TypeInfo.of(Iterator.class);
    @NotNull
    public static final TypeInfo MAP = TypeInfo.of(Map.class);
    @NotNull
    public static final TypeInfo VOID = TypeInfo.of(Void.TYPE);
    @NotNull
    public static final TypeInfo BOOLEAN = TypeInfo.of(Boolean.TYPE);
    @NotNull
    public static final TypeInfo BYTE = TypeInfo.of(Byte.TYPE);
    @NotNull
    public static final TypeInfo CHAR = TypeInfo.of(Character.TYPE);
    @NotNull
    public static final TypeInfo SHORT = TypeInfo.of(Short.TYPE);
    @NotNull
    public static final TypeInfo INT = TypeInfo.of(Integer.TYPE);
    @NotNull
    public static final TypeInfo LONG = TypeInfo.of(Long.TYPE);
    @NotNull
    public static final TypeInfo FLOAT = TypeInfo.of(Float.TYPE);
    @NotNull
    public static final TypeInfo DOUBLE = TypeInfo.of(Double.TYPE);
    @NotNull
    public static final TypeInfo VOID_WRAPPER = TypeInfo.of(Void.class);
    @NotNull
    public static final TypeInfo BOOLEAN_WRAPPER = TypeInfo.of(Boolean.class);
    @NotNull
    public static final TypeInfo BYTE_WRAPPER = TypeInfo.of(Byte.class);
    @NotNull
    public static final TypeInfo CHAR_WRAPPER = TypeInfo.of(Character.class);
    @NotNull
    public static final TypeInfo SHORT_WRAPPER = TypeInfo.of(Short.class);
    @NotNull
    public static final TypeInfo INT_WRAPPER = TypeInfo.of(Integer.class);
    @NotNull
    public static final TypeInfo LONG_WRAPPER = TypeInfo.of(Long.class);
    @NotNull
    public static final TypeInfo FLOAT_WRAPPER = TypeInfo.of(Float.class);
    @NotNull
    public static final TypeInfo DOUBLE_WRAPPER = TypeInfo.of(Double.class);
    public static final Map<TypeInfo, TypeInfo> BOXING = Map.of(VOID, VOID_WRAPPER, BOOLEAN, BOOLEAN_WRAPPER, BYTE, BYTE_WRAPPER, CHAR, CHAR_WRAPPER, SHORT, SHORT_WRAPPER, INT, INT_WRAPPER, LONG, LONG_WRAPPER, FLOAT, FLOAT_WRAPPER, DOUBLE, DOUBLE_WRAPPER);
    public static final Map<TypeInfo, TypeInfo> UNBOXING = Map.of(VOID_WRAPPER, VOID, BOOLEAN_WRAPPER, BOOLEAN, BYTE_WRAPPER, BYTE, CHAR_WRAPPER, CHAR, SHORT_WRAPPER, SHORT, INT_WRAPPER, INT, LONG_WRAPPER, LONG, FLOAT_WRAPPER, FLOAT, DOUBLE_WRAPPER, DOUBLE);

    public static void checkNumber(TypeInfo type) {
        if (!type.isNumber()) {
            throw new InvalidOperandException("Expected number type, got " + String.valueOf(type));
        }
    }

    public static TypeInfo widenUntilSame(TypeInfo first, TypeInfo second) {
        TypeInfos.checkNumber(first);
        TypeInfos.checkNumber(second);
        return TypeInfo.Sort.VALUES[Math.max((int)first.getSort().ordinal(), (int)second.getSort().ordinal())].canonicalInstance;
    }

    public static TypeInfo widenUntilSame(Stream<TypeInfo> stream) {
        return TypeInfo.Sort.VALUES[stream.peek((Consumer<TypeInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, checkNumber(builderb0y.scripting.bytecode.TypeInfo ), (Lbuilderb0y/scripting/bytecode/TypeInfo;)V)()).mapToInt((ToIntFunction<TypeInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$widenUntilSame$0(builderb0y.scripting.bytecode.TypeInfo ), (Lbuilderb0y/scripting/bytecode/TypeInfo;)I)()).max().orElseThrow()].canonicalInstance;
    }

    public static TypeInfo widenUntilSameInt(TypeInfo first, TypeInfo second) {
        TypeInfos.checkNumber(first);
        TypeInfos.checkNumber(second);
        return TypeInfo.Sort.VALUES[Math.max((int)Math.max((int)first.getSort().ordinal(), (int)second.getSort().ordinal()), (int)TypeInfo.Sort.INT.ordinal())].canonicalInstance;
    }

    public static TypeInfo widenUntilSameInt(Stream<TypeInfo> stream) {
        return TypeInfo.Sort.VALUES[Math.max((int)stream.peek((Consumer<TypeInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, checkNumber(builderb0y.scripting.bytecode.TypeInfo ), (Lbuilderb0y/scripting/bytecode/TypeInfo;)V)()).mapToInt((ToIntFunction<TypeInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$widenUntilSameInt$0(builderb0y.scripting.bytecode.TypeInfo ), (Lbuilderb0y/scripting/bytecode/TypeInfo;)I)()).max().orElseThrow(), (int)TypeInfo.Sort.INT.ordinal())].canonicalInstance;
    }

    public static TypeInfo widenToInt(TypeInfo type) {
        TypeInfos.checkNumber(type);
        return TypeInfo.Sort.VALUES[Math.max((int)type.getSort().ordinal(), (int)TypeInfo.Sort.INT.ordinal())].canonicalInstance;
    }

    public static TypeInfo box(TypeInfo info) {
        return BOXING.getOrDefault(info, info);
    }

    public static TypeInfo unbox(TypeInfo info) {
        return UNBOXING.getOrDefault(info, info);
    }

    private static /* synthetic */ int lambda$widenUntilSameInt$0(TypeInfo type) {
        return type.getSort().ordinal();
    }

    private static /* synthetic */ int lambda$widenUntilSame$0(TypeInfo type) {
        return type.getSort().ordinal();
    }
}

