/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.blocks;

import builderb0y.bigglobe.blocks.BigGlobeBlocks;
import builderb0y.bigglobe.blocks.RopeAnchorBlock;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.items.BigGlobeItems;
import builderb0y.bigglobe.mixins.FallingBlockEntity_DestroyOnLandingAccess;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.versions.ActionResultVersions;
import builderb0y.bigglobe.versions.BlockStateVersions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SpelunkingRopeBlock
extends class_2346 {
    public static final class_265 NORTH_SHAPE = class_259.method_31943((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)0.25);
    public static final class_265 EAST_SHAPE = class_259.method_31943((double)0.75, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
    public static final class_265 SOUTH_SHAPE = class_259.method_31943((double)0.375, (double)0.0, (double)0.75, (double)0.625, (double)1.0, (double)1.0);
    public static final class_265 WEST_SHAPE = class_259.method_31943((double)0.0, (double)0.0, (double)0.375, (double)0.25, (double)1.0, (double)0.625);
    public static final class_265 NORTH_EXTRUSION = class_259.method_31943((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)0.25, (double)0.25);
    public static final class_265 EAST_EXTRUSION = class_259.method_31943((double)0.75, (double)0.0, (double)0.375, (double)1.0, (double)0.25, (double)0.625);
    public static final class_265 SOUTH_EXTRUSION = class_259.method_31943((double)0.375, (double)0.0, (double)0.75, (double)0.625, (double)0.25, (double)1.0);
    public static final class_265 WEST_EXTRUSION = class_259.method_31943((double)0.0, (double)0.0, (double)0.375, (double)0.25, (double)0.25, (double)0.625);
    public static final MapCodec<SpelunkingRopeBlock> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(SpelunkingRopeBlock.class);

    public MapCodec method_53969() {
        return CODEC;
    }

    public SpelunkingRopeBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.bigglobe.spelunking_rope.tooltip"));
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2350 ropeDirection;
        class_2338 anchorPos;
        class_2680 anchorState;
        class_2338 upPos = pos.method_10084();
        class_2680 upState = world.method_8320(upPos);
        if (upState == state) {
            return;
        }
        if (this.isExtrusionClear((class_4538)world, upPos, upState, (class_2350)state.method_11654((class_2769)class_2741.field_12481)) && (anchorState = world.method_8320(anchorPos = upPos.method_10093(ropeDirection = (class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_26204() == BigGlobeBlocks.ROPE_ANCHOR && ((Boolean)anchorState.method_11654((class_2769)RopeAnchorBlock.HAS_ROPE)).booleanValue() && anchorState.method_11654((class_2769)class_2741.field_12481) == ropeDirection.method_10153()) {
            return;
        }
        this.method_10132(class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)state));
    }

    public void method_10132(class_1540 entity) {
        ((FallingBlockEntity_DestroyOnLandingAccess)entity).setDestroyOnLanding(true);
    }

    public void method_10129(class_1937 world, class_2338 pos, class_1540 fallingBlockEntity) {
        class_3218 serverWorld;
        if (world instanceof class_3218 && (serverWorld = (class_3218)world).method_64395().method_8355(class_1928.field_19392)) {
            world.method_8649((class_1297)new class_1542(world, fallingBlockEntity.method_23317(), fallingBlockEntity.method_23318(), fallingBlockEntity.method_23321(), new class_1799((class_1935)BigGlobeItems.SPELUNKING_ROPE)));
        }
    }

    public int method_26154() {
        return 1;
    }

    @Deprecated
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_3727 entityContext;
        if (context instanceof class_3727 && (entityContext = (class_3727)context).method_32480() instanceof class_1540) {
            return class_259.method_1073();
        }
        return super.method_9549(state, world, pos, context);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 upPos = context.method_8037().method_10084();
        class_2680 upState = context.method_8045().method_8320(upPos);
        if (upState.method_26204() == this) {
            return upState;
        }
        class_265 upShape = upState.method_26220((class_1922)context.method_8045(), upPos);
        for (class_2350 direction : Directions.HORIZONTAL) {
            class_2338 sidePos = upPos.method_10093(direction);
            class_2680 sideState = context.method_8045().method_8320(sidePos);
            if (sideState.method_26204() != BigGlobeBlocks.ROPE_ANCHOR || sideState.method_11654((class_2769)class_2741.field_12481) != direction.method_10153() || !this.isExtrusionClear(upShape, direction)) continue;
            return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)direction);
        }
        return null;
    }

    @Deprecated
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            case class_2350.field_11036, class_2350.field_11033 -> throw new IllegalStateException();
        };
    }

    public boolean isExtrusionClear(class_4538 world, class_2338 pos, class_2350 direction) {
        return this.isExtrusionClear(world, pos, world.method_8320(pos), direction);
    }

    public boolean isExtrusionClear(class_4538 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return this.isExtrusionClear(state.method_26220((class_1922)world, pos), direction);
    }

    public boolean isExtrusionClear(class_265 shape, class_2350 direction) {
        return !class_259.method_1074((class_265)shape, (class_265)this.getExtrusionShape(direction), (class_247)class_247.field_16896);
    }

    public class_265 getExtrusionShape(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> NORTH_EXTRUSION;
            case class_2350.field_11034 -> EAST_EXTRUSION;
            case class_2350.field_11035 -> SOUTH_EXTRUSION;
            case class_2350.field_11039 -> WEST_EXTRUSION;
            case class_2350.field_11036, class_2350.field_11033 -> throw new IllegalStateException();
        };
    }

    public class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_7909() == BigGlobeItems.SPELUNKING_ROPE) {
            class_2338.class_2339 mutablePos = pos.method_25503().method_10100(0, -1, 0);
            if (this.placeRopesAuto(world, mutablePos, state, player, stack)) {
                this.playPlacementSound(player, world, pos);
                return ActionResultVersions.ITEM_SUCCESS;
            }
            return ActionResultVersions.ITEM_FAIL;
        }
        return ActionResultVersions.ITEM_PASS;
    }

    public boolean placeRopesAuto(class_1937 world, class_2338.class_2339 mutablePos, class_2680 toPlace, class_1657 player, class_1799 stack) {
        if (world.method_8608()) {
            return this.placeRopesSimulate(world, mutablePos, toPlace);
        }
        if (player.method_7337()) {
            return this.placeRopesCreative(world, mutablePos, toPlace);
        }
        return this.placeRopesSurvival(world, mutablePos, toPlace, stack);
    }

    public boolean placeRopesSurvival(class_1937 world, class_2338.class_2339 mutablePos, class_2680 toPlace, class_1799 stack) {
        boolean placedAny = false;
        if (!stack.method_7960()) {
            class_2680 toReplace;
            class_2791 chunk = world.method_22350((class_2338)mutablePos);
            while (chunk.method_8320((class_2338)mutablePos) == toPlace) {
                mutablePos.method_33098(mutablePos.method_10264() - 1);
            }
            while (!world.method_31606((class_2338)mutablePos) && BlockStateVersions.isReplaceable(toReplace = chunk.method_8320((class_2338)mutablePos)) && toReplace.method_26227().method_15769()) {
                world.method_8652((class_2338)mutablePos, toPlace, 3);
                stack.method_7934(1);
                placedAny = true;
                mutablePos.method_33098(mutablePos.method_10264() - 1);
                if (!stack.method_7960()) continue;
            }
        }
        return placedAny;
    }

    public boolean placeRopesCreative(class_1937 world, class_2338.class_2339 mutablePos, class_2680 toPlace) {
        class_2680 toReplace;
        boolean placedAny = false;
        class_2791 chunk = world.method_22350((class_2338)mutablePos);
        while (chunk.method_8320((class_2338)mutablePos) == toPlace) {
            mutablePos.method_33098(mutablePos.method_10264() - 1);
        }
        while (!world.method_31606((class_2338)mutablePos) && BlockStateVersions.isReplaceable(toReplace = chunk.method_8320((class_2338)mutablePos)) && toReplace.method_26227().method_15769()) {
            world.method_8652((class_2338)mutablePos, toPlace, 3);
            placedAny = true;
            mutablePos.method_33098(mutablePos.method_10264() - 1);
        }
        return placedAny;
    }

    public boolean placeRopesSimulate(class_1937 world, class_2338.class_2339 mutablePos, class_2680 toPlace) {
        class_2680 prevState;
        class_2791 chunk = world.method_22350((class_2338)mutablePos);
        while ((prevState = chunk.method_8320((class_2338)mutablePos)) == toPlace) {
            mutablePos.method_33098(mutablePos.method_10264() - 1);
        }
        return !world.method_31606((class_2338)mutablePos) && BlockStateVersions.isReplaceable(prevState) && prevState.method_26227().method_15769();
    }

    public void playPlacementSound(class_1657 player, class_1937 world, class_2338 pos) {
        world.method_8396(player, pos, this.field_23162.method_10598(), class_3419.field_15245, this.field_23162.field_11540, this.field_23162.field_11539);
    }

    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Deprecated
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
    }

    @Deprecated
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
    }
}

