/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.chunkgen.scripted;

import builderb0y.bigglobe.chunkgen.scripted.ObjectSegmentList;
import builderb0y.bigglobe.chunkgen.scripted.SegmentList;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractObjectSegmentList<T_Value, T_Segment extends ObjectSegment<T_Value>>
extends SegmentList<T_Segment> {
    public AbstractObjectSegmentList(int minY, int maxY) {
        super(minY, maxY);
    }

    public T_Value[] flatten(IntFunction<T_Value[]> arrayConstructor) {
        int arraySize = this.maxY - this.minY;
        if (arraySize < 0 || ++arraySize < 0) {
            throw new OutOfMemoryError("SegmentList covers too big of a Y range for flattening.");
        }
        T_Value[] array = arrayConstructor.apply(arraySize);
        int size = this.size();
        for (int segmentIndex = 0; segmentIndex < size; ++segmentIndex) {
            ObjectSegment segment = (ObjectSegment)this.get(segmentIndex);
            int minIndex = segment.minY - this.minY;
            int maxIndex = segment.maxY - this.minY;
            Object object = segment.value;
            for (int objectIndex = minIndex; objectIndex <= maxIndex; ++objectIndex) {
                array[objectIndex] = object;
            }
        }
        return array;
    }

    public static <T_Segment> T_Segment segment(Object[] array, int index) {
        return (T_Segment)array[index];
    }

    public void fillEmptySpace(T_Value object) {
        if (this.isEmpty()) {
            this.add(this.newSegment(this.minY, this.maxY, object));
        } else {
            ObjectSegment lowSegment;
            int size = this.size();
            Object[] oldArray = this.a;
            Object[] newArray = new Object[size << 1 | 1];
            int readIndex = 0;
            int writeIndex = 0;
            ObjectSegment segment = (ObjectSegment)AbstractObjectSegmentList.segment(oldArray, 0);
            if (segment.minY > this.minY) {
                newArray[writeIndex++] = this.newSegment(this.minY, segment.minY - 1, object);
            }
            while (true) {
                lowSegment = (ObjectSegment)AbstractObjectSegmentList.segment(oldArray, readIndex++);
                newArray[writeIndex++] = lowSegment;
                if (readIndex >= size) break;
                ObjectSegment highSegment = (ObjectSegment)AbstractObjectSegmentList.segment(oldArray, readIndex);
                if (highSegment.minY == lowSegment.maxY + 1) continue;
                newArray[writeIndex++] = this.newSegment(lowSegment.maxY + 1, highSegment.minY - 1, object);
            }
            if (this.maxY != lowSegment.maxY + 1) {
                newArray[writeIndex++] = this.newSegment(lowSegment.maxY + 1, this.maxY, object);
            }
            ((ObjectSegmentList)this).a = newArray;
            this.size = writeIndex;
        }
    }

    @Nullable
    public T_Segment addSegment(int minY, int maxY, T_Value object) {
        ObjectSegment segment = (ObjectSegment)this.addSegment(minY, maxY);
        if (segment != null) {
            segment.value = object;
        }
        return (T_Segment)segment;
    }

    @Override
    public T_Segment addSegment(T_Segment segment) {
        ObjectSegment result = (ObjectSegment)super.addSegment(segment);
        if (result != null) {
            result.value = ((ObjectSegment)segment).value;
        }
        return (T_Segment)result;
    }

    @Nullable
    public T_Value getOverlappingObject(int y) {
        ObjectSegment segment = (ObjectSegment)this.getOverlappingSegment(y);
        return segment != null ? (T_Value)segment.value : null;
    }

    public T_Segment newSegment(int minY, int maxY, T_Value value) {
        ObjectSegment segment = (ObjectSegment)this.newSegment(minY, maxY);
        segment.value = value;
        return (T_Segment)segment;
    }

    public static class ObjectSegment<T>
    extends SegmentList.Segment {
        public T value;

        public ObjectSegment(int minY, int maxY) {
            super(minY, maxY);
        }

        @Override
        public boolean canMergeWith(SegmentList.Segment that) {
            return this.value == ((ObjectSegment)that).value;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + String.valueOf(this.value);
        }
    }
}

