/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.restrictions;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.CoderRegistry;
import builderb0y.bigglobe.codecs.CoderRegistryTyped;
import builderb0y.bigglobe.columns.restrictions.AndColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.ConstantColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.EmptyColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.NotColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.OrColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.RangeColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.ScriptColumnRestriction;
import builderb0y.bigglobe.columns.restrictions.SkipDistantHorizonsRestriction;
import builderb0y.bigglobe.columns.restrictions.ThresholdColumnRestriction;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UseCoder(name="REGISTRY", usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public interface ColumnRestriction
extends CoderRegistryTyped<ColumnRestriction> {
    public static final ColumnRestriction EMPTY = new EmptyColumnRestriction();
    public static final CoderRegistry<ColumnRestriction> REGISTRY = new CoderRegistry<ColumnRestriction>(BigGlobeMod.modID("column_restriction")){

        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, ColumnRestriction> context) throws EncodeException {
            return context.object == null || context.object == EMPTY ? EmptyData.INSTANCE : super.encode(context);
        }

        @Nullable
        public <T_Encoded> ColumnRestriction decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            return context.isEmpty() ? EMPTY : (ColumnRestriction)super.decode(context);
        }
    };
    public static final Object INITIALIZER = new Object(){
        {
            REGISTRY.registerAuto(BigGlobeMod.modID("constant"), ConstantColumnRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("threshold"), ThresholdColumnRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("range"), RangeColumnRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("and"), AndColumnRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("or"), OrColumnRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("not"), NotColumnRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("skip_distant_horizons"), SkipDistantHorizonsRestriction.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("script"), ScriptColumnRestriction.class);
        }
    };

    public double getRestriction(ScriptedColumn var1, int var2);

    default public boolean test(ScriptedColumn column, int y, long seed) {
        double restriction = this.getRestriction(column, y);
        if (!(restriction > 0.0)) {
            return false;
        }
        if (restriction >= 1.0) {
            return true;
        }
        return Permuter.toPositiveDouble(Permuter.permute(seed, column.x(), BigGlobeMath.floorI(y), column.z())) < restriction;
    }
}

