/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.restrictions;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.VerifySorted;
import builderb0y.autocodec.util.TypeFormatter;
import builderb0y.bigglobe.columns.restrictions.PropertyColumnRestriction;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.math.Interpolator;
import net.minecraft.class_6880;

public class RangeColumnRestriction
extends PropertyColumnRestriction {
    public final double min;
    public final @VerifySorted(greaterThan={"min"}) double mid;
    public final @VerifySorted(greaterThan={"mid"}) double max;
    public final @DefaultBoolean(value=true) boolean smooth;

    public RangeColumnRestriction(class_6880<ColumnEntry> property, double min, double mid, double max, boolean smooth) {
        super(property);
        this.min = min;
        this.mid = mid;
        this.max = max;
        this.smooth = smooth;
    }

    @Override
    public double getRestriction(ScriptedColumn column, int y) {
        double value;
        try {
            value = this.getter.invokeExact(column, y);
        }
        catch (Throwable throwable) {
            this.onError(throwable);
            return 0.0;
        }
        return this.smooth ? RangeColumnRestriction.bandSmooth(this.min, this.mid, this.max, value) : RangeColumnRestriction.bandLinear(this.min, this.mid, this.max, value);
    }

    public static double curve1(double value, double coefficient) {
        double product = value * coefficient;
        return (product + value) / (product + 1.0);
    }

    public static double inverse(double target) {
        return (-2.0 * target + 1.0) / (target - 1.0);
    }

    public static double curve2(double value, double target) {
        return RangeColumnRestriction.curve1(value, RangeColumnRestriction.inverse(target));
    }

    public static double bandLinear(double min, double mid, double max, double value) {
        if (!(value > min) || !(value < max)) {
            return 0.0;
        }
        if (!(mid > min) || !(mid < max)) {
            return 0.0;
        }
        mid = Interpolator.unmixLinear(min, max, mid);
        value = Interpolator.unmixLinear(min, max, value);
        double part = RangeColumnRestriction.curve2(value, 1.0 - mid);
        return part * (1.0 - part) * 4.0;
    }

    public static double bandSmooth(double min, double mid, double max, double value) {
        if (!(value > min) || !(value < max)) {
            return 0.0;
        }
        if (!(mid > min) || !(mid < max)) {
            return 0.0;
        }
        mid = Interpolator.unmixLinear(min, max, mid);
        value = Interpolator.unmixLinear(min, max, value);
        double part1 = RangeColumnRestriction.curve2(value, 1.0 - mid);
        double part2 = part1 * (1.0 - part1) * 4.0;
        double power = 1.0 / Interpolator.mixLinear(part1, 1.0 - part1, mid) + 1.0;
        return Math.pow(part2, power);
    }

    public int hashCode() {
        int hash = this.property.hashCode();
        hash = hash * 31 + Double.hashCode(this.min);
        hash = hash * 31 + Double.hashCode(this.mid);
        hash = hash * 31 + Double.hashCode(this.max);
        hash = hash * 31 + Boolean.hashCode(this.smooth);
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RangeColumnRestriction)) return false;
        RangeColumnRestriction that = (RangeColumnRestriction)obj;
        if (!this.property.equals((Object)that.property)) return false;
        if (this.min != that.min) return false;
        if (this.mid != that.mid) return false;
        if (this.max != that.max) return false;
        return true;
    }

    public String toString() {
        return TypeFormatter.getSimpleClassName(this.getClass()) + ": { property: " + String.valueOf(this.property) + ", min: " + this.min + ", mid: " + this.mid + ", max: " + this.max + ", smooth: " + this.smooth + " }";
    }
}

