/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted;

import builderb0y.bigglobe.columns.scripted.AccessSchema;
import builderb0y.bigglobe.columns.scripted.ColumnEntryRegistry;
import builderb0y.bigglobe.columns.scripted.VoronoiSettings;
import builderb0y.bigglobe.columns.scripted.compile.DataCompileContext;
import builderb0y.bigglobe.columns.scripted.compile.VoronoiBaseCompileContext;
import builderb0y.bigglobe.columns.scripted.compile.VoronoiImplCompileContext;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.columns.scripted.entries.VoronoiColumnEntry;
import builderb0y.bigglobe.columns.scripted.types.VoronoiColumnValueType;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.dynamicRegistries.BigGlobeDynamicRegistries;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class VoronoiManager {
    public final ColumnEntryRegistry registry;
    public final Map<ColumnEntry, class_6880<ColumnEntry>> columnEntryReverseLookup = new IdentityHashMap<ColumnEntry, class_6880<ColumnEntry>>(256);
    public final Map<VoronoiSettings, class_6880<VoronoiSettings>> voronoiSettingsReverseLookup = new IdentityHashMap<VoronoiSettings, class_6880<VoronoiSettings>>(64);
    public final Map<VoronoiColumnValueType, Entry> voronoi2EntryMap = new IdentityHashMap<VoronoiColumnValueType, Entry>(16);
    public final Map<VoronoiSettings, VoronoiImplCompileContext> settings2ImplContext = new IdentityHashMap<VoronoiSettings, VoronoiImplCompileContext>(64);
    public final Map<ColumnEntry, List<class_6880<VoronoiSettings>>> enablingSettingsMap = new IdentityHashMap<ColumnEntry, List<class_6880<VoronoiSettings>>>(64);

    public VoronoiManager(ColumnEntryRegistry registry) {
        this.registry = registry;
        BetterRegistry<ColumnEntry> columnEntryRegistry = registry.registries.getRegistry(BigGlobeDynamicRegistries.COLUMN_ENTRY_REGISTRY_KEY);
        BetterRegistry<VoronoiSettings> voronoiRegistry = registry.registries.getRegistry(BigGlobeDynamicRegistries.VORONOI_SETTINGS_REGISTRY_KEY);
        voronoiRegistry.streamEntries().forEach(voronoiEntry -> {
            class_6880<ColumnEntry> owner = ((VoronoiSettings)voronoiEntry.comp_349()).owner();
            if (!(owner.comp_349() instanceof VoronoiColumnEntry)) {
                throw new IllegalArgumentException("voronoi_settings " + String.valueOf(UnregisteredObjectException.getID(voronoiEntry)) + " is owned by column_value " + String.valueOf(UnregisteredObjectException.getID(owner)) + " but this column value is not of type voronoi.");
            }
        });
        HashMap voronoiCellNames = new HashMap(8);
        columnEntryRegistry.streamEntries().forEach(entry -> {
            Object patt0$temp = entry.comp_349();
            if (patt0$temp instanceof VoronoiColumnEntry) {
                VoronoiColumnEntry voronoi = (VoronoiColumnEntry)patt0$temp;
                String name = ((VoronoiColumnValueType)voronoi.params.type()).name;
                class_2960 id = UnregisteredObjectException.getID(entry);
                class_2960 old = voronoiCellNames.putIfAbsent(name, id);
                if (old != null) {
                    throw new IllegalStateException("Voronoi-typed column values " + String.valueOf(id) + " and " + String.valueOf(old) + " share the same cell name '" + name + "' (they shouldn't).");
                }
            }
        });
        columnEntryRegistry.streamEntries().forEach(registryEntry -> this.columnEntryReverseLookup.put((ColumnEntry)registryEntry.comp_349(), (class_6880<ColumnEntry>)registryEntry));
        voronoiRegistry.streamEntries().forEach(registryEntry -> this.voronoiSettingsReverseLookup.put((VoronoiSettings)registryEntry.comp_349(), (class_6880<VoronoiSettings>)registryEntry));
        columnEntryRegistry.streamEntries().forEach(columnRegistryEntry -> {
            Object patt0$temp = columnRegistryEntry.comp_349();
            if (patt0$temp instanceof VoronoiColumnEntry) {
                VoronoiColumnEntry voronoiColumnEntry = (VoronoiColumnEntry)patt0$temp;
                List<class_6880<VoronoiSettings>> settings = voronoiRegistry.streamEntries().filter(voronoiRegistryEntry -> ((VoronoiSettings)voronoiRegistryEntry.comp_349()).owner() == columnRegistryEntry).peek(voronoiRegistryEntry -> {
                    Map<String, AccessSchema> expected = ((VoronoiSettings)voronoiRegistryEntry.comp_349()).exports().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ColumnEntry)((class_6880)entry.getValue()).comp_349()).getAccessSchema()));
                    if (!voronoiColumnEntry.exports().equals(expected)) {
                        throw new IllegalStateException("Export mismatch between column value " + String.valueOf(UnregisteredObjectException.getID(columnRegistryEntry)) + " " + String.valueOf(voronoiColumnEntry.exports()) + " and voronoi settings " + String.valueOf(UnregisteredObjectException.getID(voronoiRegistryEntry)) + " " + String.valueOf(expected));
                    }
                }).sorted(Comparator.comparing(UnregisteredObjectException::getID)).toList();
                VoronoiBaseCompileContext baseContext = new VoronoiBaseCompileContext(registry.columnContext, ((VoronoiColumnValueType)voronoiColumnEntry.getAccessSchema().type()).name, !voronoiColumnEntry.exports().isEmpty());
                List<VoronoiImplCompileContext> implContexts = settings.stream().map(voronoiSettingsRegistryEntry -> new VoronoiImplCompileContext(baseContext, (class_6880<VoronoiSettings>)voronoiSettingsRegistryEntry)).toList();
                this.voronoi2EntryMap.put(voronoiColumnEntry.voronoiType(), new Entry(settings, baseContext, implContexts));
                int size = settings.size();
                for (int index = 0; index < size; ++index) {
                    this.settings2ImplContext.put((VoronoiSettings)settings.get(index).comp_349(), implContexts.get(index));
                }
            }
            this.enablingSettingsMap.put((ColumnEntry)columnRegistryEntry.comp_349(), voronoiRegistry.streamEntries().filter(voronoiEntry -> ((VoronoiSettings)voronoiEntry.comp_349()).enables().contains(columnRegistryEntry)).sorted(Comparator.comparing(UnregisteredObjectException::getID)).toList());
        });
    }

    public class_6880<ColumnEntry> entryOf(ColumnEntry entry) {
        return this.columnEntryReverseLookup.get(entry);
    }

    public class_6880<VoronoiSettings> entryOf(VoronoiSettings settings) {
        return this.voronoiSettingsReverseLookup.get(settings);
    }

    public List<class_6880<VoronoiSettings>> getOptionsFor(VoronoiColumnEntry entry) {
        return this.voronoi2EntryMap.get((Object)entry.voronoiType()).settings;
    }

    public VoronoiBaseCompileContext getBaseContextFor(VoronoiColumnEntry entry) {
        return this.voronoi2EntryMap.get((Object)entry.voronoiType()).baseContext;
    }

    public List<VoronoiImplCompileContext> getImplContextsFor(VoronoiColumnEntry entry) {
        return this.voronoi2EntryMap.get((Object)entry.voronoiType()).implContexts;
    }

    public List<class_6880<VoronoiSettings>> getOptionsFor(VoronoiColumnValueType type) {
        return this.voronoi2EntryMap.get((Object)type).settings;
    }

    public VoronoiBaseCompileContext getBaseContextFor(VoronoiColumnValueType type) {
        return this.voronoi2EntryMap.get((Object)type).baseContext;
    }

    public List<VoronoiImplCompileContext> getImplContextsFor(VoronoiColumnValueType type) {
        return this.voronoi2EntryMap.get((Object)type).implContexts;
    }

    public VoronoiImplCompileContext getImplContextFor(VoronoiSettings settings) {
        return this.settings2ImplContext.get(settings);
    }

    public List<class_6880<VoronoiSettings>> getEnablingSettings(ColumnEntry entry) {
        return this.enablingSettingsMap.get(entry);
    }

    public Stream<DataCompileContext> getValidOn(ColumnEntry entry) {
        List<class_6880<VoronoiSettings>> enablers = this.getEnablingSettings(entry);
        return enablers.isEmpty() ? Stream.of(this.registry.columnContext) : enablers.stream().map(class_6880::comp_349).map(this::getImplContextFor);
    }

    public record Entry(List<class_6880<VoronoiSettings>> settings, VoronoiBaseCompileContext baseContext, List<VoronoiImplCompileContext> implContexts) {
    }
}

