/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.autocodec.util.HashStrategies;
import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.bigglobe.columns.scripted.classes.BaseClassSpec;
import builderb0y.bigglobe.columns.scripted.classes.ClassHierarchy;
import builderb0y.bigglobe.columns.scripted.classes.CustomClassFormatException;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.MemberSpec;
import builderb0y.bigglobe.columns.scripted.classes.Named;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.input.ScriptUsage;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMethodSpec
extends MemberSpec
implements DependencyView.SetBasedMutableDependencyView {
    public static final Hash.Strategy<BaseMethodSpec> DESC_STRATEGY = HashStrategies.allOf((Hash.Strategy[])new Hash.Strategy[]{NAME_STRATEGY, HashStrategies.map((Hash.Strategy)HashStrategies.orderedArrayStrategy(ParameterSpec.TYPE_STRATEGY), BaseMethodSpec::getParameters)});
    public transient MethodSpecDesc desc;

    public MethodSpecDesc getDescriptor() {
        if (this.desc == null) {
            this.desc = new MethodSpecDesc(this.name(), Arrays.stream(this.getParameters()).map(ParameterSpec::typeInfo).toList());
        }
        return this.desc;
    }

    public abstract class_6880<ElementSpec> getReturnType();

    public abstract ParameterSpec[] getParameters();

    public abstract int flags();

    @Override
    public void verify(ClassHierarchy hierarchy, BaseClassSpec owner) throws CustomClassFormatException {
        super.verify(hierarchy, owner);
        ObjectOpenHashSet parameters = new ObjectOpenHashSet(this.getParameters().length);
        for (ParameterSpec parameter : this.getParameters()) {
            parameter.verify();
            if (parameters.add(parameter.name())) continue;
            throw new CustomClassFormatException("Duplicate parameter name: " + parameter.name);
        }
    }

    @Override
    public void create(ClassHierarchy hierarchy, BaseClassSpec owner) {
        owner.setCompileContext(this, owner.classCompileContext.newMethod(this.flags(), this.name(), BaseMethodSpec.asType(this.getReturnType()).getTypeInfo(), (LazyVarInfo[])Arrays.stream(this.getParameters()).map(parameter -> new LazyVarInfo(parameter.name, BaseMethodSpec.asType(parameter.type).getTypeInfo())).toArray((IntFunction<A[]>)LazyVarInfo.ARRAY_FACTORY)));
    }

    public void compile(ClassHierarchy hierarchy, BaseClassSpec clazz, ScriptUsage code, Consumer<MutableScriptEnvironment> extra) throws ScriptParsingException {
        BaseMethodSpec.compile(hierarchy, clazz, (MethodCompileContext)clazz.getCompileContext(this), code, null, this, extra);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.name() + " " + Arrays.toString(this.getParameters()) + " " + String.valueOf(UnregisteredObjectException.getID(this.getReturnType()));
    }

    public record MethodSpecDesc(String name, List<TypeInfo> parameters) {
        @Override
        @NotNull
        public String toString() {
            return this.parameters.stream().map(TypeInfo::getSimpleClassName).collect(Collectors.joining(", ", this.name + "(", ")"));
        }
    }

    public static class ParameterSpec
    implements Named {
        public static final ObjectArrayFactory<ParameterSpec> ARRAY_FACTORY = new ObjectArrayFactory(ParameterSpec.class);
        public static final Hash.Strategy<ParameterSpec> TYPE_STRATEGY = HashStrategies.map((Hash.Strategy)HashStrategies.identityStrategy(), parameter -> parameter.type);
        public static final Hash.Strategy<ParameterSpec> FULL_STRATEGY = HashStrategies.allOf((Hash.Strategy[])new Hash.Strategy[]{NAME_STRATEGY, TYPE_STRATEGY});
        public final @ExpressionParser.IdentifierName String name;
        public final class_6880<ElementSpec> type;

        public ParameterSpec(String name, class_6880<ElementSpec> type) {
            this.name = name;
            this.type = type;
        }

        public void verify() throws CustomClassFormatException {
            if (ElementSpec.asType(this.type).getTypeInfo().isVoid()) {
                throw new CustomClassFormatException("Void-typed parameter " + this.name);
            }
        }

        public class_6880<ElementSpec> type() {
            return this.type;
        }

        public TypeInfo typeInfo() {
            return ElementSpec.asType(this.type).getTypeInfo();
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return String.valueOf(UnregisteredObjectException.getID(this.type)) + " " + this.name;
        }
    }
}

