/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.autocodec.annotations.DefaultString;
import builderb0y.autocodec.annotations.VerifyNotEmpty;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.classes.BaseClassSpec;
import builderb0y.bigglobe.columns.scripted.classes.BaseMethodSpec;
import builderb0y.bigglobe.columns.scripted.classes.BasePropertySpec;
import builderb0y.bigglobe.columns.scripted.classes.ClassHierarchy;
import builderb0y.bigglobe.columns.scripted.classes.CustomClassFormatException;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.FieldSpec;
import builderb0y.bigglobe.columns.scripted.classes.MemberSpec;
import builderb0y.bigglobe.columns.scripted.classes.OverrideTracker;
import builderb0y.bigglobe.columns.scripted.classes.VoronoiClassSpec;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.input.ScriptUsage;
import builderb0y.scripting.util.TypeInfos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ConstructorSpec
extends MemberSpec
implements DependencyView.SetBasedMutableDependencyView {
    public final @ExpressionParser.IdentifierName @DefaultString(value="new") String name;
    public final @VerifyNotEmpty List<String> values;
    public final @VerifyNullable ScriptUsage code;
    public final transient Set<class_6880<? extends DependencyView>> dependencies = new HashSet<class_6880<? extends DependencyView>>();

    public ConstructorSpec(String name, List<String> values, @VerifyNullable ScriptUsage code) {
        this.name = name;
        this.values = values;
        this.code = code;
    }

    @Override
    public Set<class_6880<? extends DependencyView>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void verify(ClassHierarchy hierarchy, BaseClassSpec owner) throws CustomClassFormatException {
        if (owner.isAbstract) {
            throw new CustomClassFormatException("Can't add constructor " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " to abstract class " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(owner))));
        }
        if (owner instanceof VoronoiClassSpec) {
            throw new CustomClassFormatException("Can't add constructor " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " to voronoi class " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(owner))));
        }
        ConstructorContext context = new ConstructorContext();
        context.resolvedParameters = (ValueSpec[])this.values.stream().map(name -> {
            OverrideTracker.TrackedField field = (OverrideTracker.TrackedField)owner.overrideTracker.fields.get(name);
            if (field != null) {
                return new ValueSpec((String)name, field.declaration(), ((FieldSpec)field.declaration().comp_349()).field_type, false);
            }
            OverrideTracker.TrackedProperty property = (OverrideTracker.TrackedProperty)owner.overrideTracker.properties.get(name);
            if (property != null) {
                if (((BasePropertySpec)property.declaration().comp_349()).isSettable()) {
                    return new ValueSpec((String)name, property.declaration(), ((BasePropertySpec)property.declaration().comp_349()).getPropertyType(), true);
                }
                throw AutoCodecUtil.rethrow((Throwable)new CustomClassFormatException("Can't assign to property " + String.valueOf(UnregisteredObjectException.getID(property.declaration())) + " in constructor " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this)))));
            }
            throw AutoCodecUtil.rethrow((Throwable)new CustomClassFormatException("Could not find field named " + name + " in class " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(owner))) + " for constructor " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this)))));
        }).toArray(ValueSpec[]::new);
        context.descriptor = new BaseMethodSpec.MethodSpecDesc(this.name, Stream.concat(Stream.of(ScriptedColumn.INFO.type), Arrays.stream(context.resolvedParameters).map(ValueSpec::typeInfo)).toList());
        owner.setCompileContext(this, context);
    }

    @Override
    public void create(ClassHierarchy hierarchy, BaseClassSpec owner) {
        ConstructorContext context = (ConstructorContext)owner.getCompileContext(this);
        context.methodCompileContext = owner.classCompileContext.newMethod(9, this.name, owner.getTypeInfo(), (LazyVarInfo[])Stream.concat(Stream.of(new LazyVarInfo("column", ScriptedColumn.INFO.type)), Arrays.stream(context.resolvedParameters).map(parameter -> new LazyVarInfo(parameter.name, parameter.typeInfo()))).toArray((IntFunction<A[]>)LazyVarInfo.ARRAY_FACTORY));
    }

    @Override
    public void compile(ClassHierarchy hierarchy, BaseClassSpec owner) throws ScriptParsingException {
        ConstructorContext context = (ConstructorContext)owner.getCompileContext(this);
        LazyVarInfo result = context.methodCompileContext.scopes.addVariable("$result", owner.getTypeInfo());
        InsnTrees.store(result, InsnTrees.newInstance(context.methodCompileContext.info, InsnTrees.load("column", ScriptedColumn.INFO.type))).emitBytecode(context.methodCompileContext);
        for (ValueSpec parameter : context.resolvedParameters) {
            if (parameter.useSetter) {
                InsnTrees.invokeInstance(InsnTrees.load(result), new MethodInfo(1, parameter.ownerTypeInfo(), parameter.name, TypeInfos.VOID, parameter.typeInfo()), InsnTrees.load(parameter.name, parameter.typeInfo())).emitBytecode(context.methodCompileContext);
                continue;
            }
            InsnTrees.putField(InsnTrees.load(result), new FieldInfo(1, parameter.ownerTypeInfo(), parameter.name, parameter.typeInfo()), InsnTrees.load(parameter.name, parameter.typeInfo())).emitBytecode(context.methodCompileContext);
        }
        if (this.code != null) {
            hierarchy.registry.parseCode(context.methodCompileContext, this.code, InsnTrees.load("column", ScriptedColumn.INFO.type), null, InsnTrees.load(result), this, MemberSpec.NO_EXTRAS).emitBytecode(context.methodCompileContext);
        }
        InsnTrees.return_(InsnTrees.load(result)).emitBytecode(context.methodCompileContext);
    }

    @Override
    public void track(OverrideTracker tracker) throws CustomClassFormatException {
        tracker.addConstructor(this);
    }

    @Override
    public void setupEnvironment(MutableScriptEnvironment environment, BaseClassSpec owner, @Nullable InsnTree loadCustomClass) {
        ConstructorContext context = (ConstructorContext)owner.getCompileContext(this);
        environment.addQualifiedFunctionInvokeStatic(context.methodCompileContext.info);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String toString() {
        return "constructor " + this.name + String.valueOf(this.values);
    }

    public static class ConstructorContext {
        public MethodCompileContext methodCompileContext;
        public ValueSpec[] resolvedParameters;
        public BaseMethodSpec.MethodSpecDesc descriptor;
    }

    public static class ValueSpec {
        public final @ExpressionParser.IdentifierName String name;
        public final class_6880<ElementSpec> owner;
        public final class_6880<ElementSpec> type;
        public final boolean useSetter;

        public ValueSpec(String name, class_6880<ElementSpec> owner, class_6880<ElementSpec> type, boolean useSetter) {
            this.name = name;
            this.owner = owner;
            this.type = type;
            this.useSetter = useSetter;
        }

        public TypeInfo typeInfo() {
            return ElementSpec.asType(this.type).getTypeInfo();
        }

        public TypeInfo ownerTypeInfo() {
            return ElementSpec.asType(this.owner).getTypeInfo();
        }
    }
}

