/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.columns.scripted.classes.BaseClassSpec;
import builderb0y.bigglobe.columns.scripted.classes.BasePropertySpec;
import builderb0y.bigglobe.columns.scripted.classes.ClassHierarchy;
import builderb0y.bigglobe.columns.scripted.classes.CustomClassFormatException;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.OverrideTracker;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.input.ScriptUsage;
import builderb0y.scripting.util.TypeInfos;
import java.util.Set;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class OverridePropertySpec
extends BasePropertySpec {
    public final class_6880<ElementSpec> override;
    public final ScriptUsage get;
    public final @VerifyNullable ScriptUsage set;

    public OverridePropertySpec(class_6880<ElementSpec> override, ScriptUsage get, @VerifyNullable ScriptUsage set) {
        this.override = override;
        this.get = get;
        this.set = set;
    }

    @Override
    public void verify(ClassHierarchy hierarchy, BaseClassSpec owner) throws CustomClassFormatException {
        Object object = this.override.comp_349();
        if (!(object instanceof BasePropertySpec)) {
            throw new CustomClassFormatException("Override property " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " overrides non-property " + String.valueOf(UnregisteredObjectException.getID(this.override)));
        }
        BasePropertySpec override = (BasePropertySpec)object;
        if (this.isSettable() && !override.isSettable()) {
            throw new CustomClassFormatException("Override property " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " cannot be settable if its override (" + String.valueOf(UnregisteredObjectException.getID(this.override)) + ") is not settable.");
        }
        if (!this.isSettable() && override.isSettable()) {
            throw new CustomClassFormatException("Override property " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " must be settable if its override (" + String.valueOf(UnregisteredObjectException.getID(this.override)) + ") is settable.");
        }
    }

    @Override
    public void compile(ClassHierarchy hierarchy, BaseClassSpec owner) throws ScriptParsingException {
        BasePropertySpec.PropertyCompileContext propertyContext = (BasePropertySpec.PropertyCompileContext)owner.getCompileContext(this);
        LoadInsnTree loadY = this.is3D() ? InsnTrees.load("y", TypeInfos.INT) : null;
        OverridePropertySpec.compile(hierarchy, owner, propertyContext.get, this.get, loadY, this, environment -> {
            if (this.is3D()) {
                environment.addVariableLoad("y", TypeInfos.INT);
            }
        });
        if (this.set != null) {
            OverridePropertySpec.compile(hierarchy, owner, propertyContext.set, this.set, loadY, this, environment -> {
                if (this.is3D()) {
                    environment.addVariableLoad("y", TypeInfos.INT);
                }
                environment.addVariableLoad("value", OverridePropertySpec.asType(this.getPropertyType()).getTypeInfo());
            });
        }
    }

    @Override
    public boolean isSettable() {
        return this.set != null;
    }

    @Override
    public boolean is3D() {
        return ((BasePropertySpec)this.override.comp_349()).is3D();
    }

    @Override
    public class_6880<ElementSpec> getPropertyType() {
        return ((BasePropertySpec)this.override.comp_349()).getPropertyType();
    }

    @Override
    public int flags() {
        return 1;
    }

    @Override
    public void track(OverrideTracker tracker) throws CustomClassFormatException {
        tracker.addOverrideProperty(this);
    }

    @Override
    public void setupEnvironment(MutableScriptEnvironment environment, BaseClassSpec owner, @Nullable InsnTree loadCustomClass) {
    }

    @Override
    public String name() {
        return ((ElementSpec)this.override.comp_349()).name();
    }

    @Override
    public Set<class_6880<? extends DependencyView>> getDependencies() {
        return ((BasePropertySpec)this.override.comp_349()).getDependencies();
    }
}

