/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.decisionTrees.conditions;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.compile.DataCompileContext;
import builderb0y.bigglobe.columns.scripted.decisionTrees.DecisionTreeException;
import builderb0y.bigglobe.columns.scripted.decisionTrees.conditions.DecisionTreeCondition;
import builderb0y.bigglobe.scripting.environments.RandomScriptEnvironment;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.DoubleCompareConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.FloatCompareConditionTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.MultiplyInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.SubtractInsnTree;

public abstract class AbstractThresholdDecisionTreeCondition
extends DecisionTreeCondition.Impl {
    public final double min;
    public final double max;
    public final @DefaultBoolean(value=true) boolean smooth_min;
    public final @DefaultBoolean(value=true) boolean smooth_max;

    public AbstractThresholdDecisionTreeCondition(double min, double max, @DefaultBoolean(value=true) boolean smooth_min, @DefaultBoolean(value=true) boolean smooth_max) {
        this.min = min;
        this.max = max;
        this.smooth_min = smooth_min;
        this.smooth_max = smooth_max;
    }

    public ConditionTree finishCondition(InsnTree value, long selfSeed, DataCompileContext context) {
        return switch (value.getTypeInfo().getSort()) {
            case TypeInfo.Sort.FLOAT -> FloatCompareConditionTree.lessThan(RandomScriptEnvironment.PERMUTER_INFO.toPositiveFloat(ScriptedColumn.INFO.saltedPositionedSeed(context.loadColumn(), InsnTrees.ldc(selfSeed))), InsnTrees.invokeStatic(MethodInfo.inCaller(this.smooth_min ? (this.smooth_max ? "smoothBothF" : "smoothMinF") : (this.smooth_max ? "smoothMaxF" : "smoothNoneF")), new MultiplyInsnTree(new SubtractInsnTree(value, InsnTrees.ldc((float)this.min), 102), InsnTrees.ldc((float)(1.0 / (this.max - this.min))), 106)));
            case TypeInfo.Sort.DOUBLE -> DoubleCompareConditionTree.lessThan(RandomScriptEnvironment.PERMUTER_INFO.toPositiveDouble(ScriptedColumn.INFO.saltedPositionedSeed(context.loadColumn(), InsnTrees.ldc(selfSeed))), InsnTrees.invokeStatic(MethodInfo.inCaller(this.smooth_min ? (this.smooth_max ? "smoothBothD" : "smoothMinD") : (this.smooth_max ? "smoothMaxD" : "smoothNoneD")), new MultiplyInsnTree(new SubtractInsnTree(value, InsnTrees.ldc(this.min), 103), InsnTrees.ldc(1.0 / (this.max - this.min)), 107)));
            default -> throw new DecisionTreeException(this.errorMessage(value.getTypeInfo()));
        };
    }

    public abstract String errorMessage(TypeInfo var1);

    public static float smoothNoneF(float value) {
        if (!(value > 0.0f)) {
            return 0.0f;
        }
        if (!(value < 1.0f)) {
            return 1.0f;
        }
        return value;
    }

    public static float smoothMinF(float value) {
        if (!(value > 0.0f)) {
            return 0.0f;
        }
        if (!(value < 1.0f)) {
            return 1.0f;
        }
        return value * value;
    }

    public static float smoothMaxF(float value) {
        if (!(value > 0.0f)) {
            return 0.0f;
        }
        if (!(value < 1.0f)) {
            return 1.0f;
        }
        return value * (2.0f - value);
    }

    public static float smoothBothF(float value) {
        if (!(value > 0.0f)) {
            return 0.0f;
        }
        if (!(value < 1.0f)) {
            return 1.0f;
        }
        return value * value * (value * -2.0f + 3.0f);
    }

    public static double smoothNoneD(double value) {
        if (!(value > 0.0)) {
            return 0.0;
        }
        if (!(value < 1.0)) {
            return 1.0;
        }
        return value;
    }

    public static double smoothMinD(double value) {
        if (!(value > 0.0)) {
            return 0.0;
        }
        if (!(value < 1.0)) {
            return 1.0;
        }
        return value * value;
    }

    public static double smoothMaxD(double value) {
        if (!(value > 0.0)) {
            return 0.0;
        }
        if (!(value < 1.0)) {
            return 1.0;
        }
        return value * (2.0 - value);
    }

    public static double smoothBothD(double value) {
        if (!(value > 0.0)) {
            return 0.0;
        }
        if (!(value < 1.0)) {
            return 1.0;
        }
        return value * value * (value * -2.0 + 3.0);
    }
}

