/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.decisionTrees.conditions;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.bigglobe.columns.scripted.compile.DataCompileContext;
import builderb0y.bigglobe.columns.scripted.decisionTrees.DecisionTreeException;
import builderb0y.bigglobe.columns.scripted.decisionTrees.DecisionTreeSettings;
import builderb0y.bigglobe.columns.scripted.decisionTrees.conditions.AbstractThresholdDecisionTreeCondition;
import builderb0y.bigglobe.columns.scripted.traits.TraitManager;
import builderb0y.bigglobe.columns.scripted.traits.WorldTrait;
import builderb0y.bigglobe.columns.scripted.tree.StandAloneTraits2DGetterInsnTree;
import builderb0y.bigglobe.columns.scripted.tree.StandAloneTraits3DGetterInsnTree;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.parsing.ScriptParsingException;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class WorldTraitDecisionTreeCondition
extends AbstractThresholdDecisionTreeCondition {
    public final class_6880<WorldTrait> trait;

    public WorldTraitDecisionTreeCondition(class_6880<WorldTrait> trait, double min, double max, @DefaultBoolean(value=true) boolean smooth_min, @DefaultBoolean(value=true) boolean smooth_max) {
        super(min, max, smooth_min, smooth_max);
        this.trait = trait;
        this.addDependency(trait);
    }

    @Override
    public ConditionTree createCondition(class_6880<DecisionTreeSettings> selfEntry, long selfSeed, DataCompileContext context, @Nullable InsnTree loadY) throws ScriptParsingException {
        TraitManager.TraitInfo info = context.root().registry.traitManager.infos.get(this.trait);
        if (info == null) {
            throw new IllegalStateException(String.valueOf(UnregisteredObjectException.getKey(this.trait)) + " didn't get compiled properly?");
        }
        boolean requiresY = ((WorldTrait)this.trait.comp_349()).schema().is_3d();
        if (requiresY && loadY == null) {
            throw new DecisionTreeException(String.valueOf(UnregisteredObjectException.getKey(this.trait)) + " is 3D, but a Y level is not provided.");
        }
        return this.finishCondition(requiresY ? new StandAloneTraits3DGetterInsnTree(context.loadColumn(), loadY, info.getter.info, null) : new StandAloneTraits2DGetterInsnTree(context.loadColumn(), info.getter.info, null), selfSeed, context);
    }

    @Override
    public String errorMessage(TypeInfo type) {
        return "world_trait_threshold decision tree condition only works with float and double typed world traits, but " + String.valueOf(UnregisteredObjectException.getID(this.trait)) + " is a " + String.valueOf(type);
    }
}

