/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.dependencies;

import builderb0y.bigglobe.columns.scripted.dependencies.CyclicDependencyException;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyDepthSorter;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.columns.scripted.traits.WorldTraits;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_6880;

public class CyclicDependencyAnalyzer
implements Consumer<class_6880<? extends DependencyView>> {
    public final WorldTraits traits;
    public final Set<class_6880<? extends DependencyView>> seen = new ObjectOpenCustomHashSet(256, DependencyDepthSorter.REGISTRY_ENTRY_STRATEGY);
    public final Set<class_6880<? extends DependencyView>> stack = new ObjectLinkedOpenCustomHashSet(16, DependencyDepthSorter.REGISTRY_ENTRY_STRATEGY);

    public CyclicDependencyAnalyzer(WorldTraits traits) {
        this.traits = traits;
    }

    @Override
    public void accept(class_6880<? extends DependencyView> entry) {
        if (!this.stack.add(entry)) {
            throw new CyclicDependencyException(Stream.concat(this.stack.stream().dropWhile(compare -> compare != entry), Stream.of(entry)).map(UnregisteredObjectException::getKey).map(DependencyDepthSorter::keyToString).collect(Collectors.joining(" -> ")));
        }
        try {
            if (this.seen.add(entry)) {
                ((DependencyView)entry.comp_349()).streamDirectDependencies(entry, this.traits).forEach(this);
            }
        }
        finally {
            this.stack.remove(entry);
        }
    }
}

