/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.types;

import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.data.StringData;
import builderb0y.bigglobe.columns.scripted.compile.ColumnCompileContext;
import builderb0y.bigglobe.columns.scripted.compile.CustomClassCompileContext;
import builderb0y.bigglobe.columns.scripted.compile.DataCompileContext;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.columns.scripted.types.ColumnValueType;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public class ClassColumnValueType
implements ColumnValueType {
    public final String name;
    public final ClassColumnValueField[] fields;
    public final transient Map<String, ColumnValueType> lookup;

    public ClassColumnValueType(String name, ClassColumnValueField[] fields) {
        this.name = name;
        this.fields = fields;
        this.lookup = Arrays.stream(fields).collect(Collectors.toMap(ClassColumnValueField::name, ClassColumnValueField::type));
    }

    @Override
    public ColumnValueType.TypeContext createType(ColumnCompileContext context) {
        CustomClassCompileContext customClassContext = new CustomClassCompileContext(context, this);
        return new ColumnValueType.TypeContext(customClassContext.selfType(), customClassContext);
    }

    @Override
    public InsnTree createConstant(Data data, ColumnCompileContext context) {
        CustomClassCompileContext selfContext = (CustomClassCompileContext)context.getTypeContext(this).context();
        if (data.isEmpty()) {
            return InsnTrees.ldc(null, selfContext.selfType());
        }
        MapData mapData = data.tryAsMap();
        if (mapData == null) {
            throw new ClassCastException("Not a map: " + String.valueOf(data));
        }
        Map<String, InsnTree> constants = mapData.value.entrySet().stream().map(entry -> {
            StringData stringKey = ((Data)entry.getKey()).tryAsString();
            if (stringKey != null) {
                return Map.entry(stringKey.value, (Data)entry.getValue());
            }
            throw new ClassCastException("Key is non-string: " + String.valueOf(entry.getKey()));
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            ColumnValueType type = this.lookup.get(entry.getKey());
            if (type != null) {
                return type.createConstant((Data)entry.getValue(), context);
            }
            throw new IllegalArgumentException("Undeclared field specified: " + (String)entry.getKey());
        }));
        int length = this.fields.length;
        InsnTree[] args = new InsnTree[length];
        for (int index = 0; index < length; ++index) {
            String name = this.fields[index].name;
            InsnTree constant = constants.get(name);
            if (constant == null) {
                throw new IllegalArgumentException("Unspecified field: " + name);
            }
            args[index] = constant;
        }
        return InsnTrees.newInstance(selfContext.constructor.info, args);
    }

    @Override
    public void setupInternalEnvironment(MutableScriptEnvironment environment, ColumnValueType.TypeContext typeContext, DataCompileContext context, DependencyView.MutableDependencyView dependencies) {
        TypeInfo type = typeContext.type();
        environment.addType(this.name, type);
        for (ClassColumnValueField field : this.fields) {
            environment.addFieldGet(new FieldInfo(1, type, field.name, context.root().getTypeContext(field.type).type()));
        }
        MethodInfo constructor = new MethodInfo(1, type, "<init>", TypeInfos.VOID, (TypeInfo[])Arrays.stream(this.fields).map(ClassColumnValueField::type).map(context.root()::getTypeContext).map(ColumnValueType.TypeContext::type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY));
        environment.addQualifiedConstructor(constructor);
    }

    @Override
    public void setupExternalEnvironment(MutableScriptEnvironment environment, ColumnValueType.TypeContext typeContext, ColumnCompileContext context, ColumnEntry.ExternalEnvironmentParams params) {
        this.setupInternalEnvironment(environment, typeContext, context, params.dependencies);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() * 31 + Arrays.hashCode(this.fields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ClassColumnValueType)) return false;
        ClassColumnValueType that = (ClassColumnValueType)obj;
        if (!this.name.equals(that.name)) return false;
        if (!Arrays.equals(this.fields, that.fields)) return false;
        return true;
    }

    public String toString() {
        return "{ type: class, name: " + this.name + ", fields: " + Arrays.toString(this.fields) + " }";
    }

    public record ClassColumnValueField(@ExpressionParser.IdentifierName String name, ColumnValueType type) {
    }
}

