/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted2.entries;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.columns.scripted.MappedRangeArray;
import builderb0y.bigglobe.columns.scripted.MappedRangeNumberArray;
import builderb0y.bigglobe.columns.scripted.MappedRangeObjectArray;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.MemberSpec;
import builderb0y.bigglobe.columns.scripted.classes.TypeSpec;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.columns.scripted2.AccessSchema;
import builderb0y.bigglobe.columns.scripted2.ColumnCompileContext;
import builderb0y.bigglobe.columns.scripted2.ColumnEntryRegistry;
import builderb0y.bigglobe.columns.scripted2.ColumnValueException;
import builderb0y.bigglobe.columns.scripted2.Valid;
import builderb0y.bigglobe.columns.scripted2.entries.ColumnEntry;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.FieldCompileContext;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.BooleanToConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;
import builderb0y.scripting.bytecode.tree.flow.IfElseInsnTree;
import builderb0y.scripting.bytecode.tree.flow.IfInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.StoreInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.BitwiseOrInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.SubtractInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.DirectCastInsnTree;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.input.ScriptUsage;
import builderb0y.scripting.util.TypeInfos;
import com.google.common.collect.ObjectArrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public abstract class NonConstantColumnEntry
extends ColumnEntry
implements DependencyView.SetBasedMutableDependencyView {
    public final @VerifyNullable Valid valid;
    public final @DefaultBoolean(value=true) boolean cache;
    public final transient Set<class_6880<? extends DependencyView>> dependencies;

    public NonConstantColumnEntry(AccessSchema params, @VerifyNullable Valid valid, boolean cache) {
        super(params);
        this.cache = cache;
        this.valid = valid;
        this.dependencies = new HashSet<class_6880<? extends DependencyView>>();
    }

    @Override
    public Set<class_6880<? extends DependencyView>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void verify(ColumnEntryRegistry registry) throws ColumnValueException {
        super.verify(registry);
        if (this.params.is_3d() && this.cache && (this.valid == null || this.valid.min_y() == null || this.valid.max_y() == null)) {
            BigGlobeMod.LOGGER.warn("Upper or lower bound not specified for column value " + String.valueOf(UnregisteredObjectException.getID(registry.entryOf(this))) + ", and caching is enabled. This may result in poor worldgen performance, as it may compute more Y levels than intended.");
        }
    }

    @Override
    public void createContext(ColumnEntryRegistry registry) throws ColumnValueException {
        Object[] objectArray;
        ClassCompileContext clazz = registry.columnCompileContext.clazz;
        NonConstantColumnEntryContext context = new NonConstantColumnEntryContext();
        context.uniquifier = clazz.memberUniquifier++;
        context.internalName = ColumnCompileContext.internalName(UnregisteredObjectException.getID(registry.entryOf(this)), context.uniquifier);
        if (this.params.is_3d()) {
            Object[] objectArray2 = new LazyVarInfo[1];
            objectArray = objectArray2;
            objectArray2[0] = new LazyVarInfo("y", TypeInfos.INT);
        } else {
            objectArray = (LazyVarInfo[])LazyVarInfo.ARRAY_FACTORY.empty();
        }
        Object[] maybeY = objectArray;
        TypeInfo valueType = ElementSpec.asType(this.params.type()).getTypeInfo();
        context.mainGetter = clazz.newMethod(1, "get_" + context.internalName, valueType, (LazyVarInfo[])maybeY);
        if (this.hasFieldSetterAndFlag()) {
            context.valueField = clazz.newField(this.params.is_3d() ? 17 : 1, context.internalName, this.params.is_3d() ? (valueType.isObject() ? MappedRangeObjectArray.TYPE : MappedRangeNumberArray.TYPE) : valueType);
            context.mainSetter = clazz.newMethod(1, "set_" + context.internalName, TypeInfos.VOID, (LazyVarInfo[])ObjectArrays.concat((Object[])maybeY, (Object)new LazyVarInfo("value", valueType)));
        }
        registry.columnCompileContext.setCompileContext(this, context);
    }

    @Override
    public void compile(ColumnEntryRegistry registry) throws ColumnValueException, ScriptParsingException {
        NonConstantColumnEntryContext context = (NonConstantColumnEntryContext)registry.columnCompileContext.getCompileContext(this);
        if (!this.params.is_3d()) {
            this.compile2D(registry, context);
        } else if (this.hasFieldSetterAndFlag()) {
            this.compile3DCached(registry, context);
        } else {
            this.compile3DUncached(registry, context);
        }
    }

    public void compile2D(ColumnEntryRegistry registry, NonConstantColumnEntryContext context) throws ScriptParsingException {
        TypeSpec valueType = ElementSpec.asType(this.params.type());
        TypeInfo valueTypeInfo = valueType.getTypeInfo();
        InsnTree loadColumn = registry.columnCompileContext.loadColumn();
        LazyVarInfo value = context.mainGetter.scopes.addVariable("value", valueTypeInfo);
        InsnTree computer = this.makeComputer(registry, context);
        if (this.hasValid()) {
            computer = new IfElseInsnTree(new BooleanToConditionTree(this.makeCaller(registry, "validWhere", this.valid.where(), TypeInfos.BOOLEAN)), computer, valueType.parseConstant(registry.classHierarchy, this.valid.fallback(), loadColumn), valueTypeInfo);
        }
        computer = new StoreInsnTree(value, computer);
        if (this.hasFieldSetterAndFlag()) {
            LazyVarInfo oldFlags = context.mainGetter.scopes.addVariable("oldFlags", TypeInfos.INT);
            LazyVarInfo newFlags = context.mainGetter.scopes.addVariable("newFlags", TypeInfos.INT);
            FieldInfo flagsField = registry.columnCompileContext.flagsField(context.uniquifier);
            int flagsBitmask = registry.columnCompileContext.flagsFieldBitmask(context.uniquifier);
            computer = InsnTrees.seq(InsnTrees.store(oldFlags, InsnTrees.getField(loadColumn, flagsField)), InsnTrees.store(newFlags, new BitwiseOrInsnTree(InsnTrees.load(oldFlags), InsnTrees.ldc(flagsBitmask), 128)), new IfElseInsnTree(IntCompareConditionTree.notEqual(InsnTrees.load(oldFlags), InsnTrees.load(newFlags)), InsnTrees.seq(InsnTrees.putField(loadColumn, flagsField, InsnTrees.load(newFlags)), computer, InsnTrees.putField(loadColumn, context.valueField.info, InsnTrees.load(value))), InsnTrees.store(value, InsnTrees.getField(loadColumn, context.valueField.info)), TypeInfos.VOID));
        }
        InsnTrees.seq(computer, InsnTrees.return_(InsnTrees.load(value))).emitBytecode(context.mainGetter);
        context.mainGetter.endCode();
    }

    public void compile3DCached(ColumnEntryRegistry registry, NonConstantColumnEntryContext context) throws ColumnValueException, ScriptParsingException {
        LazyVarInfo y = new LazyVarInfo("y", TypeInfos.INT);
        TypeSpec valueType = ElementSpec.asType(this.params.type());
        TypeInfo valueTypeInfo = valueType.getTypeInfo();
        InsnTree loadColumn = registry.columnCompileContext.loadColumn();
        InsnTree getBackingField = InsnTrees.getField(loadColumn, context.valueField.info);
        FieldInfo fieldInfo = context.valueField.info;
        InsnTrees.putField(loadColumn, fieldInfo, switch (valueTypeInfo.getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.VOID -> throw new ColumnValueException("void array");
            case TypeInfo.Sort.BOOLEAN -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_BOOLEAN));
            case TypeInfo.Sort.BYTE -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_BYTE));
            case TypeInfo.Sort.CHAR -> throw new UnsupportedOperationException("char array");
            case TypeInfo.Sort.SHORT -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_SHORT));
            case TypeInfo.Sort.INT -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_INT));
            case TypeInfo.Sort.LONG -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_LONG));
            case TypeInfo.Sort.FLOAT -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_FLOAT));
            case TypeInfo.Sort.DOUBLE -> InsnTrees.newInstance(MappedRangeNumberArray.CONSTRUCTOR, InsnTrees.getStatic(NumberArray.INFO.EMPTY_DOUBLE));
            case TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> InsnTrees.newInstance(MappedRangeObjectArray.CONSTRUCTOR, InsnTrees.newArrayWithLength(TypeInfo.makeArray(valueTypeInfo), InsnTrees.ldc(0)));
        }).emitBytecode(registry.columnCompileContext.constructor);
        InsnTree computer = this.makeBulkComputer(registry, context);
        InsnTree reallocate = this.valid != null ? (this.valid.min_y() != null ? (this.valid.max_y() != null ? InsnTrees.invokeInstance(getBackingField, MappedRangeArray.INFO.reallocateBoth, loadColumn, this.makeCaller(registry, "validMinY", this.valid.min_y(), TypeInfos.INT), this.makeCaller(registry, "validMaxY", this.valid.max_y(), TypeInfos.INT)) : InsnTrees.invokeInstance(getBackingField, MappedRangeArray.INFO.reallocateMin, loadColumn, this.makeCaller(registry, "validMinY", this.valid.min_y(), TypeInfos.INT))) : (this.valid.max_y() != null ? InsnTrees.invokeInstance(getBackingField, MappedRangeArray.INFO.reallocateMax, loadColumn, this.makeCaller(registry, "validMaxY", this.valid.max_y(), TypeInfos.INT)) : InsnTrees.invokeInstance(getBackingField, MappedRangeArray.INFO.reallocateNone, loadColumn))) : InsnTrees.invokeInstance(getBackingField, MappedRangeArray.INFO.reallocateNone, loadColumn);
        computer = new IfInsnTree(new BooleanToConditionTree(reallocate), computer);
        if (this.valid != null && this.valid.where() != null) {
            computer = new IfElseInsnTree(new BooleanToConditionTree(this.makeCaller(registry, "validWhere", this.valid.where(), TypeInfos.BOOLEAN)), computer, InsnTrees.invokeInstance(getBackingField, MappedRangeArray.INFO.invalidate, new InsnTree[0]), TypeInfos.VOID);
        }
        LazyVarInfo oldFlags = context.mainGetter.scopes.addVariable("oldFlags", TypeInfos.INT);
        LazyVarInfo newFlags = context.mainGetter.scopes.addVariable("newFlags", TypeInfos.INT);
        FieldInfo flagsField = registry.columnCompileContext.flagsField(context.uniquifier);
        int flagsBitmask = registry.columnCompileContext.flagsFieldBitmask(context.uniquifier);
        computer = InsnTrees.seq(InsnTrees.store(oldFlags, InsnTrees.getField(loadColumn, flagsField)), InsnTrees.store(newFlags, new BitwiseOrInsnTree(InsnTrees.load(oldFlags), InsnTrees.ldc(flagsBitmask), 128)), new IfInsnTree(IntCompareConditionTree.notEqual(InsnTrees.load(oldFlags), InsnTrees.load(newFlags)), InsnTrees.seq(InsnTrees.putField(loadColumn, flagsField, InsnTrees.load(newFlags)), computer)));
        InsnTree[] insnTreeArray = new InsnTree[3];
        insnTreeArray[0] = computer;
        BooleanToConditionTree booleanToConditionTree = new BooleanToConditionTree(InsnTrees.getField(getBackingField, MappedRangeArray.INFO.valid));
        ConditionTree conditionTree = InsnTrees.and(IntCompareConditionTree.greaterThanOrEqual(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached)), IntCompareConditionTree.lessThan(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.maxCached)));
        insnTreeArray[1] = new IfInsnTree(booleanToConditionTree, InsnTrees.seq((InsnTree)new IfInsnTree(conditionTree, InsnTrees.return_(switch (valueTypeInfo.getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.VOID -> throw new IllegalStateException("void array");
            case TypeInfo.Sort.BOOLEAN -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetZ, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.BYTE -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetB, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.CHAR -> throw new UnsupportedOperationException("char array");
            case TypeInfo.Sort.SHORT -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetS, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.INT -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetI, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.LONG -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetL, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.FLOAT -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetF, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.DOUBLE -> InsnTrees.invokeInstance(InsnTrees.getField(getBackingField, MappedRangeNumberArray.ARRAY), NumberArray.INFO.implGetD, new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100));
            case TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> new DirectCastInsnTree(InsnTrees.arrayLoad(InsnTrees.getField(getBackingField, MappedRangeObjectArray.ARRAY), new SubtractInsnTree(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minCached), 100)), valueTypeInfo, false);
        })), (InsnTree)new IfInsnTree(InsnTrees.and(IntCompareConditionTree.greaterThanOrEqual(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.minAccessible)), IntCompareConditionTree.lessThan(InsnTrees.load(y), InsnTrees.getField(getBackingField, MappedRangeArray.INFO.maxAccessible))), InsnTrees.return_(this.makeComputer(registry, context)))));
        insnTreeArray[2] = InsnTrees.return_(valueType.parseConstant(registry.classHierarchy, this.valid.fallback(), loadColumn));
        InsnTrees.seq(insnTreeArray).emitBytecode(context.mainGetter);
        context.mainGetter.endCode();
    }

    public void compile3DUncached(ColumnEntryRegistry registry, NonConstantColumnEntryContext context) throws ScriptParsingException {
        LazyVarInfo y = new LazyVarInfo("y", TypeInfos.INT);
        TypeSpec valueType = ElementSpec.asType(this.params.type());
        TypeInfo valueTypeInfo = valueType.getTypeInfo();
        InsnTree loadColumn = registry.columnCompileContext.loadColumn();
        InsnTree computer = this.makeComputer(registry, context);
        if (this.hasValid()) {
            ConditionTree condition = ConstantConditionTree.TRUE;
            if (this.valid.where() != null) {
                condition = new BooleanToConditionTree(this.makeCaller(registry, "validWhere", this.valid.where(), TypeInfos.BOOLEAN));
            }
            if (this.valid.min_y() != null) {
                condition = InsnTrees.and(condition, IntCompareConditionTree.greaterThanOrEqual(InsnTrees.load(y), this.makeCaller(registry, "validMinY", this.valid.min_y(), TypeInfos.INT)));
            }
            if (this.valid.max_y() != null) {
                condition = InsnTrees.and(condition, IntCompareConditionTree.lessThan(InsnTrees.load(y), this.makeCaller(registry, "validMaxY", this.valid.max_y(), TypeInfos.INT)));
            }
            computer = new IfElseInsnTree(condition, computer, valueType.parseConstant(registry.classHierarchy, this.valid.fallback(), loadColumn), valueTypeInfo);
        }
        InsnTrees.return_(computer).emitBytecode(context.mainGetter);
        context.mainGetter.endCode();
    }

    public InsnTree makeCaller(ColumnEntryRegistry registry, String prefix, ScriptUsage code, TypeInfo returnType) throws ScriptParsingException {
        MethodCompileContext method = registry.columnCompileContext.clazz.newMethod(1, prefix + "_" + ((NonConstantColumnEntryContext)registry.columnCompileContext.getCompileContext((ColumnEntry)this)).internalName, returnType, new LazyVarInfo[0]);
        LoadInsnTree loadColumn = InsnTrees.load("this", registry.columnCompileContext.columnTypeInfo());
        registry.setMethodCode(method, code, loadColumn, null, null, this, MemberSpec.NO_EXTRAS);
        return InsnTrees.invokeInstance(loadColumn, method.info, new InsnTree[0]);
    }

    public abstract InsnTree makeComputer(ColumnEntryRegistry var1, NonConstantColumnEntryContext var2) throws ScriptParsingException;

    public abstract InsnTree makeBulkComputer(ColumnEntryRegistry var1, NonConstantColumnEntryContext var2) throws ScriptParsingException;

    @Override
    public boolean hasFieldSetterAndFlag() {
        return this.cache;
    }

    public boolean hasValid() {
        return this.valid != null && this.valid.isUseful(this.params.is_3d());
    }

    public static class NonConstantColumnEntryContext
    extends ColumnEntry.ColumnEntryContext {
        @Nullable
        public FieldCompileContext valueField;
    }
}

