/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.commands;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.versions.RegistryVersions;
import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7655;

public class DumpRegistriesCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bigglobe:dumpRegistries").requires(source -> source.method_9259(4))).executes(context -> {
            try {
                DumpRegistriesCommand.dumpEverything((CommandContext<class_2168>)context);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.bigglobe.registryDump.success"), false);
            }
            catch (Throwable throwable) {
                BigGlobeMod.LOGGER.error("Error dumping registries:", throwable);
                AutoCodecUtil.rethrow((Throwable)throwable);
            }
            return 1;
        }));
    }

    public static void dumpEverything(CommandContext<class_2168> context) {
        File root = new File(FabricLoader.getInstance().getGameDir().toFile(), "bigglobe_registry_dump");
        DumpRegistriesCommand.delete(root);
        File registryRoot = new File(root, "registries");
        File tagsRoot = new File(root, "tags");
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)((class_2168)context.getSource()).method_30497());
        HashMap dynamicCodecs = new HashMap(class_7655.field_39968.size() + class_7655.field_39969.size());
        for (class_7655.class_7657 entry : class_7655.field_39968) {
            dynamicCodecs.put(entry.comp_985(), entry.comp_986());
        }
        for (class_7655.class_7657 entry : class_7655.field_39969) {
            dynamicCodecs.put(entry.comp_985(), entry.comp_986());
        }
        DumpRegistriesCommand.dumpRegistries(context, registryRoot, tagsRoot, dynamicCodecs, (class_6903<JsonElement>)ops);
    }

    public static void dumpRegistries(CommandContext<class_2168> context, File registryRoot, File tagsRoot, Map<class_5321<? extends class_2378<?>>, Codec<?>> dynamicCodecs, class_6903<JsonElement> ops) {
        ((class_2168)context.getSource()).method_30497().method_40311().forEach(dynamicRegistryEntry -> {
            String path = DumpRegistriesCommand.identifierPath(dynamicRegistryEntry.comp_350().method_29177());
            File perRegistryRoot = new File(registryRoot, path);
            File perTagRoot = new File(tagsRoot, path);
            Codec codec = (Codec)dynamicCodecs.get(dynamicRegistryEntry.comp_350());
            if (codec != null) {
                for (Map.Entry elementEntry : dynamicRegistryEntry.comp_351().method_29722()) {
                    codec.encodeStart((DynamicOps)ops, elementEntry.getValue()).resultOrPartial(message -> BigGlobeMod.LOGGER.error("Error dumping " + String.valueOf(elementEntry.getKey()) + ": " + String.valueOf(message))).ifPresent(json_ -> {
                        JsonElement json = (JsonElement)json_;
                        File file = new File(perRegistryRoot, DumpRegistriesCommand.identifierPath(((class_5321)elementEntry.getKey()).method_29177()) + ".json");
                        file.getParentFile().mkdirs();
                        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file, StandardCharsets.UTF_8));){
                            writer.setIndent("\t");
                            Streams.write((JsonElement)json, (JsonWriter)writer);
                        }
                        catch (IOException exception) {
                            BigGlobeMod.LOGGER.error("Error dumping " + String.valueOf(elementEntry.getKey()) + ":", (Throwable)exception);
                        }
                    });
                }
            } else {
                perRegistryRoot.getParentFile().mkdirs();
                try (PrintStream stream = new PrintStream((OutputStream)new FileOutputStream(perRegistryRoot.getPath() + ".txt"), false, StandardCharsets.UTF_8);){
                    dynamicRegistryEntry.comp_351().method_42021().stream().map(class_5321::method_29177).sorted(Comparator.comparing(class_2960::method_12836).thenComparing(class_2960::method_12832)).forEachOrdered(stream::println);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            DumpRegistriesCommand.dumpTags(dynamicRegistryEntry, perTagRoot);
        });
    }

    public static void dumpTags(class_5455.class_6892<?> dynamicRegistryEntry, File perTagRoot) {
        Comparator<class_2960> comparator = Comparator.comparing(class_2960::method_12836).thenComparing(class_2960::method_12832);
        RegistryVersions.streamTags(dynamicRegistryEntry.comp_351()).forEach(list -> {
            File file = new File(perTagRoot, DumpRegistriesCommand.identifierPath(UnregisteredObjectException.getTagKey(list).comp_327()) + ".txt");
            file.getParentFile().mkdirs();
            try (PrintStream stream = new PrintStream((OutputStream)new FileOutputStream(file), false, StandardCharsets.UTF_8);){
                list.method_40239().map(UnregisteredObjectException::getKey).map(class_5321::method_29177).sorted(comparator).forEachOrdered(stream::println);
            }
            catch (IOException exception) {
                BigGlobeMod.LOGGER.error("Error dumping tag #" + String.valueOf(UnregisteredObjectException.getTagKey(list).comp_327()) + ":", (Throwable)exception);
            }
        });
    }

    public static String identifierPath(class_2960 identifier) {
        return identifier.method_12836() + File.separatorChar + identifier.method_12832().replace('/', File.separatorChar);
    }

    public static void delete(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                DumpRegistriesCommand.delete(child);
            }
        }
        file.delete();
    }
}

