/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_7157;

public class EnumArgument<E extends Enum<E>>
implements ArgumentType<E> {
    public static final DynamicCommandExceptionType INVALID_ENUM = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"argument.enum.invalid", (Object[])new Object[]{object}));
    public final Class<E> enumClass;
    public final E[] enumValues;
    public final Map<String, E> lookup;

    public EnumArgument(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.enumValues = (Enum[])enumClass.getEnumConstants();
        this.lookup = new HashMap<String, E>(this.enumValues.length);
        for (E value : this.enumValues) {
            this.lookup.put(((class_3542)value).method_15434(), value);
        }
    }

    public E parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        Enum value = (Enum)this.lookup.get(name);
        if (value != null) {
            return (E)value;
        }
        throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.lookup.keySet(), (SuggestionsBuilder)builder);
    }

    public static class EnumArgumentSerializer
    implements class_2314<EnumArgument<?>, EnumArgumentProperties> {
        public void writePacket(EnumArgumentProperties properties, class_2540 buf) {
            buf.method_10814(properties.enumClass.getName());
        }

        public EnumArgumentProperties fromPacket(class_2540 buf) {
            try {
                return new EnumArgumentProperties(Class.forName(buf.method_19772(), false, EnumArgumentSerializer.class.getClassLoader()).asSubclass(Enum.class));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException(exception);
            }
        }

        public void writeJson(EnumArgumentProperties properties, JsonObject json) {
            json.addProperty("enumClass", properties.enumClass.getName());
        }

        public EnumArgumentProperties getArgumentTypeProperties(EnumArgument<?> argumentType) {
            return new EnumArgumentProperties(argumentType.enumClass);
        }

        public class EnumArgumentProperties
        implements class_2314.class_7217<EnumArgument<?>> {
            public final Class<?> enumClass;

            public EnumArgumentProperties(Class<?> enumClass) {
                this.enumClass = enumClass.asSubclass(Enum.class).asSubclass(class_3542.class);
            }

            public EnumArgument<?> createType(class_7157 commandRegistryAccess) {
                return new EnumArgument(this.enumClass);
            }

            public class_2314<EnumArgument<?>, ?> method_41728() {
                return EnumArgumentSerializer.this;
            }
        }
    }
}

