/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.compat;

import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.config.BigGlobeConfigLoader;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;

public class ClothConfigCompat {
    public static Supplier<BigGlobeConfig> init() {
        try {
            return ClothCode.initCloth();
        }
        catch (LinkageError error) {
            BigGlobeConfigLoader.LOGGER.info("Failed to register ConfigSerializer. Cloth Config is probably not installed.");
            return ClothConfigCompat.initFallback();
        }
    }

    public static Supplier<BigGlobeConfig> initFallback() {
        return Suppliers.ofInstance((Object)BigGlobeConfigLoader.loadAndSave());
    }

    public static class ClothCode {
        public static Supplier<BigGlobeConfig> initCloth() {
            AutoConfig.register(BigGlobeConfig.class.asSubclass(ConfigData.class), ClothCode::createSerializer);
            return AutoConfig.getConfigHolder(BigGlobeConfig.class.asSubclass(ConfigData.class));
        }

        public static ConfigSerializer<ConfigData> createSerializer(Config config, Class<?> clazz) {
            return new ConfigSerializer<ConfigData>(){

                public void serialize(ConfigData config) throws ConfigSerializer.SerializationException {
                    try {
                        BigGlobeConfigLoader.save((BigGlobeConfig)config);
                    }
                    catch (Exception exception) {
                        throw new ConfigSerializer.SerializationException((Throwable)exception);
                    }
                }

                public ConfigData deserialize() throws ConfigSerializer.SerializationException {
                    try {
                        return (ConfigData)BigGlobeConfigLoader.load();
                    }
                    catch (Exception exception) {
                        throw new ConfigSerializer.SerializationException((Throwable)exception);
                    }
                }

                public ConfigData createDefault() {
                    return (ConfigData)new BigGlobeConfig();
                }
            };
        }
    }
}

