/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.compat;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.ClientState;
import builderb0y.bigglobe.compat.InstalledMods;
import builderb0y.bigglobe.mixinInterfaces.LodSystemHolder;
import builderb0y.bigglobe.versions.EntityVersions;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.network.PacketRedirection;

public class ImmersivePortalsCompat {
    public static void init() {
        if (InstalledMods.DIMLIB) {
            try {
                DimLibCode.init();
            }
            catch (LinkageError error) {
                InstalledMods.DIMLIB = false;
                BigGlobeMod.LOGGER.error("Failed to setup DimLib integration:", (Throwable)error);
            }
        }
        if (InstalledMods.IMMERSIVE_PORTALS) {
            try {
                IPCode.init();
            }
            catch (LinkageError error) {
                InstalledMods.IMMERSIVE_PORTALS = false;
                BigGlobeMod.LOGGER.error("Exception setting up immersive portals integration:", (Throwable)error);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        if (InstalledMods.DIMLIB) {
            try {
                DimLibCode.initClient();
            }
            catch (LinkageError error) {
                InstalledMods.DIMLIB = false;
                BigGlobeMod.LOGGER.error("Failed to setup DimLib integration:", (Throwable)error);
            }
        }
        if (InstalledMods.IMMERSIVE_PORTALS) {
            try {
                IPCode.initClient();
            }
            catch (LinkageError error) {
                InstalledMods.IMMERSIVE_PORTALS = false;
                BigGlobeMod.LOGGER.error("Exception setting up immersive portals integration:", (Throwable)error);
            }
        }
    }

    public static void forEachDimension(MinecraftServer server, class_3222 player, BiConsumer<class_3218, class_3222> action) {
        if (InstalledMods.IMMERSIVE_PORTALS) {
            try {
                IPCode.forEachDimension(server, player, action);
            }
            catch (LinkageError error) {
                InstalledMods.IMMERSIVE_PORTALS = false;
                BigGlobeMod.LOGGER.error("Exception performing action for all dimensions", (Throwable)error);
            }
        } else {
            action.accept(EntityVersions.getServerWorld(player), player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static LodSystemHolder getLodSystem(class_5321<class_1937> dimensionKey) {
        class_638 world;
        if (InstalledMods.IMMERSIVE_PORTALS) {
            try {
                return IPCode.getLodSystem(dimensionKey);
            }
            catch (LinkageError error) {
                InstalledMods.IMMERSIVE_PORTALS = false;
                BigGlobeMod.LOGGER.error("Exception getting world renderer for " + String.valueOf(dimensionKey), (Throwable)error);
            }
        }
        if ((world = class_310.method_1551().field_1687) != null && world.method_27983() == dimensionKey) {
            return LodSystemHolder.of(class_310.method_1551().field_1769);
        }
        return null;
    }

    public static class DimLibCode {
        public static void init() {
        }

        @Environment(value=EnvType.CLIENT)
        public static void initClient() {
            DimensionAPI.CLIENT_DIMENSION_UPDATE_EVENT.register(ClientState::retain);
        }
    }

    public static class IPCode {
        public static Set<class_5321<class_1937>> WORLDS = new HashSet<class_5321<class_1937>>();

        public static void init() {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                WORLDS = new HashSet<class_5321<class_1937>>(server.method_29435());
            });
            DimensionAPI.SERVER_DIMENSION_DYNAMIC_UPDATE_EVENT.register((Object)new DimensionAPI.ServerDynamicUpdateListener(){

                public void run(MinecraftServer server, Set<class_5321<class_1937>> worlds) {
                    for (class_5321<class_1937> world : worlds) {
                        if (WORLDS.remove(world)) continue;
                        this.onWorldAdded(server, world);
                    }
                    for (class_5321<class_1937> world : WORLDS) {
                        this.onWorldRemoved(server, world);
                    }
                    WORLDS = new HashSet<class_5321<class_1937>>(worlds);
                }

                public void onWorldAdded(MinecraftServer server, class_5321<class_1937> worldKey) {
                    class_3218 serverWorld = server.method_3847(worldKey);
                    if (serverWorld != null) {
                        for (class_3222 player : server.method_3760().method_14571()) {
                            PacketRedirection.withForceRedirect((class_3218)serverWorld, () -> ClientState.sync(serverWorld, player));
                        }
                    }
                }

                public void onWorldRemoved(MinecraftServer server, class_5321<class_1937> worldKey) {
                }
            });
        }

        @Environment(value=EnvType.CLIENT)
        public static void initClient() {
        }

        public static void forEachDimension(MinecraftServer server, class_3222 player, BiConsumer<class_3218, class_3222> action) {
            for (class_3218 serverWorld : server.method_3738()) {
                PacketRedirection.withForceRedirect((class_3218)serverWorld, () -> action.accept(serverWorld, player));
            }
        }

        @Environment(value=EnvType.CLIENT)
        @Nullable
        public static LodSystemHolder getLodSystem(class_5321<class_1937> dimensionKey) {
            return LodSystemHolder.of((class_761)ClientWorldLoader.WORLD_RENDERER_MAP.get(dimensionKey));
        }
    }
}

