/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.datagen;

import builderb0y.bigglobe.blocks.CloudColor;
import builderb0y.bigglobe.math.Interpolator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.joml.Vector3dc;

public class BottledAuraDataGenerator {
    public static final File WIP = new File("src/main/resources/wip");
    public static final File BASE_PATH = new File(WIP, "bottled_aura");

    public static void main(String[] args) throws IOException {
        BASE_PATH.mkdirs();
        File textures = new File(BASE_PATH, "textures");
        File models = new File(BASE_PATH, "models");
        textures.mkdirs();
        models.mkdirs();
        BufferedImage bottle = ImageIO.read(new File(WIP, "aura_bottle.png"));
        BufferedImage aura = ImageIO.read(new File(WIP, "aura.png"));
        byte[] readPixel = new byte[4];
        int[] writePixel = new int[1];
        for (CloudColor color : CloudColor.VALUES) {
            BufferedImage texture;
            if (color == CloudColor.BLANK) {
                texture = null;
            } else if (color == CloudColor.RAINBOW) {
                texture = new BufferedImage(16, 1600, 2);
                for (int frame = 0; frame < 100; ++frame) {
                    for (int y = 0; y < 16; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            aura.getRaster().getDataElements(x, y, readPixel);
                            if (readPixel[0] != 0) {
                                writePixel[0] = BottledAuraDataGenerator.multiplyColor(readPixel, color.getColor((double)frame / 100.0));
                            } else {
                                bottle.getRaster().getDataElements(x, y, readPixel);
                                BottledAuraDataGenerator.transferColor(readPixel, writePixel);
                            }
                            texture.getRaster().setDataElements(x, y + frame * 16, writePixel);
                        }
                    }
                }
                ImageIO.write((RenderedImage)texture, "png", new File(textures, "omni_bottled_aura.png"));
            } else {
                texture = new BufferedImage(16, 16, 2);
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        aura.getRaster().getDataElements(x, y, readPixel);
                        if (readPixel[0] != 0) {
                            writePixel[0] = BottledAuraDataGenerator.multiplyColor(readPixel, color.color);
                        } else {
                            bottle.getRaster().getDataElements(x, y, readPixel);
                            BottledAuraDataGenerator.transferColor(readPixel, writePixel);
                        }
                        texture.getRaster().setDataElements(x, y, writePixel);
                    }
                }
                ImageIO.write((RenderedImage)texture, "png", new File(textures, color.bottleName + ".png"));
            }
            if (texture == null) continue;
            try (FileWriter writer = new FileWriter(new File(models, color.bottleName + ".json"), StandardCharsets.UTF_8);){
                writer.write("{\n\t\"parent\": \"item/generated\",\n\t\"textures\": {\n\t\t\"layer0\": \"bigglobe:item/%NAME\"\n\t}\n}".replace("%NAME", color.bottleName));
            }
        }
    }

    public static int multiplyColor(byte[] color, Vector3dc tint) {
        double red = (double)(color[0] & 0xFF) * tint.x() + 0.5;
        double green = (double)(color[1] & 0xFF) * tint.y() + 0.5;
        double blue = (double)(color[2] & 0xFF) * tint.z() + 0.5;
        int r = Interpolator.clamp(0, 255, (int)red);
        int g = Interpolator.clamp(0, 255, (int)green);
        int b = Interpolator.clamp(0, 255, (int)blue);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void transferColor(byte[] from, int[] to) {
        to[0] = (from[3] & 0xFF) << 24 | from[2] & 0xFF | (from[1] & 0xFF) << 8 | (from[0] & 0xFF) << 16;
    }
}

