/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.entities;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.entities.BigGlobeEntityRenderer;
import builderb0y.bigglobe.entities.WaypointEntity;
import builderb0y.bigglobe.math.BigGlobeMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class WaypointEntityRenderer
extends BigGlobeEntityRenderer<WaypointEntity, State> {
    public static final class_2960 TEXTURE = BigGlobeMod.mcID("textures/particle/flash.png");
    public static class_1921 LIGHTNING_LAYER;

    public WaypointEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public class_1921 getRenderLayer() {
        return LIGHTNING_LAYER;
    }

    @Override
    public void doRender(State state, class_4587.class_4665 matrices, class_4588 buffer, class_243 camera, int light) {
        Vector3f cameraToPos = new Vector3f((float)(state.field_53325 - camera.field_1352), (float)(state.field_53326 - camera.field_1351 + 1.0), (float)(state.field_53327 - camera.field_1350));
        Vector4f transform = new Vector4f();
        Vector3f position = new Vector3f();
        Vector3f tangent = new Vector3f();
        Vector3f side = new Vector3f();
        Vector3f prevPosition = new Vector3f();
        Vector3f prevTangent = new Vector3f();
        Vector3f prevSide = new Vector3f();
        float size = 0.0f;
        float prevSize = 0.0f;
        int maxOrbits = BigGlobeMath.roundI(state.health / 5.0f * (float)state.orbits.length);
        for (int orbitIndex = 0; orbitIndex < maxOrbits; ++orbitIndex) {
            WaypointEntity.Orbit orbit = state.orbits[orbitIndex];
            for (int history = 0; history <= 32; ++history) {
                if (history != 0) {
                    prevPosition.set((Vector3fc)position);
                    prevTangent.set((Vector3fc)tangent);
                    prevSide.set((Vector3fc)side);
                    prevSize = size;
                }
                float historyF = (float)history * 0.03125f;
                orbit.getPositionAndVelocity(position, tangent, historyF * historyF, state.partialTicks);
                position.add((Vector3fc)cameraToPos).cross((Vector3fc)tangent, side).normalize();
                size = (float)Math.sqrt(historyF) * BigGlobeMath.squareF(1.0f - historyF) * 0.25f;
                if (history == 0) continue;
                WaypointEntityRenderer.vertex(buffer, matrices, prevPosition.x, prevPosition.y, prevPosition.z, orbit.r * 0.5f + 0.5f, orbit.g * 0.5f + 0.5f, orbit.b * 0.5f + 0.5f, 1.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, prevPosition.x + prevSide.x * prevSize, prevPosition.y + prevSide.y * prevSize, prevPosition.z + prevSide.z * prevSize, orbit.r * 0.5f, orbit.g * 0.5f, orbit.b * 0.5f, 0.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, position.x + side.x * size, position.y + side.y * size, position.z + side.z * size, orbit.r * 0.5f, orbit.g * 0.5f, orbit.b * 0.5f, 0.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, position.x, position.y, position.z, orbit.r * 0.5f + 0.5f, orbit.g * 0.5f + 0.5f, orbit.b * 0.5f + 0.5f, 1.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, prevPosition.x - prevSide.x * prevSize, prevPosition.y - prevSide.y * prevSize, prevPosition.z - prevSide.z * prevSize, orbit.r * 0.5f, orbit.g * 0.5f, orbit.b * 0.5f, 0.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, prevPosition.x, prevPosition.y, prevPosition.z, orbit.r * 0.5f + 0.5f, orbit.g * 0.5f + 0.5f, orbit.b * 0.5f + 0.5f, 1.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, position.x, position.y, position.z, orbit.r * 0.5f + 0.5f, orbit.g * 0.5f + 0.5f, orbit.b * 0.5f + 0.5f, 1.0f, transform);
                WaypointEntityRenderer.vertex(buffer, matrices, position.x - side.x * size, position.y - side.y * size, position.z - side.z * size, orbit.r * 0.5f, orbit.g * 0.5f, orbit.b * 0.5f, 0.0f, transform);
            }
        }
    }

    public static void vertex(class_4588 buffer, class_4587.class_4665 matrices, float x, float y, float z, float r, float g, float b, float a, Vector4f scratch) {
        buffer.method_22912(x, y, z).method_22915(r, g, b, a);
    }

    @Override
    public State createState() {
        return new State();
    }

    @Override
    public void updateState(WaypointEntity entity, State state, float partialTicks) {
        state.field_53328 = (float)entity.field_6012 + partialTicks;
        state.partialTicks = partialTicks;
        state.health = entity.health;
        state.orbits = WaypointEntity.Orbit.copy(entity.orbits, state.orbits);
    }

    static {
        class_1921 layer = class_1921.method_23593();
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            try {
                layer = (class_1921)Class.forName("net.irisshaders.iris.pathways.LightningHandler").getDeclaredField("IRIS_LIGHTNING").get(null);
                BigGlobeMod.LOGGER.info("Using new iris lightning render layer.");
            }
            catch (Exception exception) {
                try {
                    layer = (class_1921)Class.forName("net.coderbot.iris.pipeline.LightningHandler").getDeclaredField("IRIS_LIGHTNING").get(null);
                    BigGlobeMod.LOGGER.info("Using old iris lightning render layer.");
                }
                catch (Exception exception2) {
                    BigGlobeMod.LOGGER.info("Could not locate iris lightning render layer...");
                }
            }
        }
        LIGHTNING_LAYER = layer;
    }

    public static class State
    extends BigGlobeEntityRenderer.State {
        public float health;
        public float partialTicks;
        public WaypointEntity.Orbit[] orbits;
    }
}

