/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.perSection.SectionUtil;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.features.DummyFeature;
import builderb0y.bigglobe.features.RockReplacerFeature;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.util.Async;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import com.mojang.serialization.Codec;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2841;
import net.minecraft.class_5539;
import net.minecraft.class_6490;

public class BedrockFeature
extends DummyFeature<Config>
implements RockReplacerFeature<Config> {
    public BedrockFeature(Codec<Config> codec) {
        super(codec);
    }

    public BedrockFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    @Override
    public void replaceRocks(BigGlobeScriptedChunkGenerator generator, WorldWrapper worldWrapper, class_2791 chunk, int minSection, int maxSection, Config config) {
        long chunkSeed = Permuter.permute(generator.columnSeed ^ 0x6AF67A31DF787629L, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        int adjustedEmptyY = config.empty_y + Integer.signum(config.full_y - config.empty_y);
        int minY = Math.min(config.full_y, adjustedEmptyY);
        int maxY = Math.max(config.full_y, adjustedEmptyY);
        int clampedMinY = Math.max(minY, HeightLimitViewVersions.getMinY((class_5539)chunk));
        int clampedMaxY = Math.min(maxY, HeightLimitViewVersions.getMaxY((class_5539)chunk) - 1);
        int sectionMinY = clampedMinY >> 4;
        int sectionMaxY = clampedMaxY >> 4;
        Async.loop(BigGlobeThreadPool.autoExecutor(), sectionMinY, sectionMaxY + 1, 1, yCoord -> {
            int startY = yCoord << 4;
            long sectionSeed = Permuter.permute(chunkSeed, yCoord);
            class_2841 container = chunk.method_38259(chunk.method_31603(yCoord)).method_12265();
            int toID = SectionUtil.id(container, config.state);
            class_6490 storage = SectionUtil.storage(container);
            int minYRelative = Math.max(clampedMinY - startY, 0);
            int maxYRelative = Math.min(clampedMaxY - startY, 15);
            int index = minYRelative;
            while (index >>> 8 <= maxYRelative) {
                double chance;
                int y = startY | index >>> 8;
                long blockSeed = Permuter.permute(sectionSeed, index);
                if (Permuter.nextChancedBoolean(blockSeed, chance = BigGlobeMath.squareD(Interpolator.unmixLinear((double)config.empty_y, (double)config.full_y, (double)y)))) {
                    storage.method_15210(index, toID);
                }
                ++index;
            }
        });
    }

    public static class Config
    extends DummyFeature.DummyConfig {
        public final @BlockStateCoder.VerifyNormal class_2680 state;
        public final int full_y;
        public final int empty_y;

        public Config(class_2680 state, int full_y, int empty_y) {
            this.state = state;
            this.full_y = full_y;
            this.empty_y = empty_y;
        }
    }
}

