/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.restrictions.ColumnRestriction;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.dynamicRegistries.WoodPalette;
import builderb0y.bigglobe.features.BlockQueue;
import builderb0y.bigglobe.features.SerializableBlockQueue;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.trees.TreeGenerator;
import builderb0y.bigglobe.trees.branches.BranchesConfig;
import builderb0y.bigglobe.trees.branches.ScriptedBranchShape;
import builderb0y.bigglobe.trees.decoration.BallLeafDecorator;
import builderb0y.bigglobe.trees.decoration.BlockDecorator;
import builderb0y.bigglobe.trees.decoration.DecoratorConfig;
import builderb0y.bigglobe.trees.decoration.PostFeatureDecorator;
import builderb0y.bigglobe.trees.decoration.ShelfDecorator;
import builderb0y.bigglobe.trees.decoration.ShelfPlacer;
import builderb0y.bigglobe.trees.trunks.TrunkConfig;
import builderb0y.bigglobe.trees.trunks.TrunkFactory;
import builderb0y.bigglobe.util.BlockState2ObjectMap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.random.RandomGenerator;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5539;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NaturalTreeFeature
extends class_3031<Config> {
    public NaturalTreeFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public NaturalTreeFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    public boolean method_13151(class_5821<Config> context) {
        BranchesConfig branchesConfig;
        Config config = (Config)context.method_33656();
        boolean distantHorizons = DistantHorizonsCompat.isOnDistantHorizonThread();
        if (config.delay_generation && distantHorizons) {
            return false;
        }
        class_2794 class_27942 = context.method_33653();
        if (!(class_27942 instanceof BigGlobeScriptedChunkGenerator)) {
            return false;
        }
        BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
        Permuter permuter = Permuter.from(context.method_33654());
        class_2338 origin = context.method_33655();
        double startX = (double)origin.method_10263() + Permuter.nextUniformDouble(permuter) * 0.5;
        int startY = origin.method_10264();
        double startZ = (double)origin.method_10260() + Permuter.nextUniformDouble(permuter) * 0.5;
        ScriptedColumnLookup.Impl columns = generator.newColumnLookup((class_5539)context.method_33652(), ScriptedColumn.ColumnUsage.FEATURES.maybeDhHints(distantHorizons));
        ScriptedColumn column = columns.lookupColumn(origin.method_10263(), origin.method_10260());
        double height = config.height.get(column, permuter, origin.method_10264());
        if (!(height > 0.0)) {
            return false;
        }
        TrunkConfig trunkConfig = config.trunk.create(column, startX, startY, startZ, Math.max(Permuter.roundRandomlyI((RandomGenerator)permuter, height), 4), permuter);
        if (config.branches != null) {
            double startFracY = config.branches.start_frac_y.get(column, startY, permuter);
            branchesConfig = BranchesConfig.create(startFracY, Permuter.roundRandomlyI((RandomGenerator)permuter, config.branches.count_per_layer.get(column, startY, permuter) * height * (1.0 - startFracY)), permuter.nextDouble(Math.PI * 2), trunkConfig.baseRadius, config.branches.length_function, config.branches.height_function);
        } else {
            branchesConfig = null;
        }
        DecoratorConfig.Builder decoratorsBuilder = new DecoratorConfig.Builder();
        if (config.decorations != null) {
            config.decorations.addTo(decoratorsBuilder);
        }
        if (config.shelves != null && config.shelves.length != 0) {
            RandomList<ShelfPlacer> shelves = new RandomList<ShelfPlacer>(config.shelves.length);
            for (Shelf shelf : config.shelves) {
                shelves.add(ShelfPlacer.create(shelf.state), shelf.restrictions.getRestriction(column, startY));
            }
            if (shelves.totalWeight > 0.0) {
                decoratorsBuilder.trunkLayer(new ShelfDecorator(shelves, branchesConfig != null ? branchesConfig.startFracY : (config.stump != null ? config.stump.cutoff_frac.minValue() : 1.0), shelves.totalWeight));
            }
        }
        return new TreeGenerator(columns, context.method_33652(), config.delay_generation ? new SerializableBlockQueue(origin.method_10263(), origin.method_10264(), origin.method_10260(), false) : new BlockQueue(false), permuter, (WoodPalette)config.palette.comp_349(), config.ground_replacements, trunkConfig, branchesConfig, decoratorsBuilder.build(), config.stump != null ? config.stump.cutoff_frac : null).generate();
    }

    public record Config(@DefaultBoolean(value=false) boolean delay_generation, class_6880<WoodPalette> palette, BlockState2ObjectMap<class_2680> ground_replacements, ColumnScript.ColumnRandomYToDoubleScript.Holder height, TrunkFactory trunk, @VerifyNullable Branches branches, Shelf @VerifyNullable [] shelves, @VerifyNullable Decorations decorations, @VerifyNullable Stump stump) implements class_3037
    {
    }

    public record Branches(RandomSource start_frac_y, RandomSource count_per_layer, ScriptedBranchShape.Holder length_function, ScriptedBranchShape.Holder height_function) {
    }

    public record Decorations(BlockDecorator @VerifyNullable [] trunk, BlockDecorator @VerifyNullable [] branches, BlockDecorator @VerifyNullable [] leaves, @VerifyNullable BallLeaves ball_leaves, @VerifyNullable PostFeatureDecorator post_feature) {
        public static List<BlockDecorator> addAll(@NotNull BlockDecorator @Nullable [] toAdd, @Nullable List<@NotNull BlockDecorator> addTo) {
            if (toAdd != null && toAdd.length != 0) {
                if (addTo == null) {
                    addTo = new ArrayList<BlockDecorator>(toAdd.length + 2);
                }
                addTo.addAll(Arrays.asList(toAdd));
            }
            return addTo;
        }

        public void addTo(DecoratorConfig.Builder builder) {
            builder.trunkBlock = Decorations.addAll(this.trunk, builder.trunkBlock);
            builder.branchBlock = Decorations.addAll(this.branches, builder.branchBlock);
            builder.leafBlock = Decorations.addAll(this.leaves, builder.leafBlock);
            if (this.ball_leaves != null) {
                BallLeafDecorator decorator = new BallLeafDecorator(this.ball_leaves.inner_state);
                builder.branch(decorator).trunk(decorator);
            }
            if (this.post_feature != null) {
                builder.trunk(this.post_feature);
            }
        }
    }

    public record Shelf(class_2680 state, ColumnRestriction restrictions) {
    }

    public record Stump(RandomSource cutoff_frac) {
    }

    public record BallLeaves(class_2680 inner_state) {
    }
}

