/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.data.AbstractNumberData;
import builderb0y.autocodec.data.ByteListData;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.IntListData;
import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.data.StringData;
import builderb0y.autocodec.data.UnknownData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.blockEntities.DelayedGenerationBlockEntity;
import builderb0y.bigglobe.blocks.BigGlobeBlockTags;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.features.BlockQueue;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.versions.BlockEntityVersions;
import builderb0y.bigglobe.versions.BlockStateVersions;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@UseCoder(name="CODER", in=SerializableBlockQueue.class, usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public class SerializableBlockQueue
extends BlockQueue {
    public static final boolean DEBUG_ALWAYS_SERIALIZE = false;
    public static final AutoCoder<SerializableBlockQueue> CODER = new AutoCoder.NamedCoder<SerializableBlockQueue>(ReifiedType.from(SerializableBlockQueue.class)){

        @ApiStatus.OverrideOnly
        @Nullable
        public <T_Encoded> SerializableBlockQueue decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            if (context.data.isEmpty()) {
                return null;
            }
            MapData map = context.data.tryAsMap();
            if (map == null) {
                throw (DecodeException)((Object)context.notA("map"));
            }
            return SerializableBlockQueue.read(map);
        }

        @ApiStatus.OverrideOnly
        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, SerializableBlockQueue> context) throws EncodeException {
            SerializableBlockQueue queue = (SerializableBlockQueue)context.object;
            return queue == null ? EmptyData.INSTANCE : queue.toData();
        }
    };
    @NotNull
    public Long2ObjectLinkedOpenHashMap<class_2680> queuedReplacements = new Long2ObjectLinkedOpenHashMap(64);
    public int centerX;
    public int centerY;
    public int centerZ;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public SerializableBlockQueue(int centerX, int centerY, int centerZ, int flags) {
        super(flags);
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.minX = centerX;
        this.minY = centerY;
        this.minZ = centerZ;
        this.maxX = centerX;
        this.maxY = centerY;
        this.maxZ = centerZ;
    }

    public SerializableBlockQueue(int centerX, int centerY, int centerZ, boolean causeBlockUpdates) {
        this(centerX, centerY, centerZ, causeBlockUpdates ? 3 : 18);
    }

    @Override
    public void queueBlock(long pos, class_2680 state) {
        super.queueBlock(pos, state);
        int x = class_2338.method_10061((long)pos);
        int y = class_2338.method_10071((long)pos);
        int z = class_2338.method_10083((long)pos);
        this.minX = Math.min(this.minX, x);
        this.minY = Math.min(this.minY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxX = Math.max(this.maxX, x);
        this.maxY = Math.max(this.maxY, y);
        this.maxZ = Math.max(this.maxZ, z);
    }

    @Override
    public void queueReplacement(long pos, class_2680 from, class_2680 to) {
        super.queueReplacement(pos, from, to);
        this.queuedReplacements.put(pos, (Object)from);
    }

    @Override
    public void placeQueuedBlocks(class_1936 world) {
        class_2338 pos = new class_2338(this.centerX, this.centerY, this.centerZ);
        class_2680 oldState = world.method_8320(pos);
        class_2586 oldBlockEntity = world.method_8321(pos);
        class_2487 oldBlockData = oldBlockEntity == null ? null : BlockEntityVersions.writeToNbt(oldBlockEntity);
        WorldUtil.setBlockState(world, pos, BlockStates.DELAYED_GENERATION, this.flags);
        DelayedGenerationBlockEntity blockEntity = WorldUtil.getBlockEntity((class_1922)world, pos, DelayedGenerationBlockEntity.class);
        if (blockEntity != null) {
            blockEntity.blockQueue = this;
            blockEntity.oldState = oldState;
            blockEntity.oldBlockData = oldBlockData;
        }
    }

    public void actuallyPlaceQueuedBlocks(class_1936 world) {
        super.placeQueuedBlocks(world);
    }

    public boolean hasSpace(class_1936 world) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        LongBidirectionalIterator iterator = this.queuedBlocks.keySet().iterator();
        while (iterator.hasNext()) {
            class_2680 state;
            long longPos = iterator.nextLong();
            if (this.canReplace(longPos, state = world.method_8320((class_2338)pos.method_16363(longPos)))) continue;
            return false;
        }
        return true;
    }

    public boolean canReplace(long pos, class_2680 state) {
        return SerializableBlockQueue.canImplicitlyReplace(state) || this.queuedReplacements.get(pos) == state;
    }

    public static boolean canImplicitlyReplace(class_2680 state) {
        return BlockStateVersions.isReplaceable(state) || state.method_26164(BigGlobeBlockTags.PLANTS);
    }

    public static SerializableBlockQueue read(MapData data) {
        int flags = data.get("flags").getAsIntOr(3);
        IntListData center = data.get("center").tryAsIntList();
        if (center == null || center.size() != 3) {
            throw new IllegalArgumentException("Malformed center");
        }
        int centerX = center.getInt(0);
        int centerY = center.getInt(1);
        int centerZ = center.getInt(2);
        SerializableBlockQueue queue = new SerializableBlockQueue(centerX, centerY, centerZ, flags);
        ListData paletteData = data.get("palette").tryAsList();
        if (paletteData == null) {
            throw new IllegalArgumentException("Malformed palette");
        }
        ObjectArrayList palette = new ObjectArrayList(paletteData.size());
        BetterRegistry<class_2248> blockRegistry = BigGlobeMod.getRegistry(class_7924.field_41254);
        for (Data element : paletteData) {
            StringData string = element.tryAsString();
            if (string != null) {
                palette.add((Object)BlockStateCoder.decodeState(blockRegistry, string.value).unwrapEager(arg_0 -> ((Logger)BigGlobeMod.LOGGER).warn(arg_0), IllegalArgumentException::new).state());
                continue;
            }
            throw new IllegalArgumentException("Block state is not encoded as a string: " + String.valueOf(element));
        }
        SerializableBlockQueue.readBlocks(centerX, centerY, centerZ, (ObjectList<class_2680>)palette, data, "blocks", queue::queueBlock);
        SerializableBlockQueue.readBlocks(centerX, centerY, centerZ, (ObjectList<class_2680>)palette, data, "replacements", (arg_0, arg_1) -> queue.queuedReplacements.put(arg_0, arg_1));
        ListData blockEntities = data.get("blockEntities").tryAsList();
        if (blockEntities != null && !blockEntities.isEmpty()) {
            for (Data blockEntityElement : blockEntities) {
                MapData blockEntityData = blockEntityElement.tryAsMap();
                if (blockEntityData != null) {
                    class_2586 blockEntity;
                    AbstractNumberData x = blockEntityData.get("x").tryAsNumber();
                    if (x == null) {
                        throw new IllegalArgumentException("Malformed x");
                    }
                    AbstractNumberData y = blockEntityData.get("y").tryAsNumber();
                    if (y == null) {
                        throw new IllegalArgumentException("Malformed y");
                    }
                    AbstractNumberData z = blockEntityData.get("z").tryAsNumber();
                    if (z == null) {
                        throw new IllegalArgumentException("Malformed z");
                    }
                    class_2338 pos = new class_2338(x.intValue(), y.intValue(), z.intValue());
                    class_2680 state = (class_2680)queue.queuedBlocks.get(pos.method_10063());
                    if (state == null || !state.method_31709() || (blockEntity = BlockEntityVersions.createFromNbt(pos, state, (class_2487)blockEntityData.convert((DynamicOps)class_2509.field_11560))) == null) continue;
                    queue.queueBlockEntity(pos, blockEntity);
                    continue;
                }
                throw new IllegalArgumentException("Non-compound block entity");
            }
        }
        return queue;
    }

    public static void readBlocks(int centerX, int centerY, int centerZ, ObjectList<class_2680> palette, MapData data, String key, LongPosStateConsumer adder) {
        ByteListData byteArray = data.get(key).tryAsByteList();
        if (byteArray == null || (byteArray.size() & 3) != 0) {
            throw new IllegalArgumentException("Malformed " + key);
        }
        int index = 0;
        int length = byteArray.size();
        while (index < length) {
            int x = centerX + byteArray.getByte(index++);
            int y = centerY + byteArray.getByte(index++);
            int z = centerZ + byteArray.getByte(index++);
            class_2680 state = (class_2680)palette.get(Byte.toUnsignedInt(byteArray.getByte(index++)));
            adder.accept(class_2338.method_10064((int)x, (int)y, (int)z), state);
        }
    }

    public MapData toData() {
        MapData data = new MapData();
        data.putIntList("center", new int[]{this.centerX, this.centerY, this.centerZ});
        data.putInt("flags", this.flags);
        Object2ByteOpenHashMap palette = new Object2ByteOpenHashMap(16);
        ListData paletteData = new ListData();
        this.addToPalette((Object2ByteMap<class_2680>)palette, paletteData, (Long2ObjectMap<class_2680>)this.queuedBlocks);
        this.addToPalette((Object2ByteMap<class_2680>)palette, paletteData, (Long2ObjectMap<class_2680>)this.queuedReplacements);
        data.put("palette", (Data)paletteData);
        data.put("blocks", (Data)this.writeBlocks((Object2ByteMap<class_2680>)palette, (Long2ObjectMap<class_2680>)this.queuedBlocks));
        data.put("replacements", (Data)this.writeBlocks((Object2ByteMap<class_2680>)palette, (Long2ObjectMap<class_2680>)this.queuedReplacements));
        if (!this.queuedBlockEntities.isEmpty()) {
            ListData blockEntities = new ListData();
            for (class_2586 blockEntity : this.queuedBlockEntities.values()) {
                blockEntities.value.add(new UnknownData((DynamicOps)class_2509.field_11560, (Object)BlockEntityVersions.writeToNbt(blockEntity)));
            }
            data.put("blockEntities", (Data)blockEntities);
        }
        return data;
    }

    public void addToPalette(Object2ByteMap<class_2680> palette, ListData paletteData, Long2ObjectMap<class_2680> blocks) {
        for (class_2680 state : blocks.values()) {
            if (palette.containsKey((Object)state)) continue;
            palette.put((Object)state, BigGlobeMath.toUnsignedByteExact(palette.size()));
            paletteData.value.add(new StringData(class_2259.method_9685((class_2680)state)));
        }
    }

    public ByteListData writeBlocks(Object2ByteMap<class_2680> palette, Long2ObjectMap<class_2680> blocks) {
        ByteArrayList blocksNBT = new ByteArrayList(blocks.size() << 2);
        ObjectIterator iterator = Long2ObjectMaps.fastIterator(blocks);
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            byte x = BigGlobeMath.toByteExact(class_2338.method_10061((long)entry.getLongKey()) - this.centerX);
            byte y = BigGlobeMath.toByteExact(class_2338.method_10071((long)entry.getLongKey()) - this.centerY);
            byte z = BigGlobeMath.toByteExact(class_2338.method_10083((long)entry.getLongKey()) - this.centerZ);
            byte id = palette.getByte(entry.getValue());
            blocksNBT.add(x);
            blocksNBT.add(y);
            blocksNBT.add(z);
            blocksNBT.add(id);
        }
        assert (blocksNBT.size() == blocksNBT.elements().length);
        return new ByteListData((ByteList)blocksNBT);
    }

    @Override
    public Object[] intellij_childrenArray() {
        return new Object[]{Map.entry("flags", this.flags), Map.entry("queuedBlocks", SerializableBlockQueue.intellij_decodePositions(this.queuedBlocks)), Map.entry("queuedReplacements", SerializableBlockQueue.intellij_decodePositions(this.queuedReplacements)), Map.entry("queuedBlockEntities", SerializableBlockQueue.intellij_decodePositions(this.queuedBlockEntities))};
    }

    @FunctionalInterface
    public static interface LongPosStateConsumer {
        public void accept(long var1, class_2680 var3);
    }
}

