/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.hyperspace;

import builderb0y.autocodec.annotations.EncodeInline;
import builderb0y.autocodec.annotations.Hidden;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.hyperspace.HyperspaceConstants;
import builderb0y.bigglobe.hyperspace.PackedPos;
import builderb0y.bigglobe.hyperspace.PackedWorldPos;
import builderb0y.bigglobe.hyperspace.PlayerWaypointData;
import builderb0y.bigglobe.hyperspace.WaypointData;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.mixins.Entity_CurrentIdGetter;
import java.util.UUID;
import net.minecraft.class_2561;

public record ServerWaypointData(int id, @Hidden int entityId, @VerifyNullable UUID owner, @EncodeInline PackedWorldPos pos, @VerifyNullable class_2561 name) implements WaypointData
{
    public ServerWaypointData(int id, @VerifyNullable UUID owner, PackedWorldPos pos, @VerifyNullable class_2561 name) {
        this(id, Entity_CurrentIdGetter.bigglobe_getCurrentID().incrementAndGet(), owner, pos, name);
    }

    @Override
    public PackedWorldPos destinationPosition() {
        return this.pos;
    }

    @Override
    public PackedWorldPos displayPosition() {
        return this.pos;
    }

    public ServerWaypointData withName(class_2561 name) {
        return new ServerWaypointData(this.id, this.entityId, this.owner, this.pos, name);
    }

    public PlayerWaypointData relativize(PackedPos entrance) {
        double x = this.pos.x() - entrance.x();
        double y = this.pos.y() - entrance.y();
        double z = this.pos.z() - entrance.z();
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            double scalar = 1.0 / Math.sqrt(Math.sqrt(BigGlobeMath.squareD(x, y, z)));
            x *= scalar;
            y *= scalar;
            z *= scalar;
        }
        return new PlayerWaypointData(this, new PackedWorldPos(HyperspaceConstants.WORLD_KEY, x, y, z));
    }

    public PlayerWaypointData absolutize() {
        return new PlayerWaypointData(this, this.pos);
    }

    public PlayerWaypointData toClientData(PackedPos entrance) {
        return entrance != null ? this.relativize(entrance) : this.absolutize();
    }
}

