/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.math.pointSequences;

import builderb0y.bigglobe.math.pointSequences.PointIterator2D;
import builderb0y.bigglobe.noise.Permuter;
import java.util.random.RandomGenerator;

public class GoldenSpiralIterator
implements PointIterator2D {
    public static final double GOLDEN_ANGLE = 2.3999632297286535;
    public static final double SIN_GOLDEN_ANGLE = Math.sin(2.3999632297286535);
    public static final double COS_GOLDEN_ANGLE = Math.cos(2.3999632297286535);
    public double originX;
    public double originY;
    public double radiusStepSize;
    public double normX;
    public double normY;
    public double x;
    public double y;
    public double radius;
    public int index;

    public GoldenSpiralIterator(double originX, double originY, double radiusStepSize, double startAngle) {
        this.originX = originX;
        this.originY = originY;
        this.radiusStepSize = radiusStepSize;
        this.normX = Math.cos(startAngle);
        this.normY = Math.sin(startAngle);
        this.x = originX;
        this.y = originY;
    }

    public GoldenSpiralIterator(double originX, double originY, double radiusStepSize, RandomGenerator randomStartAngle) {
        this(originX, originY, radiusStepSize, randomStartAngle.nextDouble() * (Math.PI * 2));
    }

    public GoldenSpiralIterator(double originX, double originY, double radiusStepSize, long randomStartAngleSeed) {
        this(originX, originY, radiusStepSize, Permuter.nextPositiveDouble(randomStartAngleSeed) * (Math.PI * 2));
    }

    @Override
    public void next() {
        double normX = this.normX;
        double normZ = this.normY;
        this.normX = normX * COS_GOLDEN_ANGLE + normZ * -SIN_GOLDEN_ANGLE;
        this.normY = normX * SIN_GOLDEN_ANGLE + normZ * COS_GOLDEN_ANGLE;
        ++this.index;
        this.radius = (double)this.index * this.radiusStepSize;
        this.x = this.originX + this.normX * this.radius;
        this.y = this.originY + this.normY * this.radius;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }
}

