/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise;

import builderb0y.bigglobe.noise.MojangPermuter;
import builderb0y.scripting.bytecode.CastingSupport;
import java.util.List;
import java.util.UUID;
import java.util.random.RandomGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_2265;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Range;

public class Permuter
implements RandomGenerator {
    public static final long PHI64 = -7046029254386353131L;
    public long seed;

    public Permuter(long seed) {
        this.seed = seed;
    }

    public static Permuter from(class_5819 random) {
        Permuter permuter;
        if (random instanceof MojangPermuter) {
            MojangPermuter mojangPermuter = (MojangPermuter)random;
            permuter = mojangPermuter.permuter;
        } else {
            permuter = new Permuter(random.method_43055());
        }
        return permuter;
    }

    public static Permuter from(RandomGenerator random) {
        Permuter permuter;
        return random instanceof Permuter ? (permuter = (Permuter)random) : new Permuter(random.nextLong());
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public Permuter withSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public MojangPermuter mojang() {
        return new MojangPermuter(this);
    }

    @Override
    public int nextInt() {
        return (int)Permuter.stafford(this.seed += -7046029254386353131L);
    }

    @Override
    public long nextLong() {
        return Permuter.stafford(this.seed += -7046029254386353131L);
    }

    @Override
    public float nextFloat() {
        return Permuter.toPositiveFloat(this.nextLong());
    }

    @Override
    public double nextDouble() {
        return Permuter.toPositiveDouble(this.nextLong());
    }

    public int nextIntBits(@Range(from=0L, to=32L) int numberOfBits) {
        if (numberOfBits == 32) {
            return this.nextInt();
        }
        return this.nextInt() & (1 << numberOfBits) - 1;
    }

    public long nextLongBits(@Range(from=0L, to=64L) int numberOfBits) {
        if (numberOfBits == 64) {
            return this.nextLong();
        }
        return this.nextLong() & (1L << numberOfBits) - 1L;
    }

    public void skip(int distance) {
        this.seed += -7046029254386353131L * (long)distance;
    }

    public void skip(long distance) {
        this.seed += -7046029254386353131L * distance;
    }

    public static long stafford(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    @Deprecated
    public static long permute(long seed) {
        return seed;
    }

    public static long permute(long seed, int salt1) {
        return Permuter.stafford(seed + (long)salt1 * -7046029254386353131L);
    }

    public static long permute(long seed, int salt1, int salt2) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        return seed;
    }

    public static long permute(long seed, int salt1, int salt2, int salt3) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        seed = Permuter.permute(seed, salt3);
        return seed;
    }

    public static long permute(long seed, int salt1, int salt2, int salt3, int salt4) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        seed = Permuter.permute(seed, salt3);
        seed = Permuter.permute(seed, salt4);
        return seed;
    }

    public static long permute(long seed, int salt1, int salt2, int salt3, int salt4, int salt5) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        seed = Permuter.permute(seed, salt3);
        seed = Permuter.permute(seed, salt4);
        seed = Permuter.permute(seed, salt5);
        return seed;
    }

    public static long permute(long seed, int salt1, int salt2, int salt3, int salt4, int salt5, int salt6) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        seed = Permuter.permute(seed, salt3);
        seed = Permuter.permute(seed, salt4);
        seed = Permuter.permute(seed, salt5);
        seed = Permuter.permute(seed, salt6);
        return seed;
    }

    public static long permute(long seed, int salt1, int salt2, int salt3, int salt4, int salt5, int salt6, int salt7) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        seed = Permuter.permute(seed, salt3);
        seed = Permuter.permute(seed, salt4);
        seed = Permuter.permute(seed, salt5);
        seed = Permuter.permute(seed, salt6);
        seed = Permuter.permute(seed, salt7);
        return seed;
    }

    public static long permute(long seed, int salt1, int salt2, int salt3, int salt4, int salt5, int salt6, int salt7, int salt8) {
        seed = Permuter.permute(seed, salt1);
        seed = Permuter.permute(seed, salt2);
        seed = Permuter.permute(seed, salt3);
        seed = Permuter.permute(seed, salt4);
        seed = Permuter.permute(seed, salt5);
        seed = Permuter.permute(seed, salt6);
        seed = Permuter.permute(seed, salt7);
        seed = Permuter.permute(seed, salt8);
        return seed;
    }

    public static long permute(long seed, byte ... salts) {
        for (byte salt : salts) {
            seed = Permuter.permute(seed, (int)salt);
        }
        return seed;
    }

    public static long permute(long seed, short ... salts) {
        for (short salt : salts) {
            seed = Permuter.permute(seed, (int)salt);
        }
        return seed;
    }

    public static long permute(long seed, int ... salts) {
        for (int salt : salts) {
            seed = Permuter.permute(seed, salt);
        }
        return seed;
    }

    public static long permute(long seed, char ... salts) {
        for (char salt : salts) {
            seed = Permuter.permute(seed, (int)salt);
        }
        return seed;
    }

    public static long permute(long seed, CharSequence saltSequence) {
        int length = saltSequence.length();
        for (int index = 0; index < length; ++index) {
            seed = Permuter.permute(seed, (int)saltSequence.charAt(index));
        }
        return seed;
    }

    public static long permute(long seed, class_2960 identifier) {
        seed = Permuter.permute(seed, identifier.method_12836());
        seed = Permuter.permute(seed, 58);
        seed = Permuter.permute(seed, identifier.method_12832());
        return seed;
    }

    public static long permute(long seed, class_2382 vector) {
        return Permuter.permute(seed, vector.method_10263(), vector.method_10264(), vector.method_10260());
    }

    public static long permute(long seed, class_2265 pos) {
        return Permuter.permute(seed, pos.comp_638(), pos.comp_639());
    }

    public static long permute(long seed, class_1923 chunkPos) {
        return Permuter.permute(seed, chunkPos.field_9181, chunkPos.field_9180);
    }

    public static long permute(long seed, long salt1) {
        seed = Permuter.stafford(seed + salt1);
        return seed;
    }

    public static long permute(long seed, long salt1, long salt2) {
        seed = Permuter.stafford(seed + salt1);
        seed = Permuter.stafford(seed + salt2);
        return seed;
    }

    public static long permute(long seed, long salt1, long salt2, long salt3) {
        seed = Permuter.stafford(seed + salt1);
        seed = Permuter.stafford(seed + salt2);
        seed = Permuter.stafford(seed + salt3);
        return seed;
    }

    public static long permute(long seed, long salt1, long salt2, long salt3, long salt4) {
        seed = Permuter.stafford(seed + salt1);
        seed = Permuter.stafford(seed + salt2);
        seed = Permuter.stafford(seed + salt3);
        seed = Permuter.stafford(seed + salt4);
        return seed;
    }

    public static long permute(long seed, UUID uuid) {
        return Permuter.permute(seed, uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static long permute(long seed, double salt1) {
        return Permuter.permute(seed, Double.doubleToRawLongBits(salt1));
    }

    public static long permute(long seed, double salt1, double salt2) {
        return Permuter.permute(seed, Double.doubleToRawLongBits(salt1), Double.doubleToRawLongBits(salt2));
    }

    public static long permute(long seed, double salt1, double salt2, double salt3) {
        return Permuter.permute(seed, Double.doubleToRawLongBits(salt1), Double.doubleToRawLongBits(salt2), Double.doubleToRawLongBits(salt3));
    }

    public static long permute(long seed, double salt1, double salt2, double salt3, double salt4) {
        return Permuter.permute(seed, Double.doubleToRawLongBits(salt1), Double.doubleToRawLongBits(salt2), Double.doubleToRawLongBits(salt3), Double.doubleToRawLongBits(salt4));
    }

    public static int nextUniformInt(long seed) {
        return (int)Permuter.stafford(seed);
    }

    public static int toUniformInt(long permutedSeed) {
        return (int)permutedSeed;
    }

    public static int nextPositiveInt(long seed) {
        return Permuter.nextUniformInt(seed) & Integer.MAX_VALUE;
    }

    public static int toPositiveInt(long permutedSeed) {
        return (int)permutedSeed & Integer.MAX_VALUE;
    }

    public static int nextBoundedInt(long seed, int max) {
        int result;
        int bits;
        if (max <= 0) {
            throw new IllegalArgumentException("bound must be positive.");
        }
        int mask = max - 1;
        if ((max & mask) == 0) {
            return Permuter.nextUniformInt(seed) & mask;
        }
        while ((bits = Permuter.nextPositiveInt(seed += -7046029254386353131L)) - (result = bits % max) + mask < 0) {
        }
        return result;
    }

    public static int nextBoundedInt(long seed, int min, int max) {
        return Permuter.nextBoundedInt(seed, max - min) + min;
    }

    public static long nextUniformLong(long seed) {
        return Permuter.stafford(seed);
    }

    public static long toUniformLong(long seed) {
        return seed;
    }

    public static long nextPositiveLong(long seed) {
        return Permuter.nextUniformLong(seed) & Long.MAX_VALUE;
    }

    public static long toPositiveLong(long seed) {
        return seed & Long.MAX_VALUE;
    }

    public static long nextBoundedLong(long seed, long max) {
        long result;
        long bits;
        if (max <= 0L) {
            throw new IllegalArgumentException("bound must be positive.");
        }
        if (max <= Integer.MAX_VALUE) {
            return Permuter.nextBoundedInt(seed, (int)max);
        }
        long mask = max - 1L;
        if ((max & mask) == 0L) {
            return Permuter.nextUniformLong(seed) & mask;
        }
        while ((bits = Permuter.nextPositiveLong(seed += -7046029254386353131L)) - (result = bits % max) + mask < 0L) {
        }
        return result;
    }

    public static long nextBoundedLong(long seed, long min, long max) {
        return Permuter.nextBoundedLong(seed, max - min) + min;
    }

    public static float nextPositiveFloat(long seed) {
        return (float)(Permuter.nextUniformLong(seed) >>> 40) * 5.9604645E-8f;
    }

    public static float toPositiveFloat(long permutedSeed) {
        return (float)(permutedSeed >>> 40) * 5.9604645E-8f;
    }

    public static float nextUniformFloat(long seed) {
        return (float)(Permuter.nextUniformLong(seed) >> 39) * 5.9604645E-8f;
    }

    public static float toUniformFloat(long permutedSeed) {
        return (float)(permutedSeed >> 39) * 5.9604645E-8f;
    }

    public static float nextUniformFloat(RandomGenerator random) {
        return (float)(random.nextLong() >> 39) * 5.9604645E-8f;
    }

    public static float nextBoundedFloat(long seed, float max) {
        if (!(max > 0.0f) || !(max < Float.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be positive and finite.");
        }
        return Permuter.nextPositiveFloat(seed) * max;
    }

    public static float toBoundedFloat(long seed, float max) {
        if (!(max > 0.0f) || !(max < Float.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be positive and finite.");
        }
        return Permuter.toPositiveFloat(seed) * max;
    }

    public static float nextBoundedFloat(long seed, float min, float max) {
        return Permuter.nextBoundedFloat(seed, max - min) + min;
    }

    public static float toBoundedFloat(long seed, float min, float max) {
        return Permuter.toBoundedFloat(seed, max - min) + min;
    }

    public static double nextPositiveDouble(long seed) {
        return (double)(Permuter.nextUniformLong(seed) >>> 11) * (double)1.110223E-16f;
    }

    public static double toPositiveDouble(long permutedSeed) {
        return (double)(permutedSeed >>> 11) * (double)1.110223E-16f;
    }

    public static double nextUniformDouble(long seed) {
        return (double)(Permuter.nextUniformLong(seed) >> 10) * (double)1.110223E-16f;
    }

    public static double toUniformDouble(long permutedSeed) {
        return (double)(permutedSeed >> 10) * (double)1.110223E-16f;
    }

    public static double nextUniformDouble(RandomGenerator random) {
        return (double)(random.nextLong() >> 10) * (double)1.110223E-16f;
    }

    public static double nextBoundedDouble(long seed, double max) {
        if (!(max > 0.0) || !(max < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be positive and finite.");
        }
        return Permuter.nextPositiveDouble(seed) * max;
    }

    public static double toBoundedDouble(long seed, double max) {
        if (!(max > 0.0) || !(max < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be positive and finite.");
        }
        return Permuter.toPositiveDouble(seed) * max;
    }

    public static double nextBoundedDouble(long seed, double min, double max) {
        return Permuter.nextBoundedDouble(seed, max - min) + min;
    }

    public static double toBoundedDouble(long seed, double min, double max) {
        return Permuter.toBoundedDouble(seed, max - min) + min;
    }

    public static boolean nextBoolean(long seed) {
        return Permuter.nextUniformInt(seed) < 0;
    }

    public static boolean toBoolean(long permutedSeed) {
        return Permuter.toUniformInt(permutedSeed) < 0;
    }

    public static boolean nextChancedBoolean(long seed, float chance) {
        return chance > 0.0f && (chance >= 1.0f || Permuter.nextPositiveFloat(seed) < chance);
    }

    public static boolean toChancedBoolean(long permutedSeed, float chance) {
        return chance > 0.0f && (chance >= 1.0f || Permuter.toPositiveFloat(permutedSeed) < chance);
    }

    public static boolean nextChancedBoolean(RandomGenerator random, float chance) {
        return chance > 0.0f && (chance >= 1.0f || random.nextFloat() < chance);
    }

    public static boolean nextChancedBoolean(long seed, double chance) {
        return chance > 0.0 && (chance >= 1.0 || Permuter.nextPositiveDouble(seed) < chance);
    }

    public static boolean toChancedBoolean(long permutedSeed, double chance) {
        return chance > 0.0 && (chance >= 1.0 || Permuter.toPositiveDouble(permutedSeed) < chance);
    }

    public static boolean nextChancedBoolean(RandomGenerator random, double chance) {
        return chance > 0.0 && (chance >= 1.0 || random.nextDouble() < chance);
    }

    public static int roundRandomlyI(long seed, float number) {
        return CastingSupport.floorInt(number + Permuter.nextPositiveFloat(seed));
    }

    public static int roundRandomlyI(RandomGenerator random, float number) {
        return CastingSupport.floorInt(number + random.nextFloat());
    }

    public static int roundRandomlyI(long seed, double number) {
        return CastingSupport.floorInt(number + Permuter.nextPositiveDouble(seed));
    }

    public static int roundRandomlyI(RandomGenerator random, double number) {
        return CastingSupport.floorInt(number + random.nextDouble());
    }

    public static long roundRandomlyL(long seed, float number) {
        return CastingSupport.floorLong(number + Permuter.nextPositiveFloat(seed));
    }

    public static long roundRandomlyL(RandomGenerator random, float number) {
        return CastingSupport.floorLong(number + random.nextFloat());
    }

    public static long roundRandomlyL(long seed, double number) {
        return CastingSupport.floorLong(number + Permuter.nextPositiveDouble(seed));
    }

    public static long roundRandomlyL(RandomGenerator random, double number) {
        return CastingSupport.floorLong(number + random.nextDouble());
    }

    public static <T> T choose(long seed, T[] values) {
        return values[Permuter.nextBoundedInt(seed, values.length)];
    }

    public static <T> T choose(RandomGenerator random, T[] values) {
        return values[random.nextInt(values.length)];
    }

    public static <T> T choose(long seed, List<T> values) {
        return values.get(Permuter.nextBoundedInt(seed, values.size()));
    }

    public static <T> T choose(RandomGenerator random, List<T> values) {
        return values.get(random.nextInt(values.size()));
    }
}

