/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.perlin;

import builderb0y.autocodec.annotations.Alias;
import builderb0y.autocodec.annotations.VerifyIntRange;
import builderb0y.bigglobe.noise.Grid3D;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.settings.Seed;

public abstract class PerlinBaseGrid3D
implements Grid3D {
    public static final long SLOPE_X_SALT = Permuter.permute(0L, 120);
    public static final long SLOPE_Y_SALT = Permuter.permute(0L, 121);
    public static final long SLOPE_Z_SALT = Permuter.permute(0L, 122);
    public final Seed salt;
    public final @VerifyIntRange(min=0L, minInclusive=false) @Alias(value={"scale"}) int scaleX;
    public final @VerifyIntRange(min=0L, minInclusive=false) @Alias(value={"scale"}) int scaleY;
    public final @VerifyIntRange(min=0L, minInclusive=false) @Alias(value={"scale"}) int scaleZ;
    public final transient double rcpX;
    public final transient double rcpY;
    public final transient double rcpZ;
    public final double max_slope;
    public final double max_offset;

    public PerlinBaseGrid3D(Seed salt, int scaleX, int scaleY, int scaleZ, double max_slope, double max_offset) {
        this.salt = salt;
        this.scaleX = scaleX;
        this.rcpX = 1.0 / (double)this.scaleX;
        this.scaleY = scaleY;
        this.rcpY = 1.0 / (double)this.scaleY;
        this.scaleZ = scaleZ;
        this.rcpZ = 1.0 / (double)this.scaleZ;
        this.max_slope = max_slope;
        this.max_offset = max_offset;
    }

    public double slopeX(long seed, int x, int y, int z) {
        return Permuter.toUniformDouble(Permuter.permute(seed ^ SLOPE_X_SALT, x, y, z)) * this.max_slope;
    }

    public double slopeY(long seed, int x, int y, int z) {
        return Permuter.toUniformDouble(Permuter.permute(seed ^ SLOPE_Y_SALT, x, y, z)) * this.max_slope;
    }

    public double slopeZ(long seed, int x, int y, int z) {
        return Permuter.toUniformDouble(Permuter.permute(seed ^ SLOPE_Z_SALT, x, y, z)) * this.max_slope;
    }

    public double offset(long seed, int x, int y, int z) {
        return Permuter.toUniformDouble(Permuter.permute(seed, x, y, z)) * this.max_offset;
    }
}

