/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.polynomials;

import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.polynomials.Polynomial;
import builderb0y.bigglobe.noise.polynomials.Polynomial4;

public class CubicDerivativePolynomial
extends Polynomial4 {
    public static final Form FORM = new Form();
    public double term0;
    public double term1;
    public double term2;

    public CubicDerivativePolynomial(double value0, double value1, double value2, double value3, double rcp) {
        super(value0, value1, value2, value3, rcp);
    }

    @Override
    public void update(double value0, double value1, double value2, double value3, double rcp) {
        this.term0 = rcp * (4.5 * (value1 - value2) + 1.5 * (value3 - value0));
        this.term1 = rcp * (2.0 * value0 - 5.0 * value1 + 4.0 * value2 - value3);
        this.term2 = rcp * (0.5 * (value2 - value0));
    }

    @Override
    public double interpolate(double fraction) {
        return (fraction * this.term0 + this.term1) * fraction + this.term2;
    }

    @Override
    public Polynomial.PolyForm form() {
        return FORM;
    }

    public static class Form
    extends Polynomial4.PolyForm4 {
        @Override
        public double calcMinValue(double min, double max, double rcp) {
            return (min - max) * rcp * 1.5;
        }

        @Override
        public double calcMaxValue(double min, double max, double rcp) {
            return (max - min) * rcp * 1.5;
        }

        @Override
        public Polynomial createPolynomial(double value0, double value1, double value2, double value3, double rcp) {
            return new CubicDerivativePolynomial(value0, value1, value2, value3, rcp);
        }

        @Override
        public double interpolate(double value0, double value1, double value2, double value3, double rcp, double fraction) {
            return Interpolator.cubicDerivative(value0, value1, value2, value3, fraction) * rcp;
        }
    }
}

