/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.autocodec.annotations.VerifyFloatRange;
import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.settings.Seed;

public abstract class AbstractGrid
implements Grid {
    public final Seed salt;
    public final @VerifyFloatRange(min=0.0, minInclusive=false) double amplitude;

    public AbstractGrid(Seed salt, double amplitude) {
        this.salt = salt;
        this.amplitude = amplitude;
    }

    @Override
    public double minValue() {
        return -this.amplitude;
    }

    @Override
    public double maxValue() {
        return this.amplitude;
    }

    public void scale(NumberArray samples) {
        double amplitude = this.amplitude;
        int length = samples.length();
        for (int index = 0; index < length; ++index) {
            samples.mul(index, amplitude);
        }
    }
}

