/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomLists;

import builderb0y.autocodec.annotations.EncodeInline;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.coders.PrimitiveCoders;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.AutoEncoder;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.ConstantWeightRandomList;
import builderb0y.bigglobe.randomLists.EmptyRandomList;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.randomLists.SingletonRandomList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.ToDoubleFunction;
import java.util.random.RandomGenerator;
import java.util.stream.IntStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UseCoder(name="new", in=IRandomListCoder.class, usage=MemberUsage.METHOD_IS_FACTORY, strict=false)
public interface IRandomList<E>
extends List<E> {
    public static final double DEFAULT_WEIGHT = 1.0;

    public double getWeight(int var1);

    public double setWeight(int var1, double var2);

    public boolean add(E var1, double var2);

    public void add(int var1, E var2, double var3);

    public E set(int var1, E var2, double var3);

    default public void replaceAllWeights(ToDoubleFunction<? super E> operator) {
        Objects.requireNonNull(operator, "operator");
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext()) {
            iterator.setWeight(operator.applyAsDouble(iterator.next()));
        }
    }

    default public int getRandomIndex(RandomGenerator random) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int choice = this.size() - 1;
        double totalWeight = 0.0;
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            double weight = iterator.getWeight();
            if (weight > 0.0) {
                double d;
                totalWeight += weight;
                if (random.nextDouble() * d < weight) {
                    choice = index;
                }
            }
            ++index;
        }
        if (!(totalWeight > 0.0)) {
            choice = -1;
        }
        return choice;
    }

    default public E getRandomElement(RandomGenerator random) {
        int index = this.getRandomIndex(random);
        return index >= 0 ? (E)this.get(index) : null;
    }

    default public int getRandomIndex(long seed) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int choice = this.size() - 1;
        double totalWeight = 0.0;
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            double weight = iterator.getWeight();
            if (weight > 0.0) {
                double d;
                long l;
                seed += -7046029254386353131L;
                totalWeight += weight;
                if (Permuter.nextPositiveDouble(l) * d < weight) {
                    choice = index;
                }
            }
            ++index;
        }
        if (!(totalWeight > 0.0)) {
            choice = -1;
        }
        return choice;
    }

    default public E getRandomElement(long seed) {
        int index = this.getRandomIndex(seed);
        return index >= 0 ? (E)this.get(index) : null;
    }

    @Override
    public WeightedIterator<E> iterator();

    @Override
    public WeightedListIterator<E> listIterator();

    @Override
    public WeightedListIterator<E> listIterator(int var1);

    @Override
    public IRandomList<E> subList(int var1, int var2);

    default public IRandomList<E> optimize() {
        return switch (this.size()) {
            case 0 -> EmptyRandomList.instance();
            case 1 -> new SingletonRandomList(this.get(0), this.getWeight(0));
            default -> {
                if (this instanceof RandomAccess) {
                    double weight = this.getWeight(0);
                    int size = this.size();
                    for (int index = 1; index < size; ++index) {
                        if (this.getWeight(index) == weight) continue;
                        yield this;
                    }
                    yield new ConstantWeightRandomList.RandomAccessConstantWeightRandomList(this, weight);
                }
                Iterator iterator = this.iterator();
                iterator.next();
                double weight = iterator.getWeight();
                while (iterator.hasNext()) {
                    iterator.next();
                    if (iterator.getWeight() == weight) continue;
                    yield this;
                }
                yield new ConstantWeightRandomList.RandomAccessConstantWeightRandomList(new ArrayList(this), weight);
            }
        };
    }

    public static <E> IRandomList<E> optimizeSizeNullable(IRandomList<E> list) {
        return list != null ? list.optimize() : EmptyRandomList.instance();
    }

    default public String defaultToString() {
        int size = this.size();
        if (size == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(size << 6);
        Iterator iterator = this.iterator();
        builder.append("[ ").append(iterator.next()).append(" * ").append(iterator.getWeight());
        while (iterator.hasNext()) {
            builder.append(", ").append(iterator.next()).append(" * ").append(iterator.getWeight());
        }
        return builder.append(" ]").toString();
    }

    default public boolean defaultEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IRandomList)) {
            return false;
        }
        IRandomList that = (IRandomList)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator thisIterator = this.iterator();
        if (that instanceof RandomAccess) {
            int size = that.size();
            for (int index = 0; index < size; ++index) {
                if (!thisIterator.hasNext()) {
                    return false;
                }
                if (!Objects.equals(thisIterator.next(), that.get(index))) {
                    return false;
                }
                if (Double.doubleToLongBits(thisIterator.getWeight()) == Double.doubleToLongBits(that.getWeight(index))) continue;
                return false;
            }
            return !thisIterator.hasNext();
        }
        Iterator thatIterator = that.iterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            if (!Objects.equals(thisIterator.next(), thatIterator.next())) {
                return false;
            }
            if (Double.doubleToLongBits(thisIterator.getWeight()) == Double.doubleToLongBits(thatIterator.getWeight())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !thatIterator.hasNext();
    }

    default public int defaultHashCode() {
        int hash = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            hash = hash * 31 + Objects.hashCode(iterator.next());
            hash = hash * 31 + Double.hashCode(iterator.getWeight());
        }
        return hash;
    }

    public static interface WeightedListIterator<E>
    extends WeightedIterator<E>,
    ListIterator<E> {
        public void setWeight(double var1);
    }

    public static interface WeightedIterator<E>
    extends Iterator<E> {
        public double getWeight();
    }

    public static class IRandomListCoder<T>
    extends AutoCoder.NamedCoder<IRandomList<T>> {
        @NotNull
        public final AutoCoder<T> elementCoder;
        @NotNull
        public final AutoCoder<Double> weightCoder;
        @Nullable
        public final String elementName;

        public IRandomListCoder(@NotNull ReifiedType<IRandomList<T>> handledType, @NotNull AutoCoder<T> elementCoder, @NotNull AutoCoder<Double> weightCoder, @Nullable String elementName) {
            super(handledType);
            this.elementCoder = elementCoder;
            this.weightCoder = weightCoder;
            this.elementName = elementName;
        }

        public IRandomListCoder(FactoryContext<IRandomList<T>> context) {
            super(context.type);
            ReifiedType elementType = context.type.resolveParameter(IRandomList.class).uncheckedCast();
            this.elementCoder = context.type(elementType).forceCreateCoder();
            this.elementName = IRandomListCoder.elementName(elementType);
            this.weightCoder = context.type((ReifiedType)new ReifiedType<Double>(this){}).forceCreateCoder();
        }

        @Nullable
        public static String elementName(ReifiedType<?> elementType) {
            UseName useName = (UseName)elementType.getAnnotations().getFirst(UseName.class);
            if (useName != null) {
                return useName.value();
            }
            if (elementType.getAnnotations().has(EncodeInline.class)) {
                return null;
            }
            return "element";
        }

        public <T_Encoded> T element(DecodeContext<T_Encoded> context) throws DecodeException {
            return (T)(this.elementName != null && context.isMap() ? (DecodeContext)context.forceGetMember(this.elementName) : context).decodeWith(this.elementCoder);
        }

        public <T_Encoded> double weight(DecodeContext<T_Encoded> context) throws DecodeException {
            return context.isMap() ? (Double)((DecodeContext)context.forceGetMember("weight")).decodeWith(this.weightCoder) : 1.0;
        }

        @ApiStatus.OverrideOnly
        @Nullable
        public <T_Encoded> IRandomList<T> decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            if (context.isEmpty()) {
                return null;
            }
            if (context.isList()) {
                int size = context.forceAsList().size();
                return switch (size) {
                    case 0 -> EmptyRandomList.instance();
                    case 1 -> {
                        DecodeContext entry = (DecodeContext)context.forceGetElement(0);
                        yield new SingletonRandomList<T>(this.element(entry), this.weight(entry));
                    }
                    default -> {
                        RandomList<T> result = new RandomList<T>(size);
                        for (DecodeContext entry : context.listIterable()) {
                            result.add(this.element(entry), this.weight(entry));
                        }
                        yield result.optimize();
                    }
                };
            }
            return new SingletonRandomList<Object>(context.decodeWith(this.elementCoder), 1.0);
        }

        @ApiStatus.OverrideOnly
        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, IRandomList<T>> context) throws EncodeException {
            IRandomList list = (IRandomList)context.object;
            if (list == null) {
                return EmptyData.INSTANCE;
            }
            if (list.isEmpty()) {
                return new ListData();
            }
            return ListData.collect(IntStream.range(0, list.size()).mapToObj(index -> {
                Data encodedElement = context.object(list.get(index)).encodeWith(this.elementCoder);
                Data encodedWeight = context.object((Object)list.getWeight(index)).encodeWith((AutoEncoder)PrimitiveCoders.DOUBLE);
                if (this.elementName != null) {
                    MapData map = new MapData(4);
                    map.put(this.elementName, encodedElement);
                    map.put("weight", encodedWeight);
                    return map;
                }
                MapData map = encodedElement.tryAsMap();
                if (map == null) {
                    throw new EncodeException(() -> String.valueOf(list.get(index)) + " encoded into non-map: " + String.valueOf(encodedElement));
                }
                map.put("weight", encodedWeight);
                return map;
            }));
        }
    }

    public static interface RandomAccessKnownTotalWeightRandomList<E>
    extends KnownTotalWeightRandomList<E>,
    RandomAccessRandomList<E> {
        @Override
        default public int getRandomIndex(RandomGenerator random) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double targetWeight = this.getTotalWeight();
            if (targetWeight > 0.0) {
                targetWeight *= random.nextDouble();
                int size = this.size();
                for (int index = 0; index < size; ++index) {
                    double d;
                    double weight = this.getWeight(index);
                    if (!(weight > 0.0)) continue;
                    targetWeight -= weight;
                    if (!(d <= 0.0)) continue;
                    return index;
                }
                return this.size() - 1;
            }
            return -1;
        }

        @Override
        default public int getRandomIndex(long seed) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double targetWeight = this.getTotalWeight();
            if (targetWeight > 0.0) {
                targetWeight *= Permuter.nextPositiveDouble(seed);
                int size = this.size();
                for (int index = 0; index < size; ++index) {
                    double d;
                    double weight = this.getWeight(index);
                    if (!(weight > 0.0)) continue;
                    targetWeight -= weight;
                    if (!(d <= 0.0)) continue;
                    return index;
                }
                return this.size() - 1;
            }
            return -1;
        }

        @Override
        default public String defaultToString() {
            return RandomAccessRandomList.super.defaultToString() + " (total weight: " + this.getTotalWeight() + ")";
        }
    }

    public static interface KnownTotalWeightRandomList<E>
    extends IRandomList<E> {
        public double getTotalWeight();

        default public boolean isWeightless() {
            return !(this.getTotalWeight() > 0.0);
        }

        default public boolean isEmptyOrWeightless() {
            return this.isEmpty() || this.isWeightless();
        }

        @Override
        default public int getRandomIndex(RandomGenerator random) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double targetWeight = this.getTotalWeight();
            if (targetWeight > 0.0) {
                targetWeight *= random.nextDouble();
                int index = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    double weight = iterator.getWeight();
                    if (weight > 0.0) {
                        double d;
                        targetWeight -= weight;
                        if (d <= 0.0) {
                            return index;
                        }
                    }
                    ++index;
                }
                return this.size() - 1;
            }
            return -1;
        }

        @Override
        default public int getRandomIndex(long seed) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double targetWeight = this.getTotalWeight();
            if (targetWeight > 0.0) {
                targetWeight *= Permuter.nextPositiveDouble(seed);
                int index = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    double weight = iterator.getWeight();
                    if (weight > 0.0) {
                        double d;
                        targetWeight -= weight;
                        if (d <= 0.0) {
                            return index;
                        }
                    }
                    ++index;
                }
                return this.size() - 1;
            }
            return -1;
        }

        @Override
        default public String defaultToString() {
            return IRandomList.super.defaultToString() + " (total weight: " + this.getTotalWeight() + ")";
        }
    }

    public static interface RandomAccessRandomList<E>
    extends IRandomList<E>,
    RandomAccess {
        @Override
        default public void replaceAllWeights(ToDoubleFunction<? super E> operator) {
            Objects.requireNonNull(operator, "operator");
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                this.setWeight(index, operator.applyAsDouble(this.get(index)));
            }
        }

        @Override
        default public int getRandomIndex(RandomGenerator random) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int choice = this.size() - 1;
            double totalWeight = 0.0;
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                double d;
                double weight = this.getWeight(index);
                if (!(weight > 0.0)) continue;
                totalWeight += weight;
                if (!(random.nextDouble() * d < weight)) continue;
                choice = index;
            }
            if (!(totalWeight > 0.0)) {
                choice = -1;
            }
            return choice;
        }

        @Override
        default public int getRandomIndex(long seed) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int choice = this.size() - 1;
            double totalWeight = 0.0;
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                double d;
                long l;
                double weight = this.getWeight(index);
                if (!(weight > 0.0)) continue;
                seed += -7046029254386353131L;
                totalWeight += weight;
                if (!(Permuter.nextPositiveDouble(l) * d < weight)) continue;
                choice = index;
            }
            if (!(totalWeight > 0.0)) {
                choice = -1;
            }
            return choice;
        }

        @Override
        default public String defaultToString() {
            int size = this.size();
            if (size == 0) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder(size << 6);
            builder.append("[ ").append(this.get(0)).append(" * ").append(this.getWeight(0));
            for (int index = 1; index < size; ++index) {
                builder.append(", ").append(this.get(index)).append(" * ").append(this.getWeight(index));
            }
            return builder.append(" ]").toString();
        }

        @Override
        default public boolean defaultEquals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IRandomList)) {
                return false;
            }
            IRandomList that = (IRandomList)o;
            if (this.size() != that.size()) {
                return false;
            }
            if (that instanceof RandomAccess) {
                int size = this.size();
                for (int index = 0; index < size; ++index) {
                    if (!Objects.equals(this.get(index), that.get(index))) {
                        return false;
                    }
                    if (Double.doubleToLongBits(this.getWeight(index)) == Double.doubleToLongBits(that.getWeight(index))) continue;
                    return false;
                }
                return true;
            }
            Iterator thatIterator = that.iterator();
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                if (!thatIterator.hasNext()) {
                    return false;
                }
                if (!Objects.equals(this.get(index), thatIterator.next())) {
                    return false;
                }
                if (Double.doubleToLongBits(this.getWeight(index)) == Double.doubleToLongBits(thatIterator.getWeight())) continue;
                return false;
            }
            return !thatIterator.hasNext();
        }

        @Override
        default public int defaultHashCode() {
            int hash = 1;
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                hash = hash * 31 + Objects.hashCode(this.get(index));
                hash = hash * 31 + Double.hashCode(this.getWeight(index));
            }
            return hash;
        }
    }
}

