/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomSources;

import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.annotations.VerifyIntRange;
import builderb0y.autocodec.annotations.VerifySorted;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomSources.RandomSource;
import java.util.random.RandomGenerator;

public record GaussianRandomSource(@UseName(value="min") double minValue, @UseName(value="max") @VerifySorted(greaterThan={"minValue"}) double maxValue, @VerifyIntRange(min=0L, minInclusive=false) int samples) implements RandomSource
{
    @Override
    public double get(ScriptedColumn column, int y, long seed) {
        double sum = 0.0;
        int loop = this.samples;
        while (--loop >= 0) {
            sum += Permuter.nextPositiveDouble(seed += -7046029254386353131L);
        }
        return this.mix(sum / (double)this.samples);
    }

    @Override
    public double get(ScriptedColumn column, int y, RandomGenerator random) {
        double sum = 0.0;
        int loop = this.samples;
        while (--loop >= 0) {
            sum += random.nextDouble();
        }
        return this.mix(sum / (double)this.samples);
    }
}

