/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering;

import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32C;

public class GLException
extends RuntimeException {
    public GLException(String message) {
        super(message);
    }

    public static void check() {
        int error = GL32C.glGetError();
        if (error != 0) {
            throw new GLException(GLException.message(error));
        }
    }

    @Nullable
    public static String checkMessage() {
        int error = GL32C.glGetError();
        return error != 0 ? GLException.message(error) : null;
    }

    public static String message(int code) {
        return switch (code) {
            case 1280 -> "GL_INVALID_ENUM";
            case 1281 -> "GL_INVALID_VALUE";
            case 1282 -> "GL_INVALID_OPERATION";
            case 1283 -> "GL_STACK_OVERFLOW";
            case 1284 -> "GL_STACK_UNDERFLOW";
            case 1285 -> "GL_OUT_OF_MEMORY";
            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
            default -> "unknown error: 0x" + Integer.toHexString(code);
        };
    }

    public static void checkFramebuffer(int bindPoint) {
        int status = GL32C.glCheckFramebufferStatus((int)bindPoint);
        if (status != 36053) {
            if (status == 0) {
                GLException.check();
            }
            throw new GLException(GLException.framebufferMessage(status));
        }
    }

    @Nullable
    public static String checkFramebufferMessage(int bindPoint) {
        int code = GL32C.glCheckFramebufferStatus((int)bindPoint);
        return code != 36053 ? GLException.framebufferMessage(code) : null;
    }

    public static String framebufferMessage(int code) {
        return switch (code) {
            case 36054 -> "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
            case 36055 -> "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
            case 36059 -> "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
            case 36060 -> "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
            case 36182 -> "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
            case 36264 -> "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
            case 36061 -> "GL_FRAMEBUFFER_UNSUPPORTED";
            case 33305 -> "GL_FRAMEBUFFER_UNDEFINED";
            default -> "unknown framebuffer error: 0x" + Integer.toHexString(code);
        };
    }
}

