/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.versions.RenderVersions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class Matrices {
    public static double cameraX;
    public static double cameraY;
    public static double cameraZ;
    public static Matrix4f modelView;
    public static Matrix4f modelViewInverse;
    public static Matrix4f projection;
    public static Matrix4f projectionInverse;
    public static float dayTimeInSeconds;

    public static void init() {
        WorldRenderEvents.START.register(Matrices::update);
    }

    public static void update(WorldRenderContext context) {
        class_243 cameraPos = context.camera().method_19326();
        cameraX = cameraPos.field_1352;
        cameraY = cameraPos.field_1351;
        cameraZ = cameraPos.field_1350;
        modelView.set(RenderVersions.modelViewMatrix(context)).invert(modelViewInverse);
        projection.set(RenderVersions.projectionMatrix(context)).invert(projectionInverse);
        dayTimeInSeconds = ((float)BigGlobeMath.modulus_BP(context.world().method_8510(), 24000L) + RenderVersions.partialTicks(context)) / 20.0f;
    }

    static {
        modelView = new Matrix4f();
        modelViewInverse = new Matrix4f();
        projection = new Matrix4f();
        projectionInverse = new Matrix4f();
    }
}

