/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.rendering.lods.CompactVertexFormatElement;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CompactVertexFormat {
    public static final int FLAG_POSITION = 1;
    public static final int FLAG_COLOR = 2;
    public static final int FLAG_TEXTURE = 4;
    public static final int FLAG_OVERLAY = 8;
    public static final int FLAG_LIGHTMAP = 16;
    public static final int FLAG_NORMAL = 32;
    @Nullable
    public final CompactVertexFormatElement position;
    @Nullable
    public final CompactVertexFormatElement color;
    @Nullable
    public final CompactVertexFormatElement texture;
    @Nullable
    public final CompactVertexFormatElement overlay;
    @Nullable
    public final CompactVertexFormatElement lightmap;
    @Nullable
    public final CompactVertexFormatElement normal;
    public final int byteStride;
    public final int flags;

    public CompactVertexFormat(Builder builder) {
        this.position = builder.position;
        this.color = builder.color;
        this.texture = builder.texture;
        this.overlay = builder.overlay;
        this.lightmap = builder.lightmap;
        this.normal = builder.normal;
        this.byteStride = builder.byteStride;
        if (this.byteStride < 0) {
            throw new IllegalStateException("Missing stride");
        }
        int flags = 0;
        if (this.position != null) {
            flags |= 1;
        }
        if (this.color != null) {
            flags |= 2;
        }
        if (this.texture != null) {
            flags |= 4;
        }
        if (this.overlay != null) {
            flags |= 8;
        }
        if (this.lightmap != null) {
            flags |= 0x10;
        }
        if (this.normal != null) {
            flags |= 0x20;
        }
        this.flags = flags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void putPosition(long pointer, float x, float y, float z) {
        if (this.position != null) {
            this.position.put3f(pointer, x, y, z);
        }
    }

    public void putPosition(long pointer, int x, int y, int z) {
        if (this.position != null) {
            this.position.put3i(pointer, x, y, z);
        }
    }

    public void putColor(long pointer, float red, float green, float blue, float alpha) {
        if (this.color != null) {
            this.color.put4f(pointer, red, green, blue, alpha);
        }
    }

    public void putColor(long pointer, int red, int green, int blue, int alpha) {
        if (this.color != null) {
            this.color.put4i(pointer, red, green, blue, alpha);
        }
    }

    public void putTexture(long pointer, float u, float v) {
        if (this.texture != null) {
            this.texture.put2f(pointer, u, v);
        }
    }

    public void putTexture(long pointer, int u, int v) {
        if (this.texture != null) {
            this.texture.put2i(pointer, u, v);
        }
    }

    public void putOverlay(long pointer, float u, float v) {
        if (this.overlay != null) {
            this.overlay.put2f(pointer, u, v);
        }
    }

    public void putOverlay(long pointer, int u, int v) {
        if (this.overlay != null) {
            this.overlay.put2f(pointer, u, v);
        }
    }

    public void putLightmap(long pointer, float blocklight, float skylight) {
        if (this.lightmap != null) {
            this.lightmap.put2f(pointer, blocklight, skylight);
        }
    }

    public void putLightmap(long pointer, int blocklight, int skylight) {
        if (this.lightmap != null) {
            this.lightmap.put2i(pointer, blocklight, skylight);
        }
    }

    public void putNormal(long pointer, float x, float y, float z) {
        if (this.normal != null) {
            this.normal.put3f(pointer, x, y, z);
        }
    }

    public void putNormal(long pointer, int x, int y, int z) {
        if (this.normal != null) {
            this.normal.put3i(pointer, x, y, z);
        }
    }

    public static class Builder {
        @Nullable
        public CompactVertexFormatElement position;
        @Nullable
        public CompactVertexFormatElement color;
        @Nullable
        public CompactVertexFormatElement texture;
        @Nullable
        public CompactVertexFormatElement overlay;
        @Nullable
        public CompactVertexFormatElement lightmap;
        @Nullable
        public CompactVertexFormatElement normal;
        public int byteStride = -1;

        public CompactVertexFormat build() {
            return new CompactVertexFormat(this);
        }

        public Builder position(CompactVertexFormatElement position) {
            this.position = position;
            return this;
        }

        public Builder color(CompactVertexFormatElement color) {
            this.color = color;
            return this;
        }

        public Builder texture(CompactVertexFormatElement texture) {
            this.texture = texture;
            return this;
        }

        public Builder overlay(CompactVertexFormatElement overlay) {
            this.overlay = overlay;
            return this;
        }

        public Builder lightmap(CompactVertexFormatElement lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public Builder normal(CompactVertexFormatElement normal) {
            this.normal = normal;
            return this;
        }

        public Builder byteStride(int stride) {
            this.byteStride = stride;
            return this;
        }
    }
}

