/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.ClientState;
import builderb0y.bigglobe.mixinInterfaces.LodSystemHolder;
import builderb0y.bigglobe.rendering.OutOfVramException;
import builderb0y.bigglobe.rendering.lods.LodFrustum;
import builderb0y.bigglobe.rendering.lods.VersionedVertexConsumerProvider;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import builderb0y.bigglobe.versions.RenderVersions;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_5539;

@Environment(value=EnvType.CLIENT)
public interface LodRenderer
extends SafeCloseable {
    public SafeCloseable bind(LodRenderState var1, boolean var2);

    public void draw(SafeCloseable var1, float var2, float var3, float var4, float var5);

    public VersionedVertexConsumerProvider beginMeshing();

    public MeshUploader finishMeshing();

    default public void oom() {
    }

    public void endMeshing(VersionedVertexConsumerProvider var1);

    default public List<String> getF3MenuText() {
        return Collections.emptyList();
    }

    @Override
    default public void close() {
    }

    public static interface MeshUploader
    extends SafeCloseable {
        public SafeCloseable upload(VersionedVertexConsumerProvider var1) throws OutOfVramException;
    }

    public static class LodRenderState {
        public LodSystemHolder lodSystemHolder;
        public float fogR;
        public float fogG;
        public float fogB;
        public float partialTicks;
        public float rainStrength;
        public float thunderStrength;
        public int worldMinY;
        public int worldMaxY;
        public ClientState clientState;
        public LodFrustum frustum = new LodFrustum();

        public void setup(WorldRenderContext context) {
            this.lodSystemHolder = LodSystemHolder.of(context.worldRenderer());
            this.partialTicks = RenderVersions.partialTicks(context);
            this.rainStrength = context.world().method_8430(this.partialTicks);
            this.thunderStrength = context.world().method_8478(this.partialTicks);
            this.worldMinY = HeightLimitViewVersions.getMinY((class_5539)context.world());
            this.worldMaxY = HeightLimitViewVersions.getMaxY((class_5539)context.world());
            this.clientState = ClientState.get((class_5321<class_1937>)context.world().method_27983());
            this.frustum.setup(context);
        }
    }
}

