/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.rendering.lods.VanillaLodShader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL32C;

@Environment(value=EnvType.CLIENT)
public class SeparateLodShader
extends VanillaLodShader {
    public int modelOffset;

    public SeparateLodShader() {
        this.compileStage(this.fragmentStage, "#version 150\n\nuniform sampler2D blockAtlas;\nuniform sampler2D lightmap;\nuniform vec3 fogColor;\nuniform vec3 fogParams;\n\n#define altitude fogParams.x\n#define verticalMultiplier fogParams.y\n#define globalMultiplier fogParams.z\n\nin vec2 texcoord;\nin vec2 lmcoord;\nin vec4 tint;\nin vec3 pos;\n\nout vec4 color;\n\nvoid main() {\n\tcolor = (\n\t\t//texture(lightmap, gl_FragCoord.xy / vec2(1536.0, 896.0))\n\t\ttexture(blockAtlas, texcoord) *\n\t\ttexture(lightmap, lmcoord) *\n\t\ttint\n\t);\n\tif (color.a < 0.1) discard;\n\n\tif (globalMultiplier < 0.0) {\n\t\tfloat dist = length(pos);\n\t\tfloat opticalDepth;\n\t\tif (verticalMultiplier < 0.0) {\n\t\t\tvec3 ray = pos / dist;\n\t\t\tif (abs(ray.y) < 0.00001) {\n\t\t\t\topticalDepth = dist * exp(min(altitude * verticalMultiplier, 32.0));\n\t\t\t}\n\t\t\telse {\n\t\t\t\topticalDepth = ((exp(min(dist * ray.y * verticalMultiplier, 32.0)) - 1.0) * exp(min(altitude * verticalMultiplier, 32.0))) / (ray.y * verticalMultiplier);\n\t\t\t}\n\t\t}\n\t\telse {\n\t\t\topticalDepth = dist;\n\t\t}\n\t\tcolor.rgb = mix(fogColor, color.rgb, exp2(opticalDepth * globalMultiplier));\n\t}\n}\n");
        this.compileStage(this.vertexStage, "#version 150\n#define MIN_LOD 6\nuniform mat4 modelViewProjectionMatrix;\nuniform vec4 modelOffset;\n\nin uvec2 horizontalPosition;\nin int verticalPosition;\nin vec4 colorData;\nin vec2 texcoordData;\nin vec2 lightData;\n\nout vec2 texcoord;\nout vec2 lmcoord;\nout vec4 tint;\nout vec3 pos;\n\nvoid main() {\n\tvec3 modelPos;\n\tmodelPos.xz = vec2(horizontalPosition) * (float(1 << MIN_LOD) / 128.0) - 64.0 * (float(1 << MIN_LOD) / 128.0);\n\tmodelPos.y = float(verticalPosition) * (4096.0 / 32768.0);\n\tpos = modelPos * modelOffset.w + modelOffset.xyz;\n\tgl_Position = modelViewProjectionMatrix * vec4(pos, 1.0);\n\ttint = colorData;\n\ttexcoord = texcoordData * (1.0 / 65536.0);\n\tlmcoord = lightData;\n}\n");
        this.link();
        this.modelViewProjectionMatrix = GL32C.glGetUniformLocation((int)this.program, (CharSequence)"modelViewProjectionMatrix");
        this.blockAtlas = GL32C.glGetUniformLocation((int)this.program, (CharSequence)"blockAtlas");
        this.lightmap = GL32C.glGetUniformLocation((int)this.program, (CharSequence)"lightmap");
        this.modelOffset = GL32C.glGetUniformLocation((int)this.program, (CharSequence)"modelOffset");
        this.fogColor = GL32C.glGetUniformLocation((int)this.program, (CharSequence)"fogColor");
        this.fogParams = GL32C.glGetUniformLocation((int)this.program, (CharSequence)"fogParams");
    }
}

