/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.math.Interpolator;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.util.InfoHolder;

public class ColorScriptEnvironment {
    public static final Info INFO = new Info();
    public static final MutableScriptEnvironment ENVIRONMENT = new MutableScriptEnvironment().addFieldInvokeStatic(ColorScriptEnvironment.INFO.redI).addFieldInvokeStatic(ColorScriptEnvironment.INFO.greenI).addFieldInvokeStatic(ColorScriptEnvironment.INFO.blueI).addFieldInvokeStatic(ColorScriptEnvironment.INFO.alphaI).addFieldInvokeStatic(ColorScriptEnvironment.INFO.redF).addFieldInvokeStatic(ColorScriptEnvironment.INFO.greenF).addFieldInvokeStatic(ColorScriptEnvironment.INFO.blueF).addFieldInvokeStatic(ColorScriptEnvironment.INFO.alphaF).addFieldInvokeStatic(ColorScriptEnvironment.INFO.redD).addFieldInvokeStatic(ColorScriptEnvironment.INFO.greenD).addFieldInvokeStatic(ColorScriptEnvironment.INFO.blueD).addFieldInvokeStatic(ColorScriptEnvironment.INFO.alphaD).addFunctionInvokeStatic(ColorScriptEnvironment.INFO.packI).addFunctionInvokeStatic(ColorScriptEnvironment.INFO.packF).addFunctionInvokeStatic(ColorScriptEnvironment.INFO.packD).addFunctionInvokeStatic("packI", ColorScriptEnvironment.INFO.packAI).addFunctionInvokeStatic("packF", ColorScriptEnvironment.INFO.packAF).addFunctionInvokeStatic("packD", ColorScriptEnvironment.INFO.packAD);

    public static int alphaI(int packed) {
        return packed >>> 24;
    }

    public static int redI(int packed) {
        return packed >>> 16 & 0xFF;
    }

    public static int greenI(int packed) {
        return packed >>> 8 & 0xFF;
    }

    public static int blueI(int packed) {
        return packed & 0xFF;
    }

    public static float alphaF(int packed) {
        return (float)ColorScriptEnvironment.alphaI(packed) / 255.0f;
    }

    public static float redF(int packed) {
        return (float)ColorScriptEnvironment.redI(packed) / 255.0f;
    }

    public static float greenF(int packed) {
        return (float)ColorScriptEnvironment.greenI(packed) / 255.0f;
    }

    public static float blueF(int packed) {
        return (float)ColorScriptEnvironment.blueI(packed) / 255.0f;
    }

    public static double alphaD(int packed) {
        return (double)ColorScriptEnvironment.alphaI(packed) / 255.0;
    }

    public static double redD(int packed) {
        return (double)ColorScriptEnvironment.redI(packed) / 255.0;
    }

    public static double greenD(int packed) {
        return (double)ColorScriptEnvironment.greenI(packed) / 255.0;
    }

    public static double blueD(int packed) {
        return (double)ColorScriptEnvironment.blueI(packed) / 255.0;
    }

    public static int packI(int red, int green, int blue) {
        red = Interpolator.clamp(0, 255, red);
        green = Interpolator.clamp(0, 255, green);
        blue = Interpolator.clamp(0, 255, blue);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int packF(float red, float green, float blue) {
        return ColorScriptEnvironment.packI((int)(red * 255.0f + 0.5f), (int)(green * 255.0f + 0.5f), (int)(blue * 255.0f + 0.5f));
    }

    public static int packD(double red, double green, double blue) {
        return ColorScriptEnvironment.packI((int)(red * 255.0 + 0.5), (int)(green * 255.0 + 0.5), (int)(blue * 255.0 + 0.5));
    }

    public static int packAI(int red, int green, int blue, int alpha) {
        red = Interpolator.clamp(0, 255, red);
        green = Interpolator.clamp(0, 255, green);
        blue = Interpolator.clamp(0, 255, blue);
        alpha = Interpolator.clamp(0, 255, alpha);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int packAF(float red, float green, float blue, float alpha) {
        return ColorScriptEnvironment.packAI((int)(red * 255.0f + 0.5f), (int)(green * 255.0f + 0.5f), (int)(blue * 255.0f + 0.5f), (int)(alpha * 255.0f + 0.5f));
    }

    public static int packAD(double red, double green, double blue, double alpha) {
        return ColorScriptEnvironment.packAI((int)(red * 255.0 + 0.5), (int)(green * 255.0 + 0.5), (int)(blue * 255.0 + 0.5), (int)(alpha * 255.0 + 0.5));
    }

    public static class Info
    extends InfoHolder {
        public MethodInfo redI;
        public MethodInfo greenI;
        public MethodInfo blueI;
        public MethodInfo alphaI;
        public MethodInfo redF;
        public MethodInfo greenF;
        public MethodInfo blueF;
        public MethodInfo alphaF;
        public MethodInfo redD;
        public MethodInfo greenD;
        public MethodInfo blueD;
        public MethodInfo alphaD;
        public MethodInfo packI;
        public MethodInfo packF;
        public MethodInfo packD;
        public MethodInfo packAI;
        public MethodInfo packAF;
        public MethodInfo packAD;
    }
}

