/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.mixinInterfaces.NbtCompoundExtensions;
import builderb0y.bigglobe.versions.NbtVersions;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.collections.NormalListMapGetterInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.NamedValues;
import builderb0y.scripting.util.TypeInfos;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class NbtScriptEnvironment {
    public static final TypeInfo NBT_ELEMENT_TYPE = InsnTrees.type(class_2520.class);
    public static final TypeInfo NBT_BYTE_TYPE = InsnTrees.type(class_2481.class);
    public static final TypeInfo NBT_SHORT_TYPE = InsnTrees.type(class_2516.class);
    public static final TypeInfo NBT_INT_TYPE = InsnTrees.type(class_2497.class);
    public static final TypeInfo NBT_LONG_TYPE = InsnTrees.type(class_2503.class);
    public static final TypeInfo NBT_FLOAT_TYPE = InsnTrees.type(class_2494.class);
    public static final TypeInfo NBT_DOUBLE_TYPE = InsnTrees.type(class_2489.class);
    public static final TypeInfo NBT_NUMBER_TYPE = InsnTrees.type(class_2514.class);
    public static final TypeInfo NBT_BYTE_ARRAY_TYPE = InsnTrees.type(class_2479.class);
    public static final TypeInfo NBT_INT_ARRAY_TYPE = InsnTrees.type(class_2495.class);
    public static final TypeInfo NBT_LONG_ARRAY_TYPE = InsnTrees.type(class_2501.class);
    public static final TypeInfo NBT_LIST_TYPE = InsnTrees.type(class_2499.class);
    public static final TypeInfo NBT_COLLECTION_TYPE = InsnTrees.type(class_2483.class);
    public static final TypeInfo NBT_STRING_TYPE = InsnTrees.type(class_2519.class);
    public static final TypeInfo NBT_COMPOUND_TYPE = InsnTrees.type(class_2487.class);
    public static final TypeInfo NBT_ENVIRONMENT_TYPE = InsnTrees.type(NbtScriptEnvironment.class);
    public static final MethodInfo NBT_BYTE_ARRAY_CONSTRUCTOR = MethodInfo.getMethod(NbtScriptEnvironment.class, "nbtByteArray");
    public static final MethodInfo NBT_INT_ARRAY_CONSTRUCTOR = MethodInfo.getMethod(NbtScriptEnvironment.class, "nbtIntArray");
    public static final MethodInfo NBT_LONG_ARRAY_CONSTRUCTOR = MethodInfo.getMethod(NbtScriptEnvironment.class, "nbtLongArray");
    public static final MethodInfo GET_MEMBER = MethodInfo.getMethod(NbtScriptEnvironment.class, "getMember");
    public static final MethodInfo SET_MEMBER = MethodInfo.getMethod(NbtScriptEnvironment.class, "setMember");
    public static final MethodInfo GET_ELEMENT = MethodInfo.getMethod(NbtScriptEnvironment.class, "getElement");
    public static final MethodInfo SET_ELEMENT = MethodInfo.getMethod(NbtScriptEnvironment.class, "setElement");
    public static final MutableScriptEnvironment COMMON = new MutableScriptEnvironment().addType("Nbt", NBT_ELEMENT_TYPE).addType("NbtByte", NBT_BYTE_TYPE).addType("NbtShort", NBT_SHORT_TYPE).addType("NbtInt", NBT_INT_TYPE).addType("NbtLong", NBT_LONG_TYPE).addType("NbtFloat", NBT_FLOAT_TYPE).addType("NbtDouble", NBT_DOUBLE_TYPE).addType("NbtNumber", NBT_NUMBER_TYPE).addType("NbtByteArray", NBT_BYTE_ARRAY_TYPE).addType("NbtIntArray", NBT_INT_ARRAY_TYPE).addType("NbtLongArray", NBT_LONG_ARRAY_TYPE).addType("NbtList", NBT_LIST_TYPE).addType("NbtCollection", NBT_COLLECTION_TYPE).addType("NbtString", NBT_STRING_TYPE).addType("NbtCompound", NBT_COMPOUND_TYPE).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtBoolean", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtByte", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtShort", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtInt", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtLong", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtFloat", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtDouble", true).addCastInvokeStatic(NbtScriptEnvironment.class, "nbtString", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asBoolean", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asByte", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asShort", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asInt", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asLong", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asFloat", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asDouble", true).addCastInvokeStatic(NbtScriptEnvironment.class, "asString", true).addFunctionInvokeStatics(NbtScriptEnvironment.class, "nbtBoolean", "nbtByte", "nbtShort", "nbtInt", "nbtLong", "nbtFloat", "nbtDouble", "nbtString").addFunction("nbtByteArray", NbtScriptEnvironment.array(NBT_BYTE_ARRAY_CONSTRUCTOR)).addFunction("nbtIntArray", NbtScriptEnvironment.array(NBT_INT_ARRAY_CONSTRUCTOR)).addFunction("nbtLongArray", NbtScriptEnvironment.array(NBT_LONG_ARRAY_CONSTRUCTOR)).addFunction("nbtList", new MutableScriptEnvironment.FunctionHandler.Named("nbtList(element1, element2, ...)", (parser, name, arguments) -> {
        InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, name, InsnTrees.repeat(NBT_ELEMENT_TYPE, arguments.length), InsnTree.CastMode.IMPLICIT_THROW, arguments);
        return new MutableScriptEnvironment.CastResult(new ListBuilderInsnTree(castArguments), arguments != castArguments);
    })).addKeyword("nbtCompound", new MutableScriptEnvironment.KeywordHandler.Named("nbtCompound(key1: value1, key2: value2, ...)", (parser, name) -> {
        NamedValues namedValues = NamedValues.parse(parser, NBT_ELEMENT_TYPE, null);
        return namedValues.maybeWrap(new CompoundBuilderInsnTree(namedValues.values()));
    })).addMethodInvokeStatics(NbtScriptEnvironment.class, "asBoolean", "asByte", "asShort", "asInt", "asLong", "asFloat", "asDouble", "asString");

    public static Consumer<MutableScriptEnvironment> createCommon() {
        return environment -> environment.addAll(COMMON);
    }

    public static Consumer<MutableScriptEnvironment> createImmutable() {
        return environment -> environment.configure(NbtScriptEnvironment.createCommon()).addMethod(NBT_ELEMENT_TYPE, "", new MutableScriptEnvironment.MethodHandler.Named("element.(key or index)", (parser, receiver, name, mode, arguments) -> {
            if (arguments.length != 1) {
                throw new ScriptParsingException("Wrong number of arguments: expected 1, got " + arguments.length, parser.input);
            }
            InsnTree nameOrIndex = arguments[0];
            if (nameOrIndex.getTypeInfo().equals(TypeInfos.STRING)) {
                return new MutableScriptEnvironment.CastResult(InsnTrees.invokeStatic(GET_MEMBER, receiver, nameOrIndex), false);
            }
            if (nameOrIndex.getTypeInfo().isSingleWidthInt()) {
                return new MutableScriptEnvironment.CastResult(InsnTrees.invokeStatic(GET_ELEMENT, receiver, nameOrIndex.cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false)), false);
            }
            throw new ScriptParsingException("Indexing an NBT element requires a String or int as the key", parser.input);
        })).addField(NBT_ELEMENT_TYPE, null, new MutableScriptEnvironment.FieldHandler.Named("compound.key", (parser, receiver, name, mode) -> InsnTrees.invokeStatic(GET_MEMBER, receiver, InsnTrees.ldc(name))));
    }

    public static Consumer<MutableScriptEnvironment> createMutable() {
        return environment -> environment.configure(NbtScriptEnvironment.createCommon()).addMethod(NBT_ELEMENT_TYPE, "", new MutableScriptEnvironment.MethodHandler.Named("element.(key or index)", (parser, receiver, name, mode, arguments) -> {
            if (arguments.length != 1) {
                throw new ScriptParsingException("Wrong number of arguments: expected 1, got " + arguments.length, parser.input);
            }
            InsnTree nameOrIndex = arguments[0];
            if (nameOrIndex.getTypeInfo().equals(TypeInfos.STRING)) {
                return new MutableScriptEnvironment.CastResult(NormalListMapGetterInsnTree.from(receiver, GET_MEMBER, nameOrIndex, SET_MEMBER, "NbtElement", mode), false);
            }
            if (nameOrIndex.getTypeInfo().isSingleWidthInt()) {
                return new MutableScriptEnvironment.CastResult(NormalListMapGetterInsnTree.from(receiver, GET_ELEMENT, nameOrIndex.cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false), SET_ELEMENT, "NbtElement", mode), false);
            }
            throw new ScriptParsingException("Indexing an NBT element requires a String or int as the key", parser.input);
        })).addField(NBT_ELEMENT_TYPE, null, new MutableScriptEnvironment.FieldHandler.Named("compound.key", (parser, receiver, name, mode) -> {
            InsnTree insnTree = InsnTrees.ldc(name);
            return NormalListMapGetterInsnTree.from(receiver, GET_MEMBER, insnTree, SET_MEMBER, "NbtElement", switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case ScriptEnvironment.GetFieldMode.NORMAL -> ScriptEnvironment.GetMethodMode.NORMAL;
                case ScriptEnvironment.GetFieldMode.NULLABLE -> ScriptEnvironment.GetMethodMode.NULLABLE;
                case ScriptEnvironment.GetFieldMode.RECEIVER -> ScriptEnvironment.GetMethodMode.RECEIVER;
                case ScriptEnvironment.GetFieldMode.NULLABLE_RECEIVER -> ScriptEnvironment.GetMethodMode.NULLABLE_RECEIVER;
            });
        }));
    }

    public static class_2481 nbtBoolean(boolean value) {
        return class_2481.method_23234((boolean)value);
    }

    public static class_2481 nbtByte(byte value) {
        return class_2481.method_23233((byte)value);
    }

    public static class_2516 nbtShort(short value) {
        return class_2516.method_23254((short)value);
    }

    public static class_2497 nbtInt(int value) {
        return class_2497.method_23247((int)value);
    }

    public static class_2503 nbtLong(long value) {
        return class_2503.method_23251((long)value);
    }

    public static class_2494 nbtFloat(float value) {
        return class_2494.method_23244((float)value);
    }

    public static class_2489 nbtDouble(double value) {
        return class_2489.method_23241((double)value);
    }

    public static class_2519 nbtString(String value) {
        return value == null ? null : class_2519.method_23256((String)value);
    }

    public static class_2479 nbtByteArray(byte[] value) {
        return value == null ? null : new class_2479(value);
    }

    public static class_2495 nbtIntArray(int[] value) {
        return value == null ? null : new class_2495(value);
    }

    public static class_2501 nbtLongArray(long[] value) {
        return value == null ? null : new class_2501(value);
    }

    public static boolean asBoolean(class_2520 element) {
        class_2514 number;
        return element instanceof class_2514 && (number = (class_2514)element).method_10698() != 0;
    }

    public static byte asByte(class_2520 element) {
        byte by;
        if (element instanceof class_2514) {
            class_2514 number = (class_2514)element;
            by = number.method_10698();
        } else {
            by = 0;
        }
        return by;
    }

    public static short asShort(class_2520 element) {
        short s;
        if (element instanceof class_2514) {
            class_2514 number = (class_2514)element;
            s = number.method_10696();
        } else {
            s = 0;
        }
        return s;
    }

    public static int asInt(class_2520 element) {
        int n;
        if (element instanceof class_2514) {
            class_2514 number = (class_2514)element;
            n = number.method_10701();
        } else {
            n = 0;
        }
        return n;
    }

    public static long asLong(class_2520 element) {
        long l;
        if (element instanceof class_2514) {
            class_2514 number = (class_2514)element;
            l = number.method_10699();
        } else {
            l = 0L;
        }
        return l;
    }

    public static float asFloat(class_2520 element) {
        float f;
        if (element instanceof class_2514) {
            class_2514 number = (class_2514)element;
            f = number.method_10700();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static double asDouble(class_2520 element) {
        double d;
        if (element instanceof class_2514) {
            class_2514 number = (class_2514)element;
            d = number.method_10697();
        } else {
            d = 0.0;
        }
        return d;
    }

    public static String asString(class_2520 element) {
        String string;
        if (element instanceof class_2519) {
            class_2519 string2 = (class_2519)element;
            string = NbtVersions.stringValue(string2);
        } else {
            string = null;
        }
        return string;
    }

    public static class_2520 getMember(class_2520 element, String name) {
        class_2520 class_25202;
        if (element instanceof class_2487) {
            class_2487 compound = (class_2487)element;
            class_25202 = compound.method_10580(name);
        } else {
            class_25202 = null;
        }
        return class_25202;
    }

    public static class_2520 setMember(class_2520 element, String name, class_2520 value) {
        Objects.requireNonNull(name, "key is null.");
        if (element instanceof class_2487) {
            class_2487 compound = (class_2487)element;
            if (value != null) {
                return compound.method_10566(name, value);
            }
            return ((NbtCompoundExtensions)compound).bigglobe_remove(name);
        }
        throw new IllegalArgumentException("Can't set member named " + name + " on " + String.valueOf(element) + " to " + String.valueOf(value));
    }

    public static class_2520 getElement(class_2520 element, int index) {
        if (element instanceof class_2483) {
            class_2483 list = (class_2483)element;
            if (index >= 0 && index < list.size()) {
                return (class_2520)list.get(index);
            }
        }
        return null;
    }

    public static class_2520 setElement(class_2520 element, int index, class_2520 value) {
        if (value == null) {
            throw new NullPointerException("Can't set index " + index + " on " + String.valueOf(element) + " to a null value");
        }
        if (element instanceof class_2483) {
            class_2483 list = (class_2483)element;
            return list.method_10606(index, value);
        }
        throw new IllegalArgumentException("Can't set element at index " + index + " on " + String.valueOf(element) + " to " + String.valueOf(value));
    }

    public static MutableScriptEnvironment.FunctionHandler.Named array(MethodInfo method) {
        return new MutableScriptEnvironment.FunctionHandler.Named("NBT array constructor: " + String.valueOf(method), (parser, name, arguments) -> {
            InsnTree[] insnTreeArray;
            if (arguments.length == 1 && arguments[0].getTypeInfo().equals(method.paramTypes[0])) {
                insnTreeArray = arguments;
            } else {
                InsnTree[] insnTreeArray2 = new InsnTree[1];
                insnTreeArray = insnTreeArray2;
                insnTreeArray2[0] = InsnTrees.newArrayWithContents(parser, method.paramTypes[0], arguments);
            }
            return new MutableScriptEnvironment.CastResult(InsnTrees.invokeStatic(method, insnTreeArray), false);
        });
    }

    public static class CompoundBuilderInsnTree
    implements InsnTree {
        public static final MethodInfo CONSTRUCT = MethodInfo.findConstructor(class_2487.class, new Class[0]);
        public static final MethodInfo BUILD_COMPOUND = MethodInfo.getMethod(CompoundBuilderInsnTree.class, "buildCompound");
        public NamedValues.NamedValue[] pairs;

        public CompoundBuilderInsnTree(NamedValues.NamedValue[] pairs) {
            this.pairs = pairs;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            InsnTrees.newInstance(CONSTRUCT, new InsnTree[0]).emitBytecode(method);
            for (NamedValues.NamedValue pair : this.pairs) {
                InsnTrees.constant(pair.name()).emitBytecode(method);
                pair.value().emitBytecode(method);
                BUILD_COMPOUND.emit(method, 184);
            }
        }

        @Override
        public TypeInfo getTypeInfo() {
            return NBT_COMPOUND_TYPE;
        }

        public static class_2487 buildCompound(class_2487 compound, String name, class_2520 element) {
            if (element != null) {
                compound.method_10566(name, element);
            }
            return compound;
        }
    }

    public static class ListBuilderInsnTree
    implements InsnTree {
        public static final MethodInfo CONSTRUCT = MethodInfo.findConstructor(class_2499.class, new Class[0]);
        public static final MethodInfo BUILD_LIST = MethodInfo.getMethod(ListBuilderInsnTree.class, "buildList");
        public InsnTree[] values;

        public ListBuilderInsnTree(InsnTree[] values) {
            this.values = values;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            InsnTrees.newInstance(CONSTRUCT, new InsnTree[0]).emitBytecode(method);
            for (InsnTree value : this.values) {
                value.emitBytecode(method);
                BUILD_LIST.emit(method, 184);
            }
        }

        @Override
        public TypeInfo getTypeInfo() {
            return NBT_LIST_TYPE;
        }

        public static class_2499 buildList(class_2499 list, class_2520 element) {
            list.add((Object)Objects.requireNonNull(element, "element"));
            return list;
        }
    }
}

