/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.settings;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.common.AbstractDecodeContext;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.common.FactoryException;
import builderb0y.autocodec.data.AbstractNumberData;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.NumberData;
import builderb0y.autocodec.data.StringData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.bigglobe.noise.Permuter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UseCoder(name="new", in=SeedCoder.class, usage=MemberUsage.METHOD_IS_FACTORY)
public class Seed {
    public static final int AUTO = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 4;
    public final long value;

    public Seed(long value) {
        this.value = value;
    }

    public long xor(long other) {
        return this.value ^ other;
    }

    public long xor(Seed other) {
        return this.value ^ other.value;
    }

    public static class SeedCoder
    extends AutoCoder.NamedCoder<Seed> {
        public final int modes;

        public SeedCoder(int modes) {
            super("SeedCoder");
            this.modes = modes;
        }

        public SeedCoder(FactoryContext<Seed> context) {
            super("SeedCoder");
            SeedModes annotation = (SeedModes)context.type.getAnnotations().getFirst(SeedModes.class);
            this.modes = (annotation != null ? annotation.value() : -1) & 7;
            if (this.modes == 0) {
                throw new FactoryException("@SeedModes annotation specified no modes.");
            }
        }

        public <T_Encoded> long recursiveDecodeSeed(AbstractDecodeContext<T_Encoded, ?, ?> context, String key, boolean last) throws Exception {
            AbstractNumberData number;
            StringData string;
            AbstractDecodeContext value = context.tryGetMember(key);
            if ((this.modes & 1) != 0 && value.isEmpty()) {
                long seed = context.parent != null ? this.recursiveDecodeSeed(context.parent, key, false) : 0L;
                DecodeContext.DecodePath decodePath = context.path;
                if (decodePath instanceof DecodeContext.ObjectDecodePath) {
                    DecodeContext.ObjectDecodePath objectDecodePath = (DecodeContext.ObjectDecodePath)decodePath;
                    seed = Permuter.permute(seed, objectDecodePath.memberName());
                } else {
                    decodePath = context.path;
                    if (decodePath instanceof DecodeContext.ArrayDecodePath) {
                        DecodeContext.ArrayDecodePath arrayDecodePath = (DecodeContext.ArrayDecodePath)decodePath;
                        seed = Permuter.permute(seed, arrayDecodePath.index());
                    }
                }
                if (last) {
                    seed = Permuter.permute(seed, key);
                }
                return seed;
            }
            if ((this.modes & 4) != 0 && (string = value.tryAsString()) != null) {
                return Permuter.permute(0L, string.value);
            }
            if ((this.modes & 2) != 0 && (number = value.tryAsNumber()) != null) {
                return number.longValue();
            }
            throw new DecodeException(() -> {
                StringBuilder builder = context.pathToStringBuilder().append(" must be ");
                ArrayList<String> options = new ArrayList<String>(3);
                if ((this.modes & 1) != 0) {
                    options.add("null");
                }
                if ((this.modes & 2) != 0) {
                    options.add("a number");
                }
                if ((this.modes & 4) != 0) {
                    options.add("a string");
                }
                switch (options.size()) {
                    case 0: {
                        throw new AssertionError((Object)"no modes");
                    }
                    case 1: {
                        builder.append((String)options.get(0));
                        break;
                    }
                    case 2: {
                        builder.append((String)options.get(0)).append(" or ").append((String)options.get(1));
                        break;
                    }
                    case 3: {
                        builder.append((String)options.get(0)).append(", ").append((String)options.get(1)).append(", or ").append((String)options.get(2));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)(options.size() + " modes?"));
                    }
                }
                return builder.toString();
            });
        }

        @Nullable
        public <T_Encoded> Seed decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            String key = ((DecodeContext.ObjectDecodePath)context.path).memberName();
            try {
                return new Seed(this.recursiveDecodeSeed(Objects.requireNonNull(context.parent, "context.parent"), key, true));
            }
            catch (DecodeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new DecodeException((Throwable)exception);
            }
        }

        @ApiStatus.OverrideOnly
        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, Seed> context) throws EncodeException {
            Seed seed = (Seed)context.object;
            return seed == null ? EmptyData.INSTANCE : new NumberData(seed.value);
        }
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SeedModes {
        public int value();
    }
}

