/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.settings;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseEncoder;
import builderb0y.autocodec.annotations.UseImprinter;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.decoders.AutoDecoder;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.AutoEncoder;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.imprinters.AutoImprinter;
import builderb0y.autocodec.imprinters.ImprintContext;
import builderb0y.autocodec.imprinters.ImprintException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.autocodec.util.DFUVersions;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@UseImprinter(name="new", in=Imprinter.class, usage=MemberUsage.METHOD_IS_FACTORY, strict=false)
@UseEncoder(name="new", in=Encoder.class, usage=MemberUsage.METHOD_IS_FACTORY, strict=false)
public class VariationsList<T> {
    public transient Data source;
    public transient List<T> elements;

    public static <T> T unwrap(DataResult<T> result) {
        Object actualResult = DFUVersions.getResult(result);
        if (actualResult != null) {
            return (T)actualResult;
        }
        throw AutoCodecUtil.rethrow((Throwable)new DecodeException(DFUVersions.getMessageLazy(result)));
    }

    public static Data merge(Data oldObject, Data newObject, boolean deep) {
        MapData oldMap = oldObject.tryAsMap();
        MapData newMap = newObject.tryAsMap();
        if (oldMap != null && newMap != null) {
            MapData result = new MapData(oldMap.size() + newMap.size());
            result.value.putAll(oldMap.value);
            if (deep) {
                for (Map.Entry entry : newMap.value.entrySet()) {
                    result.value.merge((Data)entry.getKey(), (Data)entry.getValue(), (first, second) -> VariationsList.merge(first, second, true));
                }
            } else {
                result.value.putAll(newMap.value);
            }
            return result;
        }
        return newObject;
    }

    public static Stream<Data> flatten(Stream<Data> oldLayer, Data[] newLayer, boolean deep) {
        return oldLayer.flatMap(element1 -> Arrays.stream(newLayer).map(element2 -> VariationsList.merge(element1, element2, deep)));
    }

    public static Stream<Data> expand(Data root) {
        ListData variations = root.getMember("variations").tryAsList();
        if (variations != null) {
            boolean deep = root.getMember("deep").getAsBooleanOr(false);
            Data defaults = root.getMember("defaults");
            if (!defaults.isEmpty()) {
                Data[] layers = (Data[])variations.value.stream().flatMap(VariationsList::expand).toArray((IntFunction<A[]>)Data.ARRAY_FACTORY);
                return VariationsList.flatten(Stream.of(defaults), layers, deep);
            }
            Data[] layers = (Data[])variations.value.stream().map(list -> ListData.collect(VariationsList.forceStream(list).flatMap(VariationsList::expand))).toArray((IntFunction<A[]>)Data.ARRAY_FACTORY);
            Stream<Data> stream = VariationsList.forceStream(layers[0]);
            int length = layers.length;
            for (int index = 1; index < length; ++index) {
                stream = VariationsList.flatten(stream, (Data[])VariationsList.forceStream(layers[index]).toArray((IntFunction<A[]>)Data.ARRAY_FACTORY), deep);
            }
            return stream;
        }
        ListData list2 = root.tryAsList();
        if (list2 != null) {
            return list2.value.stream().flatMap(VariationsList::expand);
        }
        return Stream.of(root);
    }

    public static Stream<Data> forceStream(Data data) {
        ListData list = data.tryAsList();
        if (list != null) {
            return list.value.stream();
        }
        throw AutoCodecUtil.rethrow((Throwable)new DecodeException(() -> "Not a list: " + String.valueOf(data)));
    }

    public static class Encoder<T>
    extends AutoEncoder.NamedEncoder<VariationsList<T>> {
        public Encoder(ReifiedType<VariationsList<T>> type) {
            super(type);
        }

        public Encoder(FactoryContext<VariationsList<T>> context) {
            this(context.type);
        }

        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, VariationsList<T>> context) throws EncodeException {
            return context.object == null ? EmptyData.INSTANCE : ((VariationsList)context.object).source;
        }

        public static <T_From, T_To> T_To convert(Dynamic<T_From> dynamic, DynamicOps<T_To> ops) {
            return (T_To)Dynamic.convert((DynamicOps)dynamic.getOps(), ops, (Object)dynamic.getValue());
        }
    }

    public static class Imprinter<T>
    extends AutoImprinter.NamedImprinter<VariationsList<T>> {
        public final AutoDecoder<List<T>> listEncoder;

        public Imprinter(ReifiedType<VariationsList<T>> type, AutoDecoder<List<T>> imprinter) {
            super(type);
            this.listEncoder = imprinter;
        }

        public Imprinter(FactoryContext<VariationsList<T>> context) {
            this(context.type, context.type(ReifiedType.parameterize(List.class, (ReifiedType[])new ReifiedType[]{context.type.resolveParameter(VariationsList.class)})).forceCreateDecoder());
        }

        public <T_Encoded> void imprint(@NotNull ImprintContext<T_Encoded, VariationsList<T>> context) throws ImprintException {
            try {
                ((VariationsList)context.object).source = context.data;
                ListData list = ListData.collect(VariationsList.expand(context.data)).deepCopy();
                ((VariationsList)context.object).elements = (List)((ImprintContext)context.withData((Data)list)).decodeWith(this.listEncoder);
            }
            catch (ImprintException exception) {
                throw exception;
            }
            catch (DecodeException exception) {
                throw new ImprintException((Throwable)exception);
            }
        }
    }
}

