/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures;

import builderb0y.autocodec.util.HashStrategies;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.util.Directions;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.random.RandomGenerator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3341;
import org.jetbrains.annotations.Nullable;

public abstract class LabyrinthLayout {
    public static final class_2350[] POSITIVE_HORIZONTALS = new class_2350[]{Directions.POSITIVE_X, Directions.POSITIVE_Z};
    public final ObjectOpenCustomHashSet<RoomPiece> rooms;
    public final ObjectArrayList<RoomPiece> activeRooms;
    public final ObjectArrayList<HallPiece> halls;
    public final ObjectArrayList<DecorationPiece> decorations;
    public final class_2350[] horizontals;
    public final RandomGenerator random;
    public final int maxRooms;

    public LabyrinthLayout(RandomGenerator random, int maxRooms) {
        this.rooms = new ObjectOpenCustomHashSet(maxRooms, RoomPiece.HACKY_OVERLAP_STRATEGY);
        this.activeRooms = new ObjectArrayList(maxRooms);
        this.halls = new ObjectArrayList(maxRooms + (maxRooms >> 1));
        this.decorations = new ObjectArrayList(maxRooms << 1);
        this.horizontals = (class_2350[])Directions.HORIZONTAL.clone();
        this.random = random;
        this.maxRooms = maxRooms;
    }

    public abstract RoomPiece newRoom();

    public abstract HallPiece newHall(RoomPiece var1, RoomPiece var2, class_2350 var3);

    public abstract int distanceBetweenRooms();

    public abstract boolean isValidPosition(RoomPiece var1);

    public abstract int maxHeightDifference();

    public double mergeChance() {
        return 0.5;
    }

    public void generate() {
        this.spreadRooms();
        this.mergeSomeRooms();
        this.makeHalls();
        this.addDecorations();
    }

    public void spreadRooms() {
        ObjectArrayList<RoomPiece> activeRooms = this.activeRooms;
        while (!activeRooms.isEmpty() && this.rooms.size() < this.maxRooms) {
            int index = this.random.nextInt(activeRooms.size());
            if (this.spreadRoom((RoomPiece)activeRooms.get(index))) continue;
            activeRooms.set(index, (Object)((RoomPiece)activeRooms.get(activeRooms.size() - 1)));
            activeRooms.size(activeRooms.size() - 1);
        }
    }

    public boolean spreadRoom(RoomPiece from) {
        RoomPiece next = this.newRoom();
        for (class_2350 direction : this.horizontals()) {
            if (from.getConnectedRoom(direction) != null) continue;
            int heightOffset = this.random.nextInt(-this.maxHeightDifference(), this.maxHeightDifference() + 1);
            next.setPos(from.x() + direction.method_10148() * this.distanceBetweenRooms(), from.y() + heightOffset, from.z() + direction.method_10165() * this.distanceBetweenRooms());
            if (!this.isValidPosition(next) || !this.rooms.add((Object)next)) continue;
            this.activeRooms.add((Object)next);
            from.setConnectedRoom(direction, next);
            next.setConnectedRoom(direction.method_10153(), from);
            return true;
        }
        return false;
    }

    public void mergeSomeRooms() {
        RoomPiece test = this.newRoom();
        for (RoomPiece from : this.rooms) {
            if (!Permuter.nextChancedBoolean(this.random, this.mergeChance())) continue;
            for (class_2350 direction : POSITIVE_HORIZONTALS) {
                int diff;
                if (from.getConnectedRoom(direction) != null) continue;
                test.setPos(from.x() + direction.method_10148() * this.distanceBetweenRooms(), from.y(), from.z() + direction.method_10165() * this.distanceBetweenRooms());
                RoomPiece intersection = (RoomPiece)this.rooms.get((Object)test);
                if (intersection == null || intersection.getConnectedRoom(direction.method_10153()) != null || (diff = intersection.y() - from.y()) < -this.maxHeightDifference() || diff > this.maxHeightDifference()) continue;
                from.setConnectedRoom(direction, intersection);
                intersection.setConnectedRoom(direction.method_10153(), from);
            }
        }
    }

    public void makeHalls() {
        for (RoomPiece room : this.rooms) {
            for (class_2350 direction : POSITIVE_HORIZONTALS) {
                RoomPiece connection = room.getConnectedRoom(direction);
                if (connection == null) continue;
                this.halls.add((Object)this.newHall(room, connection, direction));
            }
        }
    }

    public void addDecorations() {
        for (RoomPiece room : this.rooms) {
            room.addDecorations(this);
        }
        for (HallPiece hall : this.halls) {
            hall.addDecorations(this);
        }
    }

    public class_2350[] horizontals() {
        RandomGenerator random = this.random;
        Object[] horizontals = this.horizontals;
        int index = 4;
        while (index != 0) {
            ObjectArrays.swap((Object[])horizontals, (int)random.nextInt(index), (int)(--index));
        }
        return horizontals;
    }

    public boolean isSharingFloor(RoomPiece piece) {
        class Checker
        implements RoomPiece {
            public final class_3341 box;

            public Checker(LabyrinthLayout this$0, RoomPiece from) {
                this.box = from.boundingBox();
            }

            @Override
            public class_3341 boundingBox() {
                return this.box;
            }

            @Override
            public boolean intersectsY(LabyrinthPiece that) {
                return that.boundingBox().method_35419() == this.boundingBox().method_35416();
            }

            @Override
            public void setPos(int x, int y, int z) {
            }

            @Override
            @Nullable
            public RoomPiece getConnectedRoom(class_2350 direction) {
                return null;
            }

            @Override
            public void setConnectedRoom(class_2350 direction, RoomPiece piece) {
            }
        }
        return this.rooms.contains((Object)new Checker(this, piece));
    }

    public static interface RoomPiece
    extends LabyrinthPiece {
        public static final Hash.Strategy<RoomPiece> HACKY_OVERLAP_STRATEGY = HashStrategies.of(piece -> piece.x() * 31 + piece.z(), (piece1, piece2) -> piece1.x() == piece2.x() && piece1.z() == piece2.z() && piece1.intersectsY((LabyrinthPiece)piece2));

        public void setPos(int var1, int var2, int var3);

        default public void setPos(class_2338 pos) {
            this.setPos(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }

        public RoomPiece getConnectedRoom(class_2350 var1);

        public void setConnectedRoom(class_2350 var1, RoomPiece var2);

        default public boolean intersectsY(LabyrinthPiece that) {
            return this.boundingBox().method_35416() < that.boundingBox().method_35419() && this.boundingBox().method_35419() > that.boundingBox().method_35416();
        }

        default public void addDecorations(LabyrinthLayout layout) {
        }
    }

    public static interface HallPiece
    extends LabyrinthPiece {
        default public void addDecorations(LabyrinthLayout layout) {
        }
    }

    public static interface DecorationPiece
    extends LabyrinthPiece {
    }

    public static interface LabyrinthPiece {
        public class_3341 boundingBox();

        default public int x() {
            return this.boundingBox().method_35415() + this.boundingBox().method_35418() + 1 >> 1;
        }

        default public int y() {
            return this.boundingBox().method_35416();
        }

        default public int z() {
            return this.boundingBox().method_35417() + this.boundingBox().method_35420() + 1 >> 1;
        }
    }
}

