/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.dungeons;

import builderb0y.autocodec.annotations.DefaultDouble;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.annotations.VerifyNotEmpty;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.restrictions.ColumnRestriction;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.noise.MojangPermuter;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.ConstantWeightRandomList;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomLists.IRestrictedListElement;
import builderb0y.bigglobe.randomLists.RestrictedList;
import builderb0y.bigglobe.structures.BigGlobeStructure;
import builderb0y.bigglobe.structures.LabyrinthLayout;
import builderb0y.bigglobe.structures.RawGenerationStructure;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.ChunkVersions;
import builderb0y.bigglobe.versions.DirectionVersions;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.bigglobe.versions.NbtVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import builderb0y.bigglobe.versions.WallBlockVersions;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.random.RandomGenerator;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2510;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_4778;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDungeonStructure
extends BigGlobeStructure
implements RawGenerationStructure {
    public final @VerifyNullable DelayedEntryList<class_2975<?, ?>> room_decorators;
    public final @VerifyNotEmpty IRandomList<@UseName(value="entity") class_6880<class_1299<?>>> spawner_entries;
    public final @VerifyNotEmpty List<Palette> palettes;

    public AbstractDungeonStructure(class_3195.class_7302 config, @VerifyNullable ColumnScript.ColumnToIntScript.Holder min_y, @VerifyNullable ColumnScript.ColumnToIntScript.Holder surface_y, @VerifyNullable DelayedEntryList<class_2975<?, ?>> room_decorators, IRandomList<class_6880<class_1299<?>>> spawner_entries, List<Palette> palettes) {
        super(config, min_y, surface_y);
        this.room_decorators = room_decorators;
        this.spawner_entries = spawner_entries;
        this.palettes = palettes;
    }

    @Override
    public int bigglobe_getMaxRadiusInChunks() {
        return 8;
    }

    public abstract DungeonLayout layout(ScriptedColumn var1, int var2, RandomGenerator var3);

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2794 class_27942 = context.comp_562();
        if (!(class_27942 instanceof BigGlobeScriptedChunkGenerator)) {
            return Optional.empty();
        }
        BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
        class_2338 startPos = this.randomBlockInChunk(context, 64.0, 64);
        if (startPos == null) {
            return Optional.empty();
        }
        long seed = AbstractDungeonStructure.chunkSeed(context, -7063040121406680715L);
        ScriptedColumn column = generator.newColumn(context.comp_569(), startPos.method_10263(), startPos.method_10260(), ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints());
        int y = startPos.method_10264();
        return Optional.of(new class_3195.class_7150(startPos, pieces -> {
            DungeonLayout layout = this.layout(column, y, new Permuter(seed));
            layout.generate();
            layout.addTo((class_6626)pieces);
        }));
    }

    public static abstract class DungeonLayout
    extends LabyrinthLayout {
        public int centerX;
        public int centerZ;
        public class_6880<class_3195> owningStructure;
        public int paletteIndex;
        @Nullable
        public DelayedEntryList<class_2975<?, ?>> roomDecorators;
        public IRandomList<class_6880<class_1299<?>>> spawnerEntries;

        public DungeonLayout(ScriptedColumn column, int y, RandomGenerator random, int maxRooms, @Nullable DelayedEntryList<class_2975<?, ?>> roomDecorators, IRandomList<class_6880<class_1299<?>>> spawnerEntries, class_6880<class_3195> owningStructure) {
            super(random, maxRooms);
            int n;
            this.owningStructure = owningStructure;
            this.centerX = column.x();
            this.centerZ = column.z();
            Object object = owningStructure.comp_349();
            if (object instanceof AbstractDungeonStructure) {
                AbstractDungeonStructure dungeon = (AbstractDungeonStructure)object;
                n = new RestrictedList<Palette>(dungeon.palettes, column, y).getRandomIndex(random);
            } else {
                n = -1;
            }
            this.paletteIndex = n;
            this.roomDecorators = roomDecorators;
            this.spawnerEntries = spawnerEntries;
            RoomDungeonPiece room = this.newRoom();
            room.setPos(column.x(), y, column.z());
            this.rooms.add((Object)room);
            this.activeRooms.add((Object)room);
        }

        @Override
        public abstract RoomDungeonPiece newRoom();

        @Override
        public abstract HallDungeonPiece newHall(LabyrinthLayout.RoomPiece var1, LabyrinthLayout.RoomPiece var2, class_2350 var3);

        public void addTo(class_6626 collector) {
            for (Object room : this.rooms) {
                collector.method_35462((class_3443)room);
            }
            for (Object hall : this.halls) {
                collector.method_35462((class_3443)hall);
            }
            for (Object decoration : this.decorations) {
                collector.method_35462((class_3443)decoration);
            }
        }
    }

    public static class SingleStateSupplier
    implements BlockStateSupplier {
        public class_2680 state;

        public SingleStateSupplier(class_2680 state) {
            this.state = state;
        }

        @Override
        public <C extends Comparable<C>> BlockStateSupplier with(class_2769<C> property, C value) {
            if (this.state.method_28498(property)) {
                this.state = (class_2680)this.state.method_11657(property, value);
            }
            return this;
        }

        @Override
        public class_2680 get(class_2338.class_2339 pos) {
            return this.state;
        }
    }

    public static class RandomListBlockStateSupplier
    implements BlockStateSupplier {
        public IRandomList<class_6880<class_2248>> blocks;
        public List<Object> properties;

        public RandomListBlockStateSupplier(IRandomList<class_6880<class_2248>> blocks) {
            this.blocks = blocks;
            this.properties = new ArrayList<Object>(4);
        }

        @Override
        public <C extends Comparable<C>> BlockStateSupplier with(class_2769<C> property, C value) {
            this.properties.add(property);
            this.properties.add(value);
            return this;
        }

        @Override
        public class_2680 get(class_2338.class_2339 pos) {
            class_2680 state = ((class_2248)this.blocks.getRandomElement(Permuter.permute(-135165838873709048L, (class_2382)pos)).comp_349()).method_9564();
            List<Object> properties = this.properties;
            int size = properties.size();
            for (int index = 0; index < size; index += 2) {
                class_2769 property = (class_2769)properties.get(index);
                if (!state.method_28498(property)) continue;
                Comparable value = (Comparable)properties.get(index + 1);
                state = (class_2680)state.method_11657(property, value);
            }
            return state;
        }
    }

    public static interface BlockStateSupplier
    extends CoordinateFunctions.CoordinateSupplier<class_2680> {
        public static BlockStateSupplier forBlocks(IRandomList<class_6880<class_2248>> blocks) {
            return blocks.size() == 1 ? new SingleStateSupplier(((class_2248)((class_6880)blocks.get(0)).comp_349()).method_9564()) : new RandomListBlockStateSupplier(blocks);
        }

        public <C extends Comparable<C>> BlockStateSupplier with(class_2769<C> var1, C var2);
    }

    public record Palette(@DefaultDouble(value=1.0) double weight, ColumnRestriction restrictions, IRandomList<@UseName(value="block") class_6880<class_2248>> main, IRandomList<@UseName(value="block") class_6880<class_2248>> slab, IRandomList<@UseName(value="block") class_6880<class_2248>> stairs, IRandomList<@UseName(value="block") class_6880<class_2248>> wall) implements IRestrictedListElement
    {
        public static final AutoCoder<Palette> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(Palette.class);
        public static Palette COBBLE = new Palette(1.0, ColumnRestriction.EMPTY, new ConstantWeightRandomList.RandomAccessConstantWeightRandomList<class_6880.class_6883>(List.of(class_2246.field_10445.method_40142(), class_2246.field_9989.method_40142()), 1.0), new ConstantWeightRandomList.RandomAccessConstantWeightRandomList<class_6880.class_6883>(List.of(class_2246.field_10351.method_40142(), class_2246.field_10405.method_40142()), 1.0), new ConstantWeightRandomList.RandomAccessConstantWeightRandomList<class_6880.class_6883>(List.of(class_2246.field_10596.method_40142(), class_2246.field_10207.method_40142()), 1.0), new ConstantWeightRandomList.RandomAccessConstantWeightRandomList<class_6880.class_6883>(List.of(class_2246.field_10625.method_40142(), class_2246.field_9990.method_40142()), 1.0));

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public ColumnRestriction getRestrictions() {
            return this.restrictions;
        }

        public CoordinateFunctions.CoordinateSupplier<class_2680> mainSupplier() {
            return BlockStateSupplier.forBlocks(this.main);
        }

        public CoordinateFunctions.CoordinateSupplier<class_2680> slabSupplier(class_2771 slabType) {
            return BlockStateSupplier.forBlocks(this.slab).with(class_2482.field_11501, slabType);
        }

        public CoordinateFunctions.CoordinateSupplier<class_2680> stairsSupplier(class_2760 half, class_2350 facing, class_2778 shape) {
            return BlockStateSupplier.forBlocks(this.stairs).with(class_2510.field_11572, half).with(class_2510.field_11571, facing).with(class_2510.field_11565, shape);
        }

        public CoordinateFunctions.CoordinateSupplier<class_2680> wallSupplier(class_4778 north, class_4778 east, class_4778 south, class_4778 west, boolean up) {
            return BlockStateSupplier.forBlocks(this.wall).with(WallBlockVersions.NORTH_SHAPE, north).with(WallBlockVersions.EAST_SHAPE, east).with(WallBlockVersions.SOUTH_SHAPE, south).with(WallBlockVersions.WEST_SHAPE, west);
        }

        public CoordinateFunctions.CoordinateSupplier<class_2680> barsSupplier(boolean north, boolean east, boolean south, boolean west) {
            return new SingleStateSupplier(class_2246.field_10576.method_9564()).with(class_2310.field_10905, north).with(class_2310.field_10907, east).with(class_2310.field_10904, south).with(class_2310.field_10903, west);
        }

        public CoordinateFunctions.CoordinateSupplier<class_2680> air() {
            return new SingleStateSupplier(BlockStates.AIR);
        }
    }

    public static abstract class DecorationDungeonPiece
    extends DungeonPiece
    implements LabyrinthLayout.DecorationPiece {
        public DecorationDungeonPiece(class_3773 type, int length, class_3341 boundingBox, class_6880<class_3195> owningStructure, int paletteIndex) {
            super(type, length, boundingBox, owningStructure, paletteIndex);
        }

        public DecorationDungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }
    }

    public static abstract class HallDungeonPiece
    extends DungeonPiece
    implements LabyrinthLayout.HallPiece,
    RawGenerationStructure.RawGenerationStructurePiece {
        public static final int BARS_BIT = 2;
        public byte sidewaysness;

        public HallDungeonPiece(class_3773 type, int chainLength, class_3341 boundingBox, class_6880<class_3195> owningStructure, int paletteIndex) {
            super(type, chainLength, boundingBox, owningStructure, paletteIndex);
        }

        public HallDungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            class_2520 class_25202 = nbt.method_10580("side");
            if (class_25202 instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                this.sidewaysness = number.method_10698();
            }
        }

        @Override
        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10567("side", this.sidewaysness);
        }

        public boolean hasBars() {
            return (this.variant & 2) != 0;
        }

        public void setBars(boolean bars) {
            this.variant = (byte)(bars ? this.variant | 2 : this.variant & 0xFFFFFFFD);
        }

        public int getLeft() {
            return this.sidewaysness << 24 >> 28;
        }

        public void setLeft(int left) {
            this.sidewaysness = (byte)(this.sidewaysness & 0xF | (left & 0xF) << 4);
        }

        public int getRight() {
            return this.sidewaysness << 28 >> 28;
        }

        public void setRight(int right) {
            this.sidewaysness = (byte)(this.sidewaysness & 0xF0 | right & 0xF);
        }

        @Override
        public Coordinator coordinator(class_5281 world, class_3341 limit) {
            return super.coordinator(world, limit).rotate1x(Directions.rotationOf(Directions.POSITIVE_X, this.method_14934()));
        }

        @Override
        public Coordinator coordinator(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            return super.coordinator(context).rotate1x(Directions.rotationOf(Directions.POSITIVE_X, this.method_14934()));
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        }
    }

    public static abstract class SpawnerDungeonPiece
    extends DecorationDungeonPiece {
        public final class_6880<class_1299<?>> spawnerType;

        public SpawnerDungeonPiece(class_3773 type, int length, class_3341 boundingBox, class_6880<class_3195> owningStructure, int paletteIndex, class_6880<class_1299<?>> spawnerType) {
            super(type, length, boundingBox, owningStructure, paletteIndex);
            this.spawnerType = spawnerType;
        }

        public SpawnerDungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            String string;
            class_2520 class_25202 = nbt.method_10580("entityType");
            if (class_25202 instanceof class_2519) {
                class_2519 string2 = (class_2519)class_25202;
                string = NbtVersions.stringValue(string2);
            } else {
                string = "minecraft:zombie";
            }
            String id = string;
            this.spawnerType = RegistryVersions.getEntry(class_7923.field_41177, class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)IdentifierVersions.create(id)));
        }

        @Override
        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10582("entityType", UnregisteredObjectException.getID(this.spawnerType).toString());
        }

        public void initSpawner(class_2338 pos, class_2636 spawner) {
            spawner.method_46408((class_1299)this.spawnerType.comp_349(), (class_5819)new Permuter(Permuter.permute(7052241378900527445L, (class_2382)pos)).mojang());
        }
    }

    public static abstract class ChestDungeonPiece
    extends DecorationDungeonPiece {
        public long seed;

        public ChestDungeonPiece(class_3773 type, int length, class_3341 boundingBox, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 facing, long seed) {
            super(type, length, boundingBox, owningStructure, paletteIndex);
            this.method_14926(facing);
            this.seed = seed;
        }

        public ChestDungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            class_2520 class_25202 = nbt.method_10580("seed");
            if (class_25202 instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                this.seed = number.method_10699();
            }
        }

        @Override
        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10544("seed", this.seed);
        }

        public void initChest(class_2338 pos, class_2595 chest) {
            class_2960 identifier = BigGlobeMod.modID("chests/advanced_dungeon");
            chest.method_54867(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)identifier), this.seed);
        }

        @Override
        public Coordinator coordinator(class_5281 world, class_3341 limit) {
            return super.coordinator(world, limit).rotate1x(Directions.rotationOf(class_2350.field_11043, this.method_14934()));
        }

        @Override
        public Coordinator coordinator(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            return super.coordinator(context).rotate1x(Directions.rotationOf(Directions.POSITIVE_X, this.method_14934()));
        }
    }

    public static class PitDungeonPiece
    extends DecorationDungeonPiece {
        public static final int LAVA_BIT = 2;
        public static final int WATER_BIT = 4;
        public static final int RADIUS_SHIFT = 3;
        public static final int RADIUS_MASK = 24;

        public PitDungeonPiece(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, int innerRadius, RandomGenerator random) {
            super(type, 0, new class_3341(x - innerRadius - 1, y - 2, z - innerRadius - 1, x + innerRadius + 1, y, z + innerRadius + 1), owningStructure, paletteIndex);
            this.setToRandomType(random);
            this.setInnerRadius(innerRadius);
        }

        public PitDungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void setToRandomType(RandomGenerator random) {
            this.variant = (byte)(this.variant | random.nextInt(3) << 1);
        }

        public int getInnerRadius() {
            return (this.variant & 0x18) >>> 3;
        }

        public void setInnerRadius(int innerRadius) {
            this.variant = (byte)(this.variant & 0xFFFFFFE7 | innerRadius << 3);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            int innerRadius = this.getInnerRadius();
            int outerRadius = innerRadius + 1;
            Coordinator root = this.coordinator(world, chunkBox);
            Palette palette = this.palette();
            root.setBlockStateCuboid(-outerRadius, -2, -outerRadius, outerRadius, -1, outerRadius, palette.mainSupplier());
            root.setBlockStateCuboid(-innerRadius, -1, -innerRadius, innerRadius, -1, innerRadius, this.getFiller());
            root.setBlockState(0, 0, 0, palette.barsSupplier(true, true, true, true));
            root.rotate4x90().setBlockStateLine(1, 0, 0, 1, 0, 0, innerRadius, palette.barsSupplier(false, true, false, true));
            root.rotate4x90().setBlockStateCuboid(1, 0, 1, innerRadius, 0, innerRadius, BlockStates.AIR);
        }

        public class_2680 getFiller() {
            return switch (this.variant & 6) {
                case 2 -> BlockStates.LAVA;
                case 4 -> BlockStates.WATER;
                default -> BlockStates.AIR;
            };
        }

        @Override
        public int y() {
            return this.boundingBox().method_35419();
        }
    }

    public static abstract class RoomDungeonPiece
    extends DungeonPiece
    implements LabyrinthLayout.RoomPiece,
    RawGenerationStructure.RawGenerationStructurePiece {
        public static final AutoCoder<DelayedEntryList<class_2975<?, ?>>> DECORATORS_CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(new ReifiedType<DelayedEntryList<class_2975<?, ?>>>(){});
        public static final int PIT_BIT = 2;
        public final RoomDungeonPiece[] connections = new RoomDungeonPiece[4];
        @Nullable
        public DelayedEntryList<class_2975<?, ?>> decorators;
        public boolean support;

        public RoomDungeonPiece(class_3773 type, int chainLength, class_3341 boundingBox, class_6880<class_3195> owningStructure, int paletteIndex, @Nullable DelayedEntryList<class_2975<?, ?>> decorators) {
            super(type, chainLength, boundingBox, owningStructure, paletteIndex);
            this.decorators = decorators;
        }

        public RoomDungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            class_2520 class_25202;
            class_2520 nbtDecorators = nbt.method_10580("decorators_v2");
            if (nbtDecorators != null) {
                try {
                    this.decorators = (DelayedEntryList)BigGlobeAutoCodec.AUTO_CODEC.decode(DECORATORS_CODER, (Object)nbtDecorators, (DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)BigGlobeMod.getCurrentServer().method_30611()));
                }
                catch (DecodeException exception) {
                    BigGlobeMod.LOGGER.error("Exception reading dungeon room decorator from NBT: ", (Throwable)exception);
                }
            }
            if ((class_25202 = nbt.method_10580("support")) instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                this.support = number.method_10698() != 0;
            }
        }

        @Override
        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            if (this.decorators != null) {
                nbt.method_10566("decorators_v2", (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(DECORATORS_CODER, this.decorators, (DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)BigGlobeMod.getCurrentServer().method_30611())));
            }
            nbt.method_10556("support", this.support);
        }

        public boolean hasPit() {
            return (this.variant & 2) != 0;
        }

        public void setPit(boolean pit) {
            this.variant = (byte)(pit ? this.variant | 2 : this.variant & 0xFFFFFFFD);
        }

        @Override
        public RoomDungeonPiece getConnectedRoom(class_2350 direction) {
            return this.connections[DirectionVersions.horizontal(direction)];
        }

        @Override
        public void setConnectedRoom(class_2350 direction, LabyrinthLayout.RoomPiece connection) {
            this.connections[DirectionVersions.horizontal((class_2350)direction)] = (RoomDungeonPiece)connection;
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            class_3341 chunkBox = WorldUtil.chunkBox(context.chunk);
            class_3341 intersection = WorldUtil.intersection(this.field_15315, chunkBox);
            if (intersection == null) {
                return;
            }
            class_2338.class_2339 pos = new class_2338.class_2339();
            CoordinateFunctions.CoordinateSupplier<class_2680> mainBlock = this.palette().mainSupplier();
            pos.method_33098(this.y());
            while (pos.method_10264() <= intersection.method_35419()) {
                pos.method_33099(intersection.method_35417());
                while (pos.method_10260() <= intersection.method_35420()) {
                    pos.method_33097(intersection.method_35415());
                    while (pos.method_10263() <= intersection.method_35418()) {
                        ChunkVersions.setBlockState(context.chunk, (class_2338)pos, pos.method_10263() == this.field_15315.method_35415() || pos.method_10263() == this.field_15315.method_35418() || pos.method_10264() == this.y() || pos.method_10264() == this.field_15315.method_35419() || pos.method_10260() == this.field_15315.method_35417() || pos.method_10260() == this.field_15315.method_35420() ? mainBlock.get(pos) : BlockStates.AIR, 2);
                        pos.method_33097(pos.method_10263() + 1);
                    }
                    pos.method_33099(pos.method_10260() + 1);
                }
                pos.method_33098(pos.method_10264() + 1);
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            class_2975<?, ?> feature;
            int x = this.x();
            int y = this.y();
            int z = this.z();
            if (this.decorators != null && RoomDungeonPiece.contains(chunkBox, x, y, z) && (feature = this.decorators.randomObject(random.method_43055())) != null) {
                feature.method_12862(world, chunkGenerator, (class_5819)new MojangPermuter(Permuter.permute(world.method_8412() ^ 0x265B4B7BF1BC7786L, x, y, z)), new class_2338(x, y, z));
            }
        }

        public static boolean contains(class_3341 box, int x, int y, int z) {
            return x >= box.method_35415() && x <= box.method_35418() && y >= box.method_35416() && y <= box.method_35419() && z >= box.method_35417() && z <= box.method_35420();
        }

        @Override
        @MustBeInvokedByOverriders
        public void addDecorations(LabyrinthLayout layout) {
            this.support = layout.random.nextBoolean() && !layout.isSharingFloor(this);
        }

        @Nullable
        public class_2350 getDeadEndDirection() {
            class_2350 result = null;
            for (class_2350 test : Directions.HORIZONTAL) {
                if (this.getConnectedRoom(test) == null) continue;
                if (result == null) {
                    result = test;
                    continue;
                }
                return null;
            }
            return result;
        }

        @Override
        public int y() {
            return this.hasPit() ? super.y() + 2 : super.y();
        }
    }

    public static abstract class DungeonPiece
    extends class_3443
    implements LabyrinthLayout.LabyrinthPiece {
        public static final AutoCoder<class_6880<class_3195>> STRUCTURE_CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder((ReifiedType)new ReifiedType<class_6880<class_3195>>(){});
        public byte variant;
        @Nullable
        public class_6880<class_3195> owningStructure;
        public int paletteIndex;
        public Palette cachedPalette;

        /*
         * Unable to fully structure code
         */
        public DungeonPiece(class_3773 type, int length, class_3341 boundingBox, @Nullable class_6880<class_3195> owningStructure, int paletteIndex) {
            super(type, length, boundingBox);
            this.owningStructure = owningStructure;
            this.paletteIndex = paletteIndex;
            if (owningStructure == null || !((var7_6 = owningStructure.comp_349()) instanceof AbstractDungeonStructure)) ** GOTO lbl-1000
            dungeon = (AbstractDungeonStructure)var7_6;
            if (paletteIndex >= 0 && paletteIndex < dungeon.palettes.size()) {
                v0 = dungeon.palettes.get(paletteIndex);
            } else lbl-1000:
            // 2 sources

            {
                v0 = Palette.COBBLE;
            }
            this.cachedPalette = v0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DungeonPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, nbt);
            Object object;
            class_2520 class_25202;
            class_2520 owningStructure;
            class_2520 class_25203 = nbt.method_10580("var");
            if (class_25203 instanceof class_2514) {
                class_2514 number = (class_2514)class_25203;
                this.variant = number.method_10698();
            }
            if ((owningStructure = nbt.method_10580("struct")) != null) {
                try {
                    this.owningStructure = (class_6880)BigGlobeAutoCodec.AUTO_CODEC.decode(STRUCTURE_CODER, (Object)owningStructure, (DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)context.comp_134()));
                }
                catch (DecodeException exception) {
                    throw new RuntimeException(exception);
                }
            }
            if ((class_25202 = nbt.method_10580("paletteIndex")) instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                v0 = number.method_10701();
            } else {
                v0 = this.paletteIndex = -1;
            }
            if (this.owningStructure != null && (object = this.owningStructure.comp_349()) instanceof AbstractDungeonStructure) {
                AbstractDungeonStructure dungeon = (AbstractDungeonStructure)object;
                if (this.paletteIndex >= 0 && this.paletteIndex < dungeon.palettes.size()) {
                    this.cachedPalette = dungeon.palettes.get(this.paletteIndex);
                    return;
                }
            }
            this.cachedPalette = Palette.COBBLE;
        }

        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10567("var", this.variant);
            if (this.owningStructure != null) {
                nbt.method_10566("struct", (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(STRUCTURE_CODER, this.owningStructure, (DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)context.comp_134())));
            }
            nbt.method_10569("paletteIndex", this.paletteIndex);
        }

        @Override
        public class_3341 boundingBox() {
            return this.field_15315;
        }

        public Coordinator coordinator(class_5281 world, class_3341 limit) {
            return Coordinator.forWorld(world, 2).inBox(limit, false).translate(this.x(), this.y(), this.z());
        }

        public Coordinator coordinator(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            return Coordinator.forChunk(context.chunk).inBox(WorldUtil.chunkBox(context.chunk), false).translate(this.x(), this.y(), this.z());
        }

        public Palette palette() {
            return this.cachedPalette;
        }
    }
}

