/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.megaTree;

import builderb0y.autocodec.annotations.Hidden;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.blocks.BigGlobeBlockTags;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.dynamicRegistries.WoodPalette;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.structures.DataStructurePiece;
import builderb0y.bigglobe.structures.megaTree.MegaTreeBranch;
import builderb0y.bigglobe.structures.megaTree.MegaTreeStructure;
import builderb0y.bigglobe.util.Vectors;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import java.util.random.RandomGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.joml.Vector3d;

@Deprecated
public class MegaTreeBall
extends DataStructurePiece<Data> {
    public MegaTreeBall(class_3773 type, MegaTreeStructure structure, class_6880<WoodPalette> palette, double x, double y, double z, double radius, int currentStep, int totalSteps) {
        this(type, new Data(structure, x, y, z, radius, currentStep, totalSteps, palette));
    }

    public MegaTreeBall(class_3773 type, Data data) {
        super(type, 0, null, data);
        double extraLeafRadius = ((Data)this.data).extraLeafRadius();
        double totalRadius = data.radius + extraLeafRadius;
        this.field_15315 = WorldUtil.createBlockBox(BigGlobeMath.ceilI(data.x - totalRadius), BigGlobeMath.ceilI(data.y - totalRadius), BigGlobeMath.ceilI(data.z - totalRadius), BigGlobeMath.floorI(data.x + totalRadius), BigGlobeMath.floorI(data.y + totalRadius), BigGlobeMath.floorI(data.z + totalRadius));
    }

    public MegaTreeBall(class_3773 type, MegaTreeStructure structure, class_6880<WoodPalette> palette, MegaTreeBranch branch, Vector3d position, double radius) {
        this(type, structure, palette, position.x, position.y, position.z, radius, branch.currentStep, branch.totalSteps);
    }

    public MegaTreeBall(class_3773 type, class_6625 context, class_2487 nbt) {
        super(type, context, nbt);
    }

    @Override
    public AutoCoder<Data> dataCoder() {
        return Data.CODER;
    }

    public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        ScriptedColumn scriptedColumn;
        class_2338.class_2339 pos = new class_2338.class_2339();
        ColumnScript.ColumnToDoubleScript.Holder snowChance = ((Data)this.data).actualStructure.data.snow_chance();
        if (snowChance != null && chunkGenerator instanceof BigGlobeScriptedChunkGenerator) {
            BigGlobeScriptedChunkGenerator scriptedGenerator = (BigGlobeScriptedChunkGenerator)chunkGenerator;
            scriptedColumn = scriptedGenerator.newColumn((class_5539)world, 0, 0, ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints());
        } else {
            scriptedColumn = null;
        }
        ScriptedColumn column = scriptedColumn;
        double centerX = ((Data)this.data).x;
        double centerY = ((Data)this.data).y;
        double centerZ = ((Data)this.data).z;
        double radiusSquared = BigGlobeMath.squareD(((Data)this.data).radius);
        long seed = Permuter.permute(world.method_8412() ^ 0x723173E214442521L, centerX, centerY, centerZ);
        Permuter permuter = new Permuter(seed);
        int minX = Math.max(this.field_15315.method_35415(), chunkBox.method_35415());
        int minZ = Math.max(this.field_15315.method_35417(), chunkBox.method_35417());
        int maxX = Math.min(this.field_15315.method_35418(), chunkBox.method_35418());
        int maxZ = Math.min(this.field_15315.method_35420(), chunkBox.method_35420());
        WoodPalette palette = (WoodPalette)((Data)this.data).wood.comp_349();
        boolean placedAnyLogs = false;
        pos.method_33097(minX);
        while (pos.method_10263() <= maxX) {
            double xSquared = BigGlobeMath.squareD((double)pos.method_10263() - centerX);
            pos.method_33099(minZ);
            while (pos.method_10260() <= maxZ) {
                double xzSquared = xSquared + BigGlobeMath.squareD((double)pos.method_10260() - centerZ);
                if (xzSquared < radiusSquared) {
                    double chord = Math.sqrt(radiusSquared - xzSquared);
                    int minY = Math.max(BigGlobeMath.ceilI(centerY - chord), chunkBox.method_35416());
                    int maxY = Math.min(BigGlobeMath.floorI(centerY + chord), chunkBox.method_35419());
                    pos.method_33098(maxY);
                    while (pos.method_10264() >= minY && this.canLogReplace(world.method_8320((class_2338)pos))) {
                        world.method_8652((class_2338)pos, palette.woodState(permuter, class_2350.class_2351.field_11052), 18);
                        placedAnyLogs = true;
                        pos.method_33098(pos.method_10264() - 1);
                    }
                    pos.method_33098(minY);
                    while (pos.method_10264() <= maxY && this.canLogReplace(world.method_8320((class_2338)pos))) {
                        world.method_8652((class_2338)pos, palette.woodState(permuter, class_2350.class_2351.field_11052), 18);
                        placedAnyLogs = true;
                        pos.method_33098(pos.method_10264() + 1);
                    }
                    this.placeSnow(world, pos.method_33098(maxY + 1), column, snowChance, permuter);
                }
                pos.method_33099(pos.method_10260() + 1);
            }
            pos.method_33097(pos.method_10263() + 1);
        }
        if (!placedAnyLogs) {
            MegaTreeBall.setToRound(pos, centerX, centerY, centerZ);
            if (chunkBox.method_14662((class_2382)pos)) {
                world.method_8652((class_2338)pos, palette.woodState(permuter, class_2350.class_2351.field_11052), 18);
            }
        }
        double extraLeafRadius = ((Data)this.data).extraLeafRadius();
        int leafCount = Permuter.roundRandomlyI(permuter.nextLong(), BigGlobeMath.squareD(extraLeafRadius * 2.0));
        if (leafCount > 0) {
            Vector3d unitGenerator = new Vector3d();
            for (int i = 0; i < leafCount; ++i) {
                Vectors.setInSphere(unitGenerator, (RandomGenerator)permuter, permuter.nextDouble() * extraLeafRadius + ((Data)this.data).radius).add(centerX, centerY, centerZ);
                MegaTreeBall.setToRound(pos, unitGenerator.x, unitGenerator.y, unitGenerator.z);
                if (pos.method_10263() < minX || pos.method_10263() > maxX || pos.method_10260() < minZ || pos.method_10260() > maxZ) continue;
                int topY = pos.method_10264();
                int bits = permuter.nextInt() | 1;
                while ((bits & 1) != 0 && this.canLeavesReplace(world.method_8320((class_2338)pos))) {
                    world.method_8652((class_2338)pos, palette.leavesState(permuter, 7, true, false), 18);
                    bits >>>= 1;
                    pos.method_33098(pos.method_10264() - 1);
                }
                this.placeSnow(world, pos.method_33098(topY + 1), column, snowChance, permuter);
            }
        }
    }

    public boolean canLogReplace(class_2680 state) {
        return BlockStateVersions.isReplaceable(state) || state.method_26164(BigGlobeBlockTags.TREE_LOG_REPLACEABLES);
    }

    public boolean canLeavesReplace(class_2680 state) {
        return state.method_26215() || state.method_26204() instanceof class_2488;
    }

    public void placeSnow(class_5281 world, class_2338.class_2339 pos, ScriptedColumn column, ColumnScript.ColumnToDoubleScript.Holder snowChance, Permuter permuter) {
        if (column != null) {
            column.setParamsUnchecked(column.params.at(pos.method_10263(), pos.method_10260()));
            if (world.method_22347((class_2338)pos) && Permuter.nextChancedBoolean((RandomGenerator)permuter, snowChance.get(column))) {
                world.method_8652((class_2338)pos, BlockStates.SNOW, 18);
            }
        }
    }

    public static class_2338.class_2339 setToRound(class_2338.class_2339 pos, double x, double y, double z) {
        return pos.method_10103(BigGlobeMath.roundI(x), BigGlobeMath.roundI(y), BigGlobeMath.roundI(z));
    }

    public String toString() {
        return "MegaTreeBall(" + String.valueOf(this.data) + ")";
    }

    public record Data(class_6880<class_3195> structure, @Hidden MegaTreeStructure actualStructure, double x, double y, double z, double radius, int step, int totalSteps, class_6880<WoodPalette> wood) {
        public static final AutoCoder<Data> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(Data.class);

        public Data {
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || Double.isNaN(radius)) {
                throw new IllegalArgumentException("Attempt to create tree ball with NaN position or radius.");
            }
        }

        public Data(class_6880<class_3195> structure, double x, double y, double z, double radius, int step, int totalSteps, class_6880<WoodPalette> wood) {
            this(structure, (MegaTreeStructure)structure.comp_349(), x, y, z, radius, step, totalSteps, wood);
        }

        public Data(MegaTreeStructure actualStructure, double x, double y, double z, double radius, int step, int totalSteps, class_6880<WoodPalette> wood) {
            this(Data.getActualEntry(actualStructure), actualStructure, x, y, z, radius, step, totalSteps, wood);
        }

        public static class_6880<class_3195> getActualEntry(MegaTreeStructure structure) {
            return RegistryVersions.getEntry(RegistryVersions.getRegistry((class_5455)BigGlobeMod.getCurrentServer().method_30611(), class_7924.field_41246), structure);
        }

        public Vector3d position() {
            return new Vector3d(this.x, this.y, this.z);
        }

        public double extraLeafRadius() {
            return 64.0 / (double)(this.totalSteps - this.step + 32);
        }
    }
}

