/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.NumberData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.util.Symmetry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public record SymmetricOffset(@UseName(value="x") int offsetX, @UseName(value="y") int offsetY, @UseName(value="z") int offsetZ, @UseName(value="r") @UseCoder(name="RAW_SYMMETRY_CODER", in=SymmetricOffset.class, usage=MemberUsage.FIELD_CONTAINS_HANDLER) Symmetry symmetry) {
    public static final @UnknownNullability AutoCoder<Symmetry> RAW_SYMMETRY_CODER = Testing.enabled ? null : new AutoCoder.NamedCoder<Symmetry>("SymmetricOffset.RAW_SYMMETRY_CODER"){

        @ApiStatus.OverrideOnly
        @Nullable
        public <T_Encoded> Symmetry decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            if (context.isEmpty()) {
                return null;
            }
            return Symmetry.VALUES[context.forceAsNumber().intValue()];
        }

        @ApiStatus.OverrideOnly
        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, Symmetry> context) throws EncodeException {
            if (context.object == null) {
                return EmptyData.INSTANCE;
            }
            return new NumberData((byte)((Symmetry)((Object)context.object)).ordinal());
        }
    };
    public static final @UnknownNullability AutoCoder<SymmetricOffset> CODER = Testing.enabled ? null : BigGlobeAutoCodec.AUTO_CODEC.createCoder(SymmetricOffset.class);
    public static final SymmetricOffset IDENTITY = new SymmetricOffset(0, 0, 0, Symmetry.IDENTITY);

    public static SymmetricOffset fromCenter(int centerX, int centerZ, Symmetry symmetry) {
        return IDENTITY.rotateAround(centerX, centerZ, symmetry);
    }

    public SymmetricOffset rotate(Symmetry symmetry) {
        return new SymmetricOffset(symmetry.getX(this.offsetX, this.offsetZ), this.offsetY, symmetry.getZ(this.offsetX, this.offsetZ), symmetry.compose(this.symmetry));
    }

    public SymmetricOffset offset(int deltaX, int deltaY, int deltaZ) {
        return deltaX == 0 && deltaY == 0 && deltaZ == 0 ? this : new SymmetricOffset(this.offsetX + deltaX, this.offsetY + deltaY, this.offsetZ + deltaZ, this.symmetry);
    }

    public SymmetricOffset rotateAround(int x, int z, Symmetry symmetry) {
        return this.offset(-x, 0, -z).rotate(symmetry).offset(x, 0, z);
    }

    public int getX(int x, int y, int z) {
        return this.offsetX + this.symmetry.getX(x, z);
    }

    public int getY(int x, int y, int z) {
        return this.offsetY + y;
    }

    public int getZ(int x, int y, int z) {
        return this.offsetZ + this.symmetry.getZ(x, z);
    }

    public double getX(double x, double y, double z) {
        return (double)this.offsetX + this.symmetry.getX(x, z);
    }

    public double getY(double x, double y, double z) {
        return (double)this.offsetY + y;
    }

    public double getZ(double x, double y, double z) {
        return (double)this.offsetZ + this.symmetry.getZ(x, z);
    }

    public static class Testing {
        public static boolean enabled = false;
    }
}

