/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class TimestampedComputingCache<T_Key, T_Value> {
    public final double retainMillisecondsPerByte;
    public final ReentrantLock globalLock;
    public final BackingMap<T_Key, ValueHolder<T_Value>> values;
    public final AtomicInteger presentCount;

    public TimestampedComputingCache(double retainTime, double retainData) {
        this.retainMillisecondsPerByte = retainTime / retainData;
        this.globalLock = new ReentrantLock();
        this.values = new BackingMap(256);
        this.presentCount = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolder<T_Value> getHolder(T_Key key, boolean create) {
        this.globalLock.lock();
        try {
            ValueHolder holder = (ValueHolder)this.values.getAndMoveToLast(key);
            if (holder != null) {
                holder.timestamp = System.currentTimeMillis();
            } else if (create) {
                holder = new ValueHolder();
                this.values.putAndMoveToLast(key, holder);
            }
            this.doPurge();
            ValueHolder valueHolder = holder;
            return valueHolder;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    public int size() {
        return this.values.size();
    }

    public T_Value computeIfUnknown(T_Key key, Function<? super T_Key, ? extends T_Value> computer) {
        return this.checkOrCompute(key, this.getHolder(key, true), computer);
    }

    public T_Value check(T_Key key) {
        ValueHolder<T_Value> holder = this.getHolder(key, false);
        return holder != null ? (T_Value)this.checkOrCompute(key, holder, null) : null;
    }

    public CompletableFuture<T_Value> getAsync(Executor executor, T_Key key, Function<? super T_Key, ? extends T_Value> computer) {
        ValueHolder<T_Value> holder = this.getHolder(key, true);
        return CompletableFuture.supplyAsync(() -> this.checkOrCompute(key, holder, computer), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T_Value checkOrCompute(T_Key key, ValueHolder<T_Value> holder, Function<? super T_Key, ? extends T_Value> computer) {
        holder.lock.lock();
        try {
            if (holder.state != 2) {
                Object v = holder.value;
                return (T_Value)v;
            }
            if (computer != null) {
                T_Value oldValue = holder.get();
                T_Value newValue = computer.apply(key);
                holder.set(newValue);
                if (oldValue != null != (newValue != null)) {
                    this.presentCount.addAndGet(newValue != null ? 1 : -1);
                }
                T_Value T_Value = newValue;
                return T_Value;
            }
            T_Value T_Value = null;
            return T_Value;
        }
        finally {
            holder.lock.unlock();
        }
    }

    public void purge() {
        this.globalLock.lock();
        try {
            this.doPurge();
        }
        finally {
            this.globalLock.unlock();
        }
    }

    public void doPurge() {
        assert (this.globalLock.isHeldByCurrentThread());
        long deadline = System.currentTimeMillis() - (long)(this.retainMillisecondsPerByte * (double)Runtime.getRuntime().freeMemory());
        int removed = 0;
        while (!this.values.isEmpty()) {
            ValueHolder<T_Value> value = this.values.firstValue();
            if (value.timestamp >= deadline) break;
            this.values.removeFirst();
            if (value.state != 1) continue;
            ++removed;
        }
        this.presentCount.addAndGet(-removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(T_Key key) {
        ValueHolder holder;
        this.globalLock.lock();
        try {
            holder = (ValueHolder)this.values.get(key);
        }
        finally {
            this.globalLock.unlock();
        }
        if (holder != null) {
            holder.lock.lock();
            try {
                if (holder.state == 1) {
                    this.presentCount.decrementAndGet();
                }
                holder.clear();
            }
            finally {
                holder.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryInvalidate(T_Key key) {
        ValueHolder holder;
        if (this.globalLock.tryLock()) {
            try {
                holder = (ValueHolder)this.values.get(key);
            }
            finally {
                this.globalLock.unlock();
            }
        } else {
            return false;
        }
        if (holder == null) {
            return true;
        }
        if (holder.lock.tryLock()) {
            try {
                if (holder.state == 1) {
                    this.presentCount.decrementAndGet();
                }
                holder.clear();
                boolean bl = true;
                return bl;
            }
            finally {
                holder.lock.unlock();
            }
        }
        return false;
    }

    public void remove(T_Key key) {
        this.globalLock.lock();
        try {
            ValueHolder removed = (ValueHolder)this.values.remove(key);
            if (removed != null && removed.state == 1) {
                this.presentCount.decrementAndGet();
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    public void clear() {
        this.globalLock.lock();
        try {
            this.values.clear();
            this.presentCount.set(0);
        }
        finally {
            this.globalLock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " holding " + this.values.size() + " values for " + this.retainMillisecondsPerByte + " milliseconds per byte of free memory";
    }

    public static class BackingMap<T_Key, T_Value>
    extends Object2ObjectLinkedOpenHashMap<T_Key, T_Value> {
        public BackingMap() {
        }

        public BackingMap(int expected) {
            super(expected);
        }

        public T_Value firstValue() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            return (T_Value)this.value[this.first];
        }
    }

    public static class ValueHolder<V> {
        public static final byte ABSENT = 0;
        public static final byte PRESENT = 1;
        public static final byte UNKNOWN = 2;
        public final ReentrantLock lock = new ReentrantLock();
        public long timestamp = System.currentTimeMillis();
        public V value;
        public byte state = (byte)2;

        @Nullable
        public V get() {
            return this.value;
        }

        public void set(@Nullable V value) {
            this.value = value;
            this.state = value != null ? (byte)1 : 0;
        }

        public void clear() {
            this.value = null;
            this.state = (byte)2;
        }
    }

    public static class Units {
        public static double nanoseconds(double nanoseconds) {
            return nanoseconds / 1000000.0;
        }

        public static double microseconds(double microseconds) {
            return microseconds / 1000.0;
        }

        public static double milliseconds(double milliseconds) {
            return milliseconds;
        }

        public static double seconds(double seconds) {
            return seconds * 1000.0;
        }

        public static double bytes(double bytes) {
            return bytes;
        }

        public static double kilobytes(double kilobytes) {
            return kilobytes * 1024.0;
        }

        public static double megabytes(double megabytes) {
            return megabytes * 1048576.0;
        }

        public static double gigabytes(double gigabytes) {
            return gigabytes * 1.073741824E9;
        }
    }
}

