/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.bigglobe.features.RawFeature;
import builderb0y.bigglobe.features.SingleBlockFeature;
import builderb0y.bigglobe.noise.MojangPermuter;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public interface WorldOrChunk
extends class_1922 {
    public void setBlockState(class_2338 var1, class_2680 var2);

    public boolean placeBlockState(class_2338 var1, class_2680 var2);

    public void updateBlockState(class_2338 var1);

    public boolean canPlace(class_2338 var1, class_2680 var2);

    public void scheduleFluidTick(class_2338 var1, class_3610 var2);

    public long getSeed();

    public boolean placeFeature(class_2338 var1, class_2975<?, ?> var2, class_5819 var3);

    public void spawnEntity(Function<class_3218, class_1297> var1);

    public Coordinator coordinator();

    public void placeStructureTemplate(int var1, int var2, int var3, class_3499 var4, class_3492 var5, RandomGenerator var6);

    public static class ChunkDelegator
    implements WorldOrChunk {
        public final class_2791 chunk;
        public final long seed;
        public WorldWrapper worldWrapper;

        public ChunkDelegator(class_2791 chunk, long seed) {
            this.chunk = chunk;
            this.seed = seed;
        }

        public int method_31607() {
            return this.chunk.method_31607();
        }

        public int method_31605() {
            return this.chunk.method_31605();
        }

        public class_2680 method_8320(class_2338 pos) {
            return this.chunk.method_8320(pos);
        }

        public class_3610 method_8316(class_2338 pos) {
            return this.chunk.method_8316(pos);
        }

        @Override
        public void setBlockState(class_2338 pos, class_2680 state) {
            if (state != null) {
                class_2586 blockEntity;
                this.chunk.method_12010(pos, state, false);
                if (state.method_31709() && (blockEntity = ((class_2343)state.method_26204()).method_10123(pos, state)) != null) {
                    this.chunk.method_12007(blockEntity);
                }
            }
        }

        @Override
        public void updateBlockState(class_2338 pos) {
            this.chunk.method_12039(pos);
        }

        @Override
        public boolean placeBlockState(class_2338 pos, class_2680 state) {
            return SingleBlockFeature.placeEarly(this.chunk, pos, state, SingleBlockFeature.IS_REPLACEABLE);
        }

        @Override
        public boolean canPlace(class_2338 pos, class_2680 state) {
            return true;
        }

        @Override
        public void scheduleFluidTick(class_2338 pos, class_3610 state) {
        }

        @Override
        public long getSeed() {
            return this.seed;
        }

        @Override
        public boolean placeFeature(class_2338 pos, class_2975<?, ?> configuredFeature, class_5819 random) {
            class_3031 class_30312 = configuredFeature.comp_332();
            if (class_30312 instanceof RawFeature) {
                RawFeature rawFeature = (RawFeature)class_30312;
                return rawFeature.generate(this.worldWrapper, configuredFeature.comp_333(), pos);
            }
            throw new UnsupportedOperationException("The provided feature cannot generate during raw generation.");
        }

        @Override
        public void placeStructureTemplate(int x, int y, int z, class_3499 template, class_3492 data, RandomGenerator random) {
            throw new UnsupportedOperationException("Can't place structure templates during raw generation.");
        }

        public class_2586 method_8321(class_2338 pos) {
            return this.chunk.method_8321(pos);
        }

        @Override
        public void spawnEntity(Function<class_3218, class_1297> entitySupplier) {
            throw new UnsupportedOperationException("Can't spawn entities during raw generation.");
        }

        @Override
        public Coordinator coordinator() {
            return Coordinator.forChunk(this.chunk);
        }
    }

    public static class WorldDelegator
    implements WorldOrChunk {
        public final class_5281 world;

        public WorldDelegator(class_5281 world) {
            this.world = world;
        }

        public int method_31607() {
            return this.world.method_31607();
        }

        public int method_31605() {
            return this.world.method_31605();
        }

        public class_2680 method_8320(class_2338 pos) {
            return this.world.method_8320(pos);
        }

        public class_3610 method_8316(class_2338 pos) {
            return this.world.method_8316(pos);
        }

        @Override
        public void setBlockState(class_2338 pos, class_2680 state) {
            if (state != null) {
                WorldUtil.setBlockState((class_1936)this.world, pos, state, 18);
            }
        }

        @Override
        public void updateBlockState(class_2338 pos) {
            class_2680 newState;
            class_2680 oldState = this.method_8320(pos);
            if (oldState != (newState = class_2248.method_9510((class_2680)oldState, (class_1936)this.world, (class_2338)pos))) {
                this.setBlockState(pos, newState);
            }
        }

        @Override
        public boolean placeBlockState(class_2338 pos, class_2680 state) {
            return SingleBlockFeature.place((class_1936)this.world, pos, state, SingleBlockFeature.IS_REPLACEABLE);
        }

        @Override
        public boolean canPlace(class_2338 pos, class_2680 state) {
            return state.method_26184((class_4538)this.world, pos);
        }

        @Override
        public void scheduleFluidTick(class_2338 pos, class_3610 state) {
            this.world.method_64312(pos, state.method_15772(), state.method_15772().method_15789((class_4538)this.world));
        }

        @Override
        public long getSeed() {
            return this.world.method_8412();
        }

        @Override
        public boolean placeFeature(class_2338 pos, class_2975<?, ?> feature, class_5819 random) {
            return feature.method_12862(this.world, ((class_3215)this.world.method_8398()).method_12129(), random, pos);
        }

        @Override
        public void placeStructureTemplate(int x, int y, int z, class_3499 template, class_3492 data, RandomGenerator random) {
            template.method_15172((class_5425)this.world, new class_2338(x, y, z), data.method_15134(), data, (class_5819)MojangPermuter.from(random), 18);
        }

        public class_2586 method_8321(class_2338 pos) {
            return this.world.method_8321(pos);
        }

        @Override
        public void spawnEntity(Function<class_3218, class_1297> entitySupplier) {
            class_1297 entity = entitySupplier.apply(this.world.method_8410());
            if (entity != null) {
                this.world.method_30771(entity);
            }
        }

        @Override
        public Coordinator coordinator() {
            return Coordinator.forWorld(this.world, 18);
        }
    }
}

