/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util.coordinators;

import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import net.minecraft.class_2338;
import net.minecraft.class_3341;

public abstract class AbstractLimitAreaCoordinator
implements Coordinator {
    public final Coordinator delegate;

    public AbstractLimitAreaCoordinator(Coordinator delegate) {
        this.delegate = delegate;
    }

    public abstract boolean test(int var1, int var2, int var3);

    @Override
    public void genericPos(int x, int y, int z, CoordinateFunctions.CoordinatorRunnable callback) {
        if (this.test(x, y, z)) {
            callback.run(this.delegate, x, y, z);
        }
    }

    @Override
    public <A> void genericPos(int x, int y, int z, A arg, CoordinateFunctions.CoordinatorConsumer<A> callback) {
        if (this.test(x, y, z)) {
            callback.run(this.delegate, x, y, z, arg);
        }
    }

    @Override
    public <A, B> void genericPos(int x, int y, int z, A arg1, B arg2, CoordinateFunctions.CoordinatorBiConsumer<A, B> callback) {
        if (this.test(x, y, z)) {
            callback.run(this.delegate, x, y, z, arg1, arg2);
        }
    }

    @Override
    public <A, B, C> void genericPos(int x, int y, int z, A arg1, B arg2, C arg3, CoordinateFunctions.CoordinatorTriConsumer<A, B, C> callback) {
        if (this.test(x, y, z)) {
            callback.run(this.delegate, x, y, z, arg1, arg2, arg3);
        }
    }

    public static class LazyInBox
    extends AbstractLimitAreaCoordinator {
        public final class_3341 box;

        public LazyInBox(Coordinator delegate, class_3341 box) {
            super(delegate);
            this.box = box;
        }

        @Override
        public boolean test(int x, int y, int z) {
            return x >= this.box.method_35415() && x <= this.box.method_35418() && z >= this.box.method_35417() && z <= this.box.method_35420() && y >= this.box.method_35416() && y <= this.box.method_35419();
        }

        public int hashCode() {
            return this.delegate.hashCode() ^ System.identityHashCode(this.box);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LazyInBox)) {
                return false;
            }
            LazyInBox that = (LazyInBox)obj;
            return this.delegate.equals(that.delegate) && this.box == that.box;
        }

        public String toString() {
            return String.valueOf(this.delegate) + " in lazy box currently at (" + this.box.method_35415() + ", " + this.box.method_35416() + ", " + this.box.method_35417() + ") to (" + this.box.method_35418() + ", " + this.box.method_35419() + ", " + this.box.method_35420() + ")";
        }
    }

    public static class InBox
    extends AbstractLimitAreaCoordinator {
        public final int minX;
        public final int minY;
        public final int minZ;
        public final int maxX;
        public final int maxY;
        public final int maxZ;

        public InBox(Coordinator delegate, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            super(delegate);
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public InBox(Coordinator delegate, class_3341 box) {
            this(delegate, box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418(), box.method_35419(), box.method_35420());
        }

        @Override
        public boolean test(int x, int y, int z) {
            return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ && y >= this.minY && y <= this.maxY;
        }

        @Override
        public Coordinator inBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return this.delegate.inBox(Math.max(this.minX, minX), Math.max(this.minY, minY), Math.max(this.minZ, minZ), Math.min(this.maxX, maxX), Math.min(this.maxY, maxY), Math.min(this.maxZ, maxZ));
        }

        public int hashCode() {
            int hash = this.delegate.hashCode();
            hash = hash * 31 + this.minX;
            hash = hash * 31 + this.minY;
            hash = hash * 31 + this.minZ;
            hash = hash * 31 + this.maxX;
            hash = hash * 31 + this.maxY;
            hash = hash * 31 + this.maxZ;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InBox)) {
                return false;
            }
            InBox that = (InBox)obj;
            return this.delegate.equals(that.delegate) && this.minX == that.minX && this.minY == that.minY && this.minZ == that.minZ && this.maxX == that.maxX && this.maxY == that.maxY && this.maxZ == that.maxZ;
        }

        public String toString() {
            return String.valueOf(this.delegate) + " in box (" + this.minX + ", " + this.minY + ", " + this.minZ + ") to (" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ")";
        }
    }

    public static class LimitArea
    extends AbstractLimitAreaCoordinator {
        public final CoordinateFunctions.CoordinateBooleanSupplier predicate;
        public final class_2338.class_2339 scratchPos;

        public LimitArea(Coordinator delegate, CoordinateFunctions.CoordinateBooleanSupplier predicate) {
            super(delegate);
            this.predicate = predicate;
            this.scratchPos = new class_2338.class_2339();
        }

        @Override
        public boolean test(int x, int y, int z) {
            return this.predicate.test(this.scratchPos.method_10103(x, y, z));
        }

        @Override
        public Coordinator limitArea(CoordinateFunctions.CoordinateBooleanSupplier predicate) {
            return this.delegate.limitArea(this.predicate.and(predicate));
        }

        public int hashCode() {
            return this.delegate.hashCode() ^ this.predicate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LimitArea)) {
                return false;
            }
            LimitArea that = (LimitArea)obj;
            return this.delegate.equals(that.delegate) && this.predicate.equals(that.predicate);
        }

        public String toString() {
            return String.valueOf(this.delegate) + " limited by " + String.valueOf(this.predicate);
        }
    }
}

